/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog;

import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class CatalogParamsValidationUtils {
    public static void validateIdentifier(@Nullable String identifier, String context) throws CatalogValidationException {
        if (StringUtils.nullOrBlank((String)identifier)) {
            throw new CatalogValidationException("{} can't be null or blank.", context);
        }
    }

    public static void validateField(@Nullable Integer value, int min, @Nullable Integer max, String errorPrefix) {
        if (value == null) {
            return;
        }
        if (value < min || max != null && value > max) {
            throw new CatalogValidationException("{}: [value={}, min={}" + (Serializable)(max == null ? Character.valueOf(']') : ", max={}]."), errorPrefix, value, min, max);
        }
    }

    public static void validateZoneFilter(@Nullable String filter) {
        if (filter == null) {
            return;
        }
        try {
            JsonPath.compile((String)filter, (Predicate[])new Predicate[0]);
        }
        catch (InvalidPathException e) {
            String error = e.getMessage() == null ? "Unknown JsonPath compilation error." : e.getMessage();
            throw new CatalogValidationException("Invalid filter: [value={}, error={}].", e, filter, error);
        }
    }

    public static void validateStorageProfiles(List<StorageProfileParams> storageProfiles) {
        if (storageProfiles == null) {
            throw new CatalogValidationException("Storage profile cannot be null.");
        }
        if (storageProfiles.isEmpty()) {
            throw new CatalogValidationException("Storage profile cannot be empty.");
        }
    }

    public static void validateConsistencyMode(@Nullable ConsistencyMode consistencyMode) {
        if (consistencyMode != null && consistencyMode != ConsistencyMode.HIGH_AVAILABILITY && consistencyMode != ConsistencyMode.STRONG_CONSISTENCY) {
            throw new CatalogValidationException("Consistency mode is not supported: [mode={}].", new Object[]{consistencyMode});
        }
    }

    public static void validatePartition(@Nullable Integer partitions) {
        if (partitions != null) {
            throw new CatalogValidationException("Partitions number cannot be altered.");
        }
    }

    public static void ensureNoTableIndexOrSysViewExistsWithGivenName(CatalogSchemaDescriptor schema, String name) {
        if (schema.aliveIndex(name) != null) {
            throw new CatalogValidationException("Index with name '{}.{}' already exists.", schema.name(), name);
        }
        if (schema.table(name) != null) {
            if (schema.table(name).cache()) {
                throw new CatalogValidationException(IgniteStringFormatter.format((String)"Cache with name '{}.{}' already exists.", (Object[])new Object[]{schema.name(), name}));
            }
            throw new CatalogValidationException("Table with name '{}.{}' already exists.", schema.name(), name);
        }
        if (schema.systemView(name) != null) {
            throw new CatalogValidationException("System view with name '{}.{}' already exists.", schema.name(), name);
        }
        if (schema.sequence(name) != null) {
            throw new CatalogValidationException("Sequence with name '{}.{}' already exists", schema.name(), name);
        }
        if (schema.map(name) != null) {
            throw new CatalogValidationException("Map with name '{}.{}' already exists", schema.name(), name);
        }
    }

    public static void ensureZoneContainsTablesStorageProfile(CatalogZoneDescriptor zone, String tableStorageProfile) {
        Set zonesStorageProfile = zone.storageProfiles().profiles().stream().map(CatalogStorageProfileDescriptor::storageProfile).collect(Collectors.toSet());
        if (!zonesStorageProfile.contains(tableStorageProfile)) {
            throw new CatalogValidationException("Zone with name '{}' does not contain storage profile [storageProfile='{}'].", zone.name(), tableStorageProfile);
        }
    }

    public static void ensureNonSystemSchemaUsed(String schemaName) {
        if (schemaName != null && CatalogUtils.isSystemSchema(schemaName)) {
            throw new CatalogValidationException("Operations with system schemas are not allowed, schema: {}", schemaName);
        }
    }
}

