/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.storage.SnapshotEntry;
import org.apache.ignite.internal.catalog.storage.UpdateLog;
import org.apache.ignite.internal.catalog.storage.UpdateLogEvent;
import org.apache.ignite.internal.catalog.storage.VersionedUpdate;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogMarshallerException;
import org.apache.ignite.internal.catalog.storage.serialization.UpdateLogMarshaller;
import org.apache.ignite.internal.catalog.storage.serialization.UpdateLogMarshallerImpl;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureProcessor;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.EntryEvent;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.metastorage.Revisions;
import org.apache.ignite.internal.metastorage.WatchEvent;
import org.apache.ignite.internal.metastorage.WatchListener;
import org.apache.ignite.internal.metastorage.dsl.CompoundCondition;
import org.apache.ignite.internal.metastorage.dsl.Condition;
import org.apache.ignite.internal.metastorage.dsl.Conditions;
import org.apache.ignite.internal.metastorage.dsl.Iif;
import org.apache.ignite.internal.metastorage.dsl.Operation;
import org.apache.ignite.internal.metastorage.dsl.Operations;
import org.apache.ignite.internal.metastorage.dsl.StatementResult;
import org.apache.ignite.internal.metastorage.dsl.Statements;
import org.apache.ignite.internal.metastorage.dsl.Update;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class UpdateLogImpl
implements UpdateLog {
    private static final byte[] MAGIC_BYTES = "GRIDGAIN".getBytes(StandardCharsets.UTF_8);
    public static final ByteArray CATALOG_UPDATE_PREFIX = ByteArray.fromString((String)"catalog.update.");
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final MetaStorageManager metastore;
    private final FailureProcessor failureProcessor;
    private final UpdateLogMarshaller marshaller;
    private volatile UpdateLog.OnUpdateHandler onUpdateHandler;
    @Nullable
    private volatile UpdateListener listener;

    public UpdateLogImpl(MetaStorageManager metastore, FailureProcessor failureProcessor) {
        this.metastore = metastore;
        this.failureProcessor = failureProcessor;
        this.marshaller = new UpdateLogMarshallerImpl(2);
    }

    @TestOnly
    public UpdateLogImpl(MetaStorageManager metastore, FailureProcessor failureProcessor, UpdateLogMarshaller marshaller) {
        this.metastore = metastore;
        this.failureProcessor = failureProcessor;
        this.marshaller = marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        if (!this.busyLock.enterBusy()) {
            throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException());
        }
        try {
            UpdateListener listener;
            UpdateLog.OnUpdateHandler handler = this.onUpdateHandler;
            if (handler == null) {
                throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "Handler must be registered prior to component start");
            }
            this.recoverStateFromMetastore(handler);
            this.listener = listener = new UpdateListener(handler, this.marshaller);
            this.metastore.registerPrefixWatch(CatalogKey.updatePrefix(), (WatchListener)listener);
            Entry existingKey = this.metastore.getLocally(CatalogKey.catalogProduct());
            if (existingKey.empty()) {
                Update putProductKey = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)CatalogKey.catalogProduct(), (byte[])MAGIC_BYTES)}).yield(false);
                Iif writeProductKeyIfNotExist = Statements.iif((Condition)Conditions.notExists((ByteArray)CatalogKey.catalogProduct()), (Update)putProductKey, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
                CompletionStage completionStage = this.metastore.invoke(writeProductKeyIfNotExist).thenApply(ignore -> null);
                return completionStage;
            }
            CompletableFuture completableFuture = CompletableFutures.nullCompletedFuture();
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return CompletableFutures.nullCompletedFuture();
        }
        this.busyLock.block();
        UpdateListener listener = this.listener;
        this.listener = null;
        if (listener != null) {
            this.metastore.unregisterWatch((WatchListener)listener);
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public synchronized void registerUpdateHandler(UpdateLog.OnUpdateHandler handler) {
        if (this.onUpdateHandler != null) {
            throw new IllegalStateException("onUpdateHandler handler already registered");
        }
        this.onUpdateHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> append(VersionedUpdate update) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            int newVersion = update.version();
            int expectedVersion = newVersion - 1;
            CompoundCondition versionAsExpected = Conditions.or((Condition)Conditions.notExists((ByteArray)CatalogKey.currentVersion()), (Condition)Conditions.value((ByteArray)CatalogKey.currentVersion()).eq(ByteUtils.intToBytesKeepingOrder((int)expectedVersion)));
            Update appendUpdateEntryAndBumpVersion = Operations.ops((Operation[])new Operation[]{Operations.put((ByteArray)CatalogKey.update(newVersion), (byte[])this.marshaller.marshall(update)), Operations.put((ByteArray)CatalogKey.currentVersion(), (byte[])ByteUtils.intToBytesKeepingOrder((int)newVersion))}).yield(true);
            Iif iif = Statements.iif((Condition)versionAsExpected, (Update)appendUpdateEntryAndBumpVersion, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
            CompletionStage completionStage = this.metastore.invoke(iif).thenApply(StatementResult::getAsBoolean);
            return completionStage;
        }
        catch (CatalogMarshallerException ex) {
            this.failureProcessor.process(new FailureContext((Throwable)((Object)ex), "Failed to append update log."));
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture((Throwable)((Object)ex));
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> saveSnapshot(SnapshotEntry update) {
        if (!this.busyLock.enterBusy()) {
            return CompletableFuture.failedFuture((Throwable)new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)new NodeStoppingException()));
        }
        try {
            int oldSnapshotVersion;
            int snapshotVersion = update.version();
            Entry oldSnapshotEntry = this.metastore.getLocally(CatalogKey.snapshotVersion(), this.metastore.appliedRevision());
            int n = oldSnapshotVersion = oldSnapshotEntry.empty() ? 1 : ByteUtils.bytesToIntKeepingOrder((byte[])Objects.requireNonNull(oldSnapshotEntry.value()));
            if (oldSnapshotVersion >= snapshotVersion) {
                CompletableFuture completableFuture = CompletableFutures.falseCompletedFuture();
                return completableFuture;
            }
            byte[] snapshotVersionValue = ByteUtils.intToBytesKeepingOrder((int)snapshotVersion);
            CompoundCondition versionIsRecent = Conditions.or((Condition)Conditions.notExists((ByteArray)CatalogKey.snapshotVersion()), (Condition)Conditions.value((ByteArray)CatalogKey.snapshotVersion()).lt(snapshotVersionValue));
            Update saveSnapshotAndDropOutdatedUpdates = Operations.ops((Operation[])((Operation[])Stream.concat(Stream.of(Operations.put((ByteArray)CatalogKey.snapshotVersion(), (byte[])snapshotVersionValue), Operations.put((ByteArray)CatalogKey.update(snapshotVersion), (byte[])this.marshaller.marshall(update))), IntStream.range(oldSnapshotVersion, snapshotVersion).mapToObj(ver -> Operations.remove((ByteArray)CatalogKey.update(ver)))).toArray(Operation[]::new))).yield(true);
            Iif iif = Statements.iif((Condition)versionIsRecent, (Update)saveSnapshotAndDropOutdatedUpdates, (Update)Operations.ops((Operation[])new Operation[0]).yield(false));
            CompletionStage completionStage = this.metastore.invoke(iif).thenApply(StatementResult::getAsBoolean);
            return completionStage;
        }
        catch (CatalogMarshallerException ex) {
            this.failureProcessor.process(new FailureContext((Throwable)((Object)ex), "Failed to append update log."));
            CompletableFuture<Boolean> completableFuture = CompletableFuture.failedFuture((Throwable)((Object)ex));
            return completableFuture;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private void recoverStateFromMetastore(UpdateLog.OnUpdateHandler handler) {
        CompletableFuture recoveryFinishedFuture = this.metastore.recoveryFinishedFuture();
        assert (recoveryFinishedFuture.isDone());
        long recoveryRevision = ((Revisions)recoveryFinishedFuture.join()).revision();
        Entry earliestVersion = this.metastore.getLocally(CatalogKey.snapshotVersion(), recoveryRevision);
        int ver = earliestVersion.empty() ? 1 : ByteUtils.bytesToIntKeepingOrder((byte[])Objects.requireNonNull(earliestVersion.value()));
        this.recoverUpdates(handler, recoveryRevision, ver);
    }

    private void recoverUpdates(UpdateLog.OnUpdateHandler handler, long recoveryRevision, int ver) {
        ByteArray key;
        Entry entry;
        while (!(entry = this.metastore.getLocally(key = CatalogKey.update(ver++), recoveryRevision)).empty() && !entry.tombstone()) {
            UpdateLogEvent update = this.marshaller.unmarshall(Objects.requireNonNull(entry.value()));
            handler.handle(update, entry.timestamp(), entry.revision());
        }
    }

    private class UpdateListener
    implements WatchListener {
        private final UpdateLog.OnUpdateHandler onUpdateHandler;
        private final UpdateLogMarshaller marshaller;

        private UpdateListener(UpdateLog.OnUpdateHandler onUpdateHandler, UpdateLogMarshaller marshaller) {
            this.onUpdateHandler = onUpdateHandler;
            this.marshaller = marshaller;
        }

        public CompletableFuture<Void> onUpdate(WatchEvent event) {
            Collection entryEvents = event.entryEvents();
            ArrayList<CompletableFuture<Void>> handleFutures = new ArrayList<CompletableFuture<Void>>(entryEvents.size());
            for (EntryEvent eventEntry : entryEvents) {
                if (eventEntry.newEntry().tombstone()) continue;
                byte[] payload = eventEntry.newEntry().value();
                assert (payload != null) : eventEntry;
                try {
                    UpdateLogEvent update = this.marshaller.unmarshall(payload);
                    handleFutures.add(this.onUpdateHandler.handle(update, event.timestamp(), event.revision()));
                }
                catch (CatalogMarshallerException ex) {
                    UpdateLogImpl.this.failureProcessor.process(new FailureContext((Throwable)((Object)ex), "Failed to deserialize update."));
                    return CompletableFuture.failedFuture((Throwable)((Object)ex));
                }
            }
            return CompletableFuture.allOf((CompletableFuture[])handleFutures.toArray(CompletableFuture[]::new));
        }
    }

    private static class CatalogKey {
        private CatalogKey() {
            throw new AssertionError();
        }

        static ByteArray currentVersion() {
            return ByteArray.fromString((String)"catalog.version");
        }

        static ByteArray update(int version) {
            return ByteArray.fromString((String)("catalog.update." + version));
        }

        static ByteArray updatePrefix() {
            return CATALOG_UPDATE_PREFIX;
        }

        static ByteArray snapshotVersion() {
            return ByteArray.fromString((String)"catalog.snapshot.version");
        }

        static ByteArray catalogProduct() {
            return ByteArray.fromString((String)"catalog.product");
        }
    }
}

