/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.ignite.internal.catalog.storage.AlterTablePropertiesEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogEntrySerializerProvider;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class AlterTablePropertiesEntrySerializers {

    @CatalogSerializer(version=2, since="3.1.0")
    static class AlterTablePropertiesEntrySerializer
    implements CatalogObjectSerializer<AlterTablePropertiesEntry> {
        private final CatalogEntrySerializerProvider serializers;

        public AlterTablePropertiesEntrySerializer(CatalogEntrySerializerProvider serializers) {
            this.serializers = serializers;
        }

        @Override
        public AlterTablePropertiesEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int tableId = input.readVarIntAsInt();
            Double staleRowsFraction = CatalogSerializationUtils.readNullableDouble((DataInput)((Object)input));
            Long minStaleRowsCount = CatalogSerializationUtils.readNullableLong((DataInput)((Object)input));
            return new AlterTablePropertiesEntry(tableId, staleRowsFraction, minStaleRowsCount);
        }

        @Override
        public void writeTo(AlterTablePropertiesEntry value, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(value.tableId());
            CatalogSerializationUtils.writeNullableDouble(value.staleRowsFraction(), (DataOutput)((Object)output));
            CatalogSerializationUtils.writeNullableLong(value.minStaleRowsCount(), (DataOutput)((Object)output));
        }
    }
}

