/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogService;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAddSecondaryZoneCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.AddSecondaryZoneEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public class AlterTableAddSecondaryZoneCommand
extends AbstractTableCommand {
    private final String secondaryZoneName;
    @Nullable
    private final String secondaryStorageProfile;

    private AlterTableAddSecondaryZoneCommand(String tableName, String schemaName, boolean ifTableExists, String secondaryZoneName, @Nullable String secondaryStorageProfile) {
        super(schemaName, tableName, ifTableExists, true);
        this.secondaryZoneName = secondaryZoneName;
        this.secondaryStorageProfile = secondaryStorageProfile;
        this.validate();
    }

    public static AlterTableAddSecondaryZoneCommandBuilder builder() {
        return new Builder();
    }

    private void validate() {
        if (StringUtils.nullOrBlank((String)this.secondaryZoneName)) {
            throw new CatalogValidationException("Secondary zone name is not specified.");
        }
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        CatalogService catalogService = updateContext.catalogService();
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        int zoneId = table.zoneId();
        CatalogZoneDescriptor zone = CatalogUtils.zoneOrThrow(catalog, zoneId);
        Integer secondaryZoneId = table.secondaryZoneId();
        if (secondaryZoneId != null) {
            CatalogZoneDescriptor secondaryZone = catalog.zone(secondaryZoneId);
            if (secondaryZoneId == null) {
                throw new CatalogValidationException("Distribution zone with id '{}' not found.", secondaryZoneId);
            }
            throw new CatalogValidationException("Table '{}.{}' already has the secondary zone: {}.", this.schemaName, this.tableName, secondaryZone.name());
        }
        CatalogZoneDescriptor secondaryZone = CatalogUtils.zone(catalog, this.secondaryZoneName, true);
        if (zone.partitions() != secondaryZone.partitions()) {
            throw new CatalogValidationException("Primary and secondary zone should have the same number of partitions.");
        }
        AlterTableAddSecondaryZoneCommand.ensureSecondaryZoneNotUsedAsPrimary(catalogService, catalog, secondaryZone);
        String actualSecondaryStorageProfile = this.computeSecondaryStorageProfile(secondaryZone);
        CatalogParamsValidationUtils.ensureZoneContainsTablesStorageProfile(secondaryZone, actualSecondaryStorageProfile);
        AlterTableAddSecondaryZoneCommand.ensureSecondaryZoneHasInfiniteAutoAdjust(secondaryZone);
        return List.of(new AddSecondaryZoneEntry(table.id(), secondaryZone.id(), actualSecondaryStorageProfile));
    }

    private String computeSecondaryStorageProfile(CatalogZoneDescriptor secondaryZone) {
        if (this.secondaryStorageProfile == null) {
            List storageProfiles = secondaryZone.storageProfiles().profiles().stream().map(CatalogStorageProfileDescriptor::storageProfile).filter(storageProfile -> !"default".equals(storageProfile)).collect(Collectors.toList());
            if (storageProfiles.size() == 1) {
                return (String)storageProfiles.get(0);
            }
            throw new CatalogValidationException("Secondary storage profile is not specified and zone '{}' has more than 1 storage profile.", secondaryZone.name());
        }
        return this.secondaryStorageProfile;
    }

    private static class Builder
    implements AlterTableAddSecondaryZoneCommandBuilder {
        private String secondaryZoneName;
        @Nullable
        private String secondaryStorageProfile;
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;

        private Builder() {
        }

        @Override
        public AlterTableAddSecondaryZoneCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableAddSecondaryZoneCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableAddSecondaryZoneCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public AlterTableAddSecondaryZoneCommandBuilder secondaryZoneName(String secondaryZoneName) {
            this.secondaryZoneName = secondaryZoneName;
            return this;
        }

        @Override
        public AlterTableAddSecondaryZoneCommandBuilder secondaryStorageProfile(@Nullable String secondaryStorageProfile) {
            this.secondaryStorageProfile = secondaryStorageProfile;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableAddSecondaryZoneCommand(this.tableName, this.schemaName, this.ifTableExists, this.secondaryZoneName, this.secondaryStorageProfile);
        }
    }
}

