/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractCacheCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DropCacheCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.DropTableEntry;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class DropCacheCommand
extends AbstractCacheCommand {
    public static DropCacheCommandBuilder builder() {
        return new Builder();
    }

    private DropCacheCommand(String schemaName, String cacheName, boolean ifExists) throws CatalogValidationException {
        super(schemaName, cacheName, ifExists);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor cache = CatalogUtils.cache(schema, this.cacheName, !this.ifTableExists);
        if (cache == null) {
            return List.of();
        }
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Arrays.stream(schema.indexes()).filter(index -> index.tableId() == cache.id()).forEach(index -> updateEntries.add(new RemoveIndexEntry(index.id())));
        updateEntries.add(new DropTableEntry(cache.id()));
        return updateEntries;
    }

    private static class Builder
    implements DropCacheCommandBuilder {
        private String schemaName;
        private String cacheName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropCacheCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public DropCacheCommandBuilder cacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        @Override
        public DropCacheCommandBuilder ifCacheExists(boolean ifTableExists) {
            this.ifExists = ifTableExists;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new DropCacheCommand(this.schemaName, this.cacheName, this.ifExists);
        }
    }
}

