/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractSequenceCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.CreateSequenceCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.NewSequenceEntry;
import org.apache.ignite.internal.catalog.storage.NewTableEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.sql.ColumnType;

public class CreateSequenceCommand
extends AbstractSequenceCommand {
    private final long increment;
    private final long minvalue;
    private final long maxvalue;
    private final long start;
    private final long cache;

    public static CreateSequenceCommandBuilder builder() {
        return new Builder();
    }

    private CreateSequenceCommand(String schemaName, String sequenceName, boolean ifNotExists, long increment, long minvalue, long maxvalue, long start, long cache) {
        super(schemaName, sequenceName, ifNotExists);
        this.increment = increment;
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.start = start;
        this.cache = cache;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        if (this.ifExists && schema.sequence(this.sequenceName) != null) {
            return List.of();
        }
        int id = catalog.objectIdGenState();
        int sequenceId = id++;
        int tableId = id++;
        int pkIndexId = id++;
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, "SYSTEM");
        CatalogSequenceDescriptor sequence = this.sequenceDescriptor(schema, sequenceId, tableId);
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>(6);
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        if (defaultZone == null) {
            defaultZone = CatalogUtils.createDefaultZoneDescriptor(catalog, id++, updateEntries);
        }
        CatalogTableDescriptor table = this.tableDescriptor(catalog, defaultZone, systemSchema, sequenceId, tableId, pkIndexId);
        CatalogIndexDescriptor pkIndex = this.indexDescriptor(systemSchema, table);
        updateEntries.add(new NewSequenceEntry(sequence));
        updateEntries.add(new NewTableEntry(table));
        updateEntries.add(new NewIndexEntry(pkIndex));
        updateEntries.add(new ObjectIdGenUpdateEntry(id - catalog.objectIdGenState()));
        return updateEntries;
    }

    private CatalogSequenceDescriptor sequenceDescriptor(CatalogSchemaDescriptor schema, int sequenceId, int tableId) {
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.sequenceName);
        return new CatalogSequenceDescriptor(sequenceId, tableId, schema.id(), this.sequenceName, this.increment, this.minvalue, this.maxvalue, this.start, this.cache);
    }

    private CatalogTableDescriptor tableDescriptor(Catalog catalog, CatalogZoneDescriptor defaultZone, CatalogSchemaDescriptor schema, int sequenceId, int tableId, int pkIndexId) {
        String tableName = "SEQ_" + sequenceId;
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, tableName);
        String storageProfile = defaultZone.storageProfiles().defaultProfile().storageProfile();
        List<CatalogTableColumnDescriptor> columns = Stream.of(ColumnParams.builder().name("ID").type(ColumnType.INT64).build(), ColumnParams.builder().name("LAST_VALUE").type(ColumnType.INT64).nullable(true).build()).map(c -> CatalogUtils.fromParams(catalog, c)).collect(Collectors.toList());
        CatalogTableSchemaVersions versions = new CatalogTableSchemaVersions(new CatalogTableSchemaVersions.TableVersion(columns));
        return CatalogTableDescriptor.builder().id(tableId).schemaId(schema.id()).primaryKeyIndexId(pkIndexId).name(tableName).zoneId(defaultZone.id()).schemaVersions(versions).primaryKeyColumns(IntList.of((int)versions.latestVersionColumns().get(0).id())).storageProfile(storageProfile).build();
    }

    private CatalogIndexDescriptor indexDescriptor(CatalogSchemaDescriptor schema, CatalogTableDescriptor table) {
        String indexName = CatalogUtils.pkIndexName(this.sequenceName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, indexName);
        return new CatalogHashIndexDescriptor(table.primaryKeyIndexId(), indexName, table.id(), true, CatalogIndexStatus.AVAILABLE, table.primaryKeyColumns(), true);
    }

    private static class Builder
    implements CreateSequenceCommandBuilder {
        private String schemaName;
        private String sequenceName;
        private boolean ifNotExists;
        private long increment;
        private long minvalue;
        private long maxvalue;
        private long start;
        private long cache;

        private Builder() {
        }

        @Override
        public CreateSequenceCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder sequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder ifNotExists(boolean ifNotExists) {
            this.ifNotExists = ifNotExists;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder increment(long increment) {
            this.increment = increment;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder minvalue(long minvalue) {
            this.minvalue = minvalue;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder maxvalue(long maxvalue) {
            this.maxvalue = maxvalue;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder start(long start) {
            this.start = start;
            return this;
        }

        @Override
        public CreateSequenceCommandBuilder cache(long cache) {
            this.cache = cache;
            return this;
        }

        @Override
        public CreateSequenceCommand build() {
            return new CreateSequenceCommand(this.schemaName, this.sequenceName, this.ifNotExists, this.increment, this.minvalue, this.maxvalue, this.start, this.cache);
        }
    }
}

