/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.IndexNotFoundValidationException;
import org.apache.ignite.internal.catalog.commands.ColumnParams;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.commands.DeferredDefaultValue;
import org.apache.ignite.internal.catalog.commands.StorageProfileParams;
import org.apache.ignite.internal.catalog.commands.TypeChangeValidationListener;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfilesDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.catalog.descriptors.ConsistencyMode;
import org.apache.ignite.internal.catalog.storage.NewZoneEntry;
import org.apache.ignite.internal.catalog.storage.SetDefaultZoneEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CatalogUtils {
    public static final String DEFAULT_ZONE_NAME = "Default";
    public static final int DEFAULT_PARTITION_COUNT = 25;
    public static final int DEFAULT_REPLICA_COUNT = 1;
    public static final int DEFAULT_ZONE_QUORUM_SIZE = 1;
    public static final String DEFAULT_FILTER = "$..*";
    public static final int INFINITE_TIMER_VALUE = Integer.MAX_VALUE;
    public static final int IMMEDIATE_TIMER_VALUE = 0;
    public static final int MAX_PARTITION_COUNT = 65000;
    public static final int DEFAULT_PRECISION = 0;
    public static final int DEFAULT_SCALE = 0;
    public static final int MIN_TIME_PRECISION = 0;
    public static final int MAX_TIME_PRECISION = 9;
    public static final int UNSPECIFIED_PRECISION = -1;
    public static final int MIN_DECIMAL_PRECISION = 1;
    public static final int MAX_DECIMAL_PRECISION = Short.MAX_VALUE;
    public static final int MIN_DECIMAL_SCALE = 0;
    public static final int UNSPECIFIED_SCALE = -1;
    public static final int MAX_DECIMAL_SCALE = Short.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    public static final int DEFAULT_VARLEN_LENGTH = 65536;
    public static final int MAX_VARLEN_LENGTH = Integer.MAX_VALUE;
    public static final int MIN_VARLEN_PRECISION = 1;
    public static final int UNSPECIFIED_LENGTH = -1;
    public static final int MIN_INTERVAL_TYPE_PRECISION = 1;
    public static final int MAX_INTERVAL_TYPE_PRECISION = 10;
    public static final ConsistencyMode DEFAULT_CONSISTENCY_MODE = ConsistencyMode.STRONG_CONSISTENCY;
    public static final long DEFAULT_MIN_STALE_ROWS_COUNT = 500L;
    public static final double DEFAULT_STALE_ROWS_FRACTION = 0.2;
    private static final Map<ColumnType, Set<ColumnType>> ALTER_COLUMN_TYPE_TRANSITIONS = new EnumMap<ColumnType, Set<ColumnType>>(ColumnType.class);
    private static final Map<String, ColumnType> FUNCTIONAL_DEFAULT_FUNCTIONS = new HashMap<String, ColumnType>();
    public static final Set<String> SYSTEM_SCHEMAS;

    public static boolean isSystemSchema(String schemaName) {
        return SYSTEM_SCHEMAS.contains(schemaName);
    }

    public static CatalogStorageProfilesDescriptor fromParams(List<StorageProfileParams> params) {
        return new CatalogStorageProfilesDescriptor(params.stream().map(p -> new CatalogStorageProfileDescriptor(p.storageProfile())).collect(Collectors.toList()));
    }

    public static CatalogTableColumnDescriptor fromParams(Catalog catalog, ColumnParams params) {
        int precision = Objects.requireNonNullElse(params.precision(), 0);
        int scale = Objects.requireNonNullElse(params.scale(), 0);
        int length = Objects.requireNonNullElse(params.length(), CatalogUtils.defaultLength(params.type(), precision));
        DefaultValue defaultValue = params.defaultValueDefinition().derive(catalog, params.type());
        return new CatalogTableColumnDescriptor(params.name(), params.type(), params.nullable(), precision, scale, length, defaultValue);
    }

    public static boolean isSupportedColumnTypeChange(ColumnType source, ColumnType target) {
        Set<ColumnType> supportedTransitions = ALTER_COLUMN_TYPE_TRANSITIONS.get(source);
        return supportedTransitions != null && supportedTransitions.contains(target);
    }

    public static boolean validateColumnChange(CatalogTableColumnDescriptor origin, @Nullable ColumnType newType, @Nullable Integer newPrecision, @Nullable Integer newScale, @Nullable Integer newLength, TypeChangeValidationListener listener) {
        if (newType != null) {
            if (CatalogUtils.isSupportedColumnTypeChange(origin.type(), newType)) {
                if (origin.type().precisionAllowed() && newPrecision != null && newPrecision < origin.precision()) {
                    listener.onFailure("Decreasing the precision for column of type '{}' is not allowed.", origin.type(), newType);
                    return false;
                }
                if (origin.type().scaleAllowed() && newScale != null && newScale.intValue() != origin.scale()) {
                    listener.onFailure("Changing the scale for column of type '{}' is not allowed.", origin.type(), newType);
                    return false;
                }
                if (origin.type().lengthAllowed() && newLength != null && newLength < origin.length()) {
                    listener.onFailure("Decreasing the length for column of type '{}' is not allowed.", origin.type(), newType);
                    return false;
                }
                return true;
            }
            if (newType != origin.type()) {
                listener.onFailure("Changing the type from {} to {} is not allowed.", origin.type(), newType);
                return false;
            }
        }
        if (newPrecision != null && newPrecision.intValue() != origin.precision()) {
            listener.onFailure("Changing the precision for column of type '{}' is not allowed.", origin.type(), newType);
            return false;
        }
        if (newScale != null && newScale.intValue() != origin.scale()) {
            listener.onFailure("Changing the scale for column of type '{}' is not allowed.", origin.type(), newType);
            return false;
        }
        if (newLength != null && newLength.intValue() != origin.length()) {
            listener.onFailure("Changing the length for column of type '{}' is not allowed.", origin.type(), newType);
            return false;
        }
        return true;
    }

    public static boolean isColumnTypeChangeSupported(CatalogTableColumnDescriptor oldColumn, CatalogTableColumnDescriptor newColumn) {
        return CatalogUtils.validateColumnChange(oldColumn, newColumn.type(), newColumn.precision(), newColumn.scale(), newColumn.length(), TypeChangeValidationListener.NO_OP);
    }

    public static List<CatalogSchemaDescriptor> replaceSchema(CatalogSchemaDescriptor newSchema, Collection<CatalogSchemaDescriptor> schemas) {
        return schemas.stream().map(s -> {
            if (Objects.equals(s.id(), newSchema.id())) {
                return newSchema;
            }
            return s;
        }).collect(Collectors.toList());
    }

    public static CatalogSchemaDescriptor replaceTable(CatalogSchemaDescriptor schema, CatalogTableDescriptor newTableDescriptor) {
        CatalogTableDescriptor[] tableDescriptors = (CatalogTableDescriptor[])schema.tables().clone();
        for (int i = 0; i < tableDescriptors.length; ++i) {
            if (tableDescriptors[i].id() != newTableDescriptor.id()) continue;
            tableDescriptors[i] = newTableDescriptor;
            return new CatalogSchemaDescriptor(schema.id(), schema.name(), tableDescriptors, schema.indexes(), schema.systemViews(), schema.sequences(), schema.policies(), schema.maps(), newTableDescriptor.updateTimestamp());
        }
        throw new CatalogValidationException("Table with ID {} has not been found in schema with ID {}.", newTableDescriptor.id(), newTableDescriptor.schemaId());
    }

    public static CatalogSchemaDescriptor replaceIndex(CatalogSchemaDescriptor schema, CatalogIndexDescriptor newIndexDescriptor) {
        CatalogIndexDescriptor[] indexDescriptors = (CatalogIndexDescriptor[])schema.indexes().clone();
        for (int i = 0; i < indexDescriptors.length; ++i) {
            if (indexDescriptors[i].id() != newIndexDescriptor.id()) continue;
            indexDescriptors[i] = newIndexDescriptor;
            return new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), indexDescriptors, schema.systemViews(), schema.sequences(), schema.policies(), schema.maps(), newIndexDescriptor.updateTimestamp());
        }
        throw new CatalogValidationException("Index with ID {} has not been found in schema with ID {}.", newIndexDescriptor.id(), schema.id());
    }

    public static CatalogSchemaDescriptor replaceSequence(CatalogSchemaDescriptor schema, CatalogSequenceDescriptor newDescriptor) {
        CatalogSequenceDescriptor[] sequenceDescriptors = (CatalogSequenceDescriptor[])schema.sequences().clone();
        for (int i = 0; i < sequenceDescriptors.length; ++i) {
            if (sequenceDescriptors[i].id() != newDescriptor.id()) continue;
            sequenceDescriptors[i] = newDescriptor;
            return new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), sequenceDescriptors, schema.policies(), schema.maps(), newDescriptor.updateTimestamp());
        }
        throw new CatalogValidationException("Sequence with ID {} has not been found in schema with ID {}.", newDescriptor.id(), newDescriptor.schemaId());
    }

    public static int defaultLength(ColumnType columnType, int precision) {
        switch (columnType) {
            case STRING: 
            case BYTE_ARRAY: {
                return 65536;
            }
        }
        return Math.max(1, precision);
    }

    public static CatalogSchemaDescriptor schemaOrThrow(Catalog catalog, String name) throws CatalogValidationException {
        CatalogSchemaDescriptor schemaDescriptor = CatalogUtils.schema(catalog, name, true);
        assert (schemaDescriptor != null);
        return schemaDescriptor;
    }

    public static CatalogSchemaDescriptor schemaOrThrow(Catalog catalog, int schemaId) throws CatalogValidationException {
        CatalogSchemaDescriptor schema = catalog.schema(schemaId);
        if (schema == null) {
            throw new CatalogValidationException("Schema with ID '{}' not found.", schemaId);
        }
        return schema;
    }

    @Nullable
    public static CatalogSchemaDescriptor schema(Catalog catalog, String name, boolean shouldThrowIfNotExists) throws CatalogValidationException {
        CatalogSchemaDescriptor schema = catalog.schema(name = Objects.requireNonNull(name, "schemaName"));
        if (schema == null && shouldThrowIfNotExists) {
            throw new CatalogValidationException("Schema with name '{}' not found.", name);
        }
        return schema;
    }

    @Nullable
    public static CatalogTableDescriptor table(CatalogSchemaDescriptor schema, String name, boolean shouldThrowIfNotExists) throws CatalogValidationException {
        CatalogTableDescriptor table = schema.table(name = Objects.requireNonNull(name, "tableName"));
        if (table == null || table.cache()) {
            if (shouldThrowIfNotExists) {
                throw new CatalogValidationException("Table with name '{}.{}' not found.", schema.name(), name);
            }
            return null;
        }
        if (table.isLockedForAccess()) {
            throw new CatalogValidationException("Unable to access table '{}.{}', because access to it has been locked by an ongoing Snapshot restoration.", schema.name(), name);
        }
        return table;
    }

    static CatalogTableColumnDescriptor columnOrThrow(String schemaName, CatalogTableDescriptor tableDescriptor, String columnName) {
        CatalogTableColumnDescriptor column = tableDescriptor.column(columnName);
        if (column == null) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column with name '{}' not found in {} '{}.{}'.", (Object[])new Object[]{columnName, tableDescriptor.cache() ? "cache" : "table", schemaName, tableDescriptor.name()}));
        }
        return column;
    }

    public static CatalogTableDescriptor tableOrCache(CatalogSchemaDescriptor schema, String name) throws CatalogValidationException {
        CatalogTableDescriptor table = schema.table(name = Objects.requireNonNull(name, "tableName"));
        if (table == null) {
            throw new CatalogValidationException("Table with name '{}.{}' not found.", schema.name(), name);
        }
        if (table.isLockedForAccess()) {
            assert (!table.cache());
            throw new CatalogValidationException("Unable to access table {}, because an ongoing Snapshot restoration has locked access to it.", name);
        }
        return table;
    }

    public static CatalogTableDescriptor tableOrThrow(Catalog catalog, int tableId) throws CatalogValidationException {
        CatalogTableDescriptor table = catalog.table(tableId);
        if (table == null) {
            throw new CatalogValidationException("Table with ID '{}' not found.", tableId);
        }
        return table;
    }

    @Nullable
    public static CatalogTableDescriptor cache(CatalogSchemaDescriptor schema, String name, boolean shouldThrowIfNotExists) throws CatalogValidationException {
        CatalogTableDescriptor cache = schema.table(name = Objects.requireNonNull(name, "cacheName"));
        if (cache == null || !cache.cache()) {
            if (shouldThrowIfNotExists) {
                throw new CatalogValidationException("Cache with name '{}.{}' not found.", schema.name(), name);
            }
            return null;
        }
        return cache;
    }

    @Nullable
    public static CatalogSequenceDescriptor sequence(CatalogSchemaDescriptor schema, String name, boolean shouldThrowIfNotExists) {
        CatalogSequenceDescriptor sequence = schema.sequence(name = Objects.requireNonNull(name, "sequenceName"));
        if (sequence == null && shouldThrowIfNotExists) {
            throw new CatalogValidationException("Sequence with name '{}.{}' not found.", schema.name(), name);
        }
        return sequence;
    }

    public static CatalogSequenceDescriptor sequenceOrThrow(Catalog catalog, int sequenceId) {
        CatalogSequenceDescriptor sequence = catalog.sequence(sequenceId);
        if (sequence == null) {
            throw new CatalogValidationException("Sequence with ID '{}' not found.", sequenceId);
        }
        return sequence;
    }

    public static CatalogZoneDescriptor zoneByNameOrDefaultOrThrow(Catalog catalog, @Nullable String zoneName) throws CatalogValidationException {
        if (zoneName != null) {
            return CatalogUtils.zoneOrThrow(catalog, zoneName);
        }
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        if (defaultZone == null) {
            throw new CatalogValidationException("Default zone not found.");
        }
        return defaultZone;
    }

    public static boolean shouldCreateNewDefaultZone(Catalog catalog, @Nullable String zoneName) {
        return zoneName == null && catalog.defaultZone() == null;
    }

    public static CatalogZoneDescriptor createDefaultZoneDescriptor(Catalog catalog, int newDefaultZoneId, Collection<UpdateEntry> updateEntries) throws CatalogValidationException {
        CatalogUtils.checkDuplicateDefaultZoneName(catalog);
        CatalogZoneDescriptor defaultZone = CatalogUtils.createDefaultZoneDescriptor(newDefaultZoneId);
        updateEntries.add(new NewZoneEntry(defaultZone));
        updateEntries.add(new SetDefaultZoneEntry(defaultZone.id()));
        return defaultZone;
    }

    private static CatalogZoneDescriptor createDefaultZoneDescriptor(int newDefaultZoneId) {
        return new CatalogZoneDescriptor(newDefaultZoneId, DEFAULT_ZONE_NAME, 25, 1, 1, 0, Integer.MAX_VALUE, DEFAULT_FILTER, new CatalogStorageProfilesDescriptor(List.of(new CatalogStorageProfileDescriptor("default"))), ConsistencyMode.STRONG_CONSISTENCY);
    }

    private static void checkDuplicateDefaultZoneName(Catalog catalog) {
        if (catalog.zone(DEFAULT_ZONE_NAME) == null) {
            return;
        }
        throw new CatalogValidationException("Distribution zone with name '{}' already exists. Please specify zone name for the new table or set the zone as default", DEFAULT_ZONE_NAME);
    }

    @Nullable
    public static CatalogZoneDescriptor zone(Catalog catalog, String name, boolean shouldThrowIfNotExists) throws CatalogValidationException {
        CatalogZoneDescriptor zone = catalog.zone(name = Objects.requireNonNull(name, "zoneName"));
        if (zone == null && shouldThrowIfNotExists) {
            throw new CatalogValidationException("Distribution zone with name '{}' not found.", name);
        }
        return zone;
    }

    public static CatalogZoneDescriptor zoneOrThrow(Catalog catalog, String name) throws CatalogValidationException {
        return CatalogUtils.zone(catalog, name, true);
    }

    static CatalogZoneDescriptor zoneOrThrow(Catalog catalog, int zoneId) {
        CatalogZoneDescriptor zone = catalog.zone(zoneId);
        if (zone == null) {
            throw new CatalogValidationException("Distribution zone with id '{}' not found.", zoneId);
        }
        return zone;
    }

    public static CatalogValidationException duplicateDistributionZoneNameCatalogValidationException(String duplicatedZoneName) {
        return new CatalogValidationException("Distribution zone with name '{}' already exists.", duplicatedZoneName);
    }

    public static String pkIndexName(String tableName) {
        return tableName + "_PK";
    }

    static String generateNameForExpireColumnIndex(CatalogSchemaDescriptor schema, String tableName) {
        return CatalogUtils.generateNameForColumnIndex(schema, tableName, "EXPIRE_IDX");
    }

    static String generateNameForArchiveColumnIndex(CatalogSchemaDescriptor schema, String tableName) {
        return CatalogUtils.generateNameForColumnIndex(schema, tableName, "ARCHIVE_IDX");
    }

    private static String generateNameForColumnIndex(CatalogSchemaDescriptor schema, String tableName, String suffix) {
        String indexName;
        String candidate = indexName = tableName + "_" + suffix;
        while (true) {
            try {
                CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, candidate);
            }
            catch (CatalogValidationException ignored) {
                candidate = indexName + "_" + UUID.randomUUID();
                continue;
            }
            break;
        }
        return candidate;
    }

    @Nullable
    public static CatalogIndexDescriptor index(CatalogSchemaDescriptor schema, String name, boolean shouldThrowIfNotExists) throws IndexNotFoundValidationException {
        CatalogIndexDescriptor index = schema.aliveIndex(name);
        if (index == null && shouldThrowIfNotExists) {
            throw new IndexNotFoundValidationException(IgniteStringFormatter.format((String)"Index with name '{}.{}' not found.", (Object[])new Object[]{schema.name(), name}));
        }
        return index;
    }

    public static CatalogIndexDescriptor indexOrThrow(Catalog catalog, int indexId) throws IndexNotFoundValidationException {
        CatalogIndexDescriptor index = catalog.index(indexId);
        if (index == null) {
            throw new IndexNotFoundValidationException(IgniteStringFormatter.format((String)"Index with ID '{}' not found.", (Object[])new Object[]{indexId}));
        }
        return index;
    }

    public static HybridTimestamp clusterWideEnsuredActivationTimestamp(long activationTs, long maxClockSkewMillis) {
        return HybridTimestamp.hybridTimestamp((long)activationTs).addPhysicalTime(maxClockSkewMillis).roundUpToPhysicalTick();
    }

    @Nullable
    public static Integer defaultZoneIdOpt(Catalog catalog) {
        CatalogZoneDescriptor defaultZone = catalog.defaultZone();
        return defaultZone != null ? Integer.valueOf(defaultZone.id()) : null;
    }

    public static int getMaxPrecision(ColumnType columnType) {
        if (!columnType.precisionAllowed()) {
            return -1;
        }
        switch (columnType) {
            case DECIMAL: {
                return Short.MAX_VALUE;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return 9;
            }
            case DURATION: 
            case PERIOD: {
                return 10;
            }
        }
        throw new IllegalArgumentException("Unexpected column type: " + columnType);
    }

    public static int getMinPrecision(ColumnType columnType) {
        if (!columnType.precisionAllowed()) {
            return -1;
        }
        switch (columnType) {
            case DECIMAL: {
                return 1;
            }
            case TIME: 
            case DATETIME: 
            case TIMESTAMP: {
                return 0;
            }
            case DURATION: 
            case PERIOD: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unexpected column type: " + columnType);
    }

    public static int getMaxLength(ColumnType columnType) {
        if (!columnType.lengthAllowed()) {
            return -1;
        }
        switch (columnType) {
            case STRING: 
            case BYTE_ARRAY: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Unexpected column type: " + columnType);
    }

    public static int getMinLength(ColumnType columnType) {
        if (!columnType.lengthAllowed()) {
            return -1;
        }
        switch (columnType) {
            case STRING: 
            case BYTE_ARRAY: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unexpected column type: " + columnType);
    }

    public static int getMaxScale(ColumnType columnType) {
        if (!columnType.scaleAllowed()) {
            return -1;
        }
        if (columnType == ColumnType.DECIMAL) {
            return Short.MAX_VALUE;
        }
        throw new IllegalArgumentException("Unexpected column type: " + columnType);
    }

    public static int getMinScale(ColumnType columnType) {
        if (!columnType.scaleAllowed()) {
            return -1;
        }
        if (columnType == ColumnType.DECIMAL) {
            return 0;
        }
        throw new IllegalArgumentException("Unexpected column type: " + columnType);
    }

    static void ensureSupportedDefault(String columnName, ColumnType columnType, @Nullable DeferredDefaultValue defaultValue) {
        if (defaultValue == null || defaultValue.type() == DefaultValue.Type.CONSTANT) {
            return;
        }
        if (defaultValue.type() == DefaultValue.Type.FUNCTION_CALL) {
            String functionName = ((DeferredDefaultValue.FunctionCall)defaultValue).functionName();
            ColumnType returnType = FUNCTIONAL_DEFAULT_FUNCTIONS.get(functionName.toUpperCase());
            if (returnType == columnType) {
                return;
            }
            if (returnType != null) {
                throw new CatalogValidationException("Functional default type mismatch: [col={}, functionName={}, expectedType={}, actualType={}].", columnName, functionName, returnType, columnType);
            }
            throw new CatalogValidationException("Functional default contains unsupported function: [col={}, functionName={}].", columnName, functionName);
        }
        throw new CatalogValidationException("Default of unsupported kind: [col={}, defaultType={}].", new Object[]{columnName, defaultValue.type()});
    }

    static void ensureSupportedDefault(ColumnParams column) {
        CatalogUtils.ensureSupportedDefault(column.name(), column.type(), column.defaultValueDefinition());
    }

    static void ensureNonFunctionalDefault(String columnName, ColumnType columnType, DeferredDefaultValue defaultValue) {
        if (defaultValue == null || defaultValue.type() == DefaultValue.Type.CONSTANT) {
            return;
        }
        if (ColumnType.TIMESTAMP == columnType) {
            return;
        }
        if (defaultValue.type() == DefaultValue.Type.FUNCTION_CALL) {
            throw new CatalogValidationException("Functional defaults are not supported for non-primary key columns of type {} [col={}].", columnType, columnName);
        }
        throw new CatalogValidationException("Default of unsupported kind: [col={}, defaultType={}].", new Object[]{columnName, defaultValue.type()});
    }

    static void ensureTypeCanBeStored(String columnName, ColumnType columnType) {
        if (columnType == ColumnType.PERIOD || columnType == ColumnType.DURATION) {
            throw new CatalogValidationException("Column of type '{}' cannot be persisted [col={}].", columnType, columnName);
        }
    }

    public static int defaultQuorumSize(int replicas) {
        if (replicas <= 4) {
            return Math.min(replicas, 2);
        }
        return 3;
    }

    public static List<String> resolveColumnNames(CatalogTableDescriptor table, IntList columnIds) {
        ArrayList<String> names = new ArrayList<String>(columnIds.size());
        IntListIterator intListIterator = columnIds.iterator();
        while (intListIterator.hasNext()) {
            int columnId = (Integer)intListIterator.next();
            CatalogTableColumnDescriptor column = table.columnById(columnId);
            if (column == null) {
                throw new IllegalArgumentException("Column with id=" + columnId + " not found in table " + table);
            }
            names.add(column.name());
        }
        return names;
    }

    static {
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT8, EnumSet.of(ColumnType.INT8, ColumnType.INT16, ColumnType.INT32, ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT16, EnumSet.of(ColumnType.INT16, ColumnType.INT32, ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT32, EnumSet.of(ColumnType.INT32, ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.INT64, EnumSet.of(ColumnType.INT64));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.FLOAT, EnumSet.of(ColumnType.FLOAT, ColumnType.DOUBLE));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.DOUBLE, EnumSet.of(ColumnType.DOUBLE));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.STRING, EnumSet.of(ColumnType.STRING));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.BYTE_ARRAY, EnumSet.of(ColumnType.BYTE_ARRAY));
        ALTER_COLUMN_TYPE_TRANSITIONS.put(ColumnType.DECIMAL, EnumSet.of(ColumnType.DECIMAL));
        FUNCTIONAL_DEFAULT_FUNCTIONS.put("CURRENT_TIMESTAMP_PLUS_INTERVAL", ColumnType.DATETIME);
        FUNCTIONAL_DEFAULT_FUNCTIONS.put("CURRENT_TIMESTAMP_WITH_LOCAL_TIME_ZONE_PLUS_INTERVAL", ColumnType.TIMESTAMP);
        FUNCTIONAL_DEFAULT_FUNCTIONS.put("RAND_UUID", ColumnType.UUID);
        FUNCTIONAL_DEFAULT_FUNCTIONS.put("NEXTVAL", ColumnType.INT64);
        SYSTEM_SCHEMAS = Set.of("SYSTEM", "DEFINITION_SCHEMA", "INFORMATION_SCHEMA");
    }
}

