/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.storage.NewColumnsEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class NewColumnsEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class NewColumnsEntrySerializerV2
    implements CatalogObjectSerializer<NewColumnsEntry> {
        NewColumnsEntrySerializerV2() {
        }

        @Override
        public NewColumnsEntry readFrom(CatalogObjectDataInput in) throws IOException {
            List<CatalogTableColumnDescriptor> columns = in.readEntryList(CatalogTableColumnDescriptor.class);
            int tableId = in.readVarIntAsInt();
            return new NewColumnsEntry(tableId, columns);
        }

        @Override
        public void writeTo(NewColumnsEntry entry, CatalogObjectDataOutput out) throws IOException {
            out.writeEntryList(entry.descriptors());
            out.writeVarInt(entry.tableId());
        }
    }
}

