/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class AlterSequenceEntry
implements UpdateEntry,
Fireable {
    private final CatalogSequenceDescriptor newDescriptor;

    public AlterSequenceEntry(CatalogSequenceDescriptor newDescriptor) {
        this.newDescriptor = newDescriptor;
    }

    CatalogSequenceDescriptor newDescriptor() {
        return this.newDescriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.ALTER_SEQUENCE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SEQUENCE_ALTER;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CatalogEventParameters(causalityToken, catalogVersion){};
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSequenceDescriptor sequence = CatalogUtils.sequenceOrThrow(catalog, this.newDescriptor.id());
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, sequence.schemaId());
        this.newDescriptor.updateTimestamp(timestamp);
        List<CatalogSchemaDescriptor> schemas = CatalogUtils.replaceSchema(CatalogUtils.replaceSequence(schema, this.newDescriptor), catalog.schemas());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), schemas, CatalogUtils.defaultZoneIdOpt(catalog));
    }
}

