/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractSequenceCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.DefaultValue;
import org.apache.ignite.internal.catalog.commands.DropSequenceCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.DropSequenceEntry;
import org.apache.ignite.internal.catalog.storage.DropTableEntry;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;

public class DropSequenceCommand
extends AbstractSequenceCommand {
    public static DropSequenceCommandBuilder builder() {
        return new Builder();
    }

    private DropSequenceCommand(String schemaName, String sequenceName, boolean ifExists) {
        super(schemaName, sequenceName, ifExists);
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifExists);
        if (schema == null) {
            return List.of();
        }
        CatalogSequenceDescriptor sequence = CatalogUtils.sequence(schema, this.sequenceName, !this.ifExists);
        if (sequence == null) {
            return List.of();
        }
        CatalogSchemaDescriptor systemSchema = CatalogUtils.schemaOrThrow(catalog, "SYSTEM");
        this.validateDependencies(catalog, sequence);
        ArrayList<UpdateEntry> updateEntries = new ArrayList<UpdateEntry>();
        Arrays.stream(systemSchema.indexes()).filter(index -> index.tableId() == sequence.tableId()).forEach(index -> updateEntries.add(new RemoveIndexEntry(index.id())));
        updateEntries.add(new DropTableEntry(sequence.tableId()));
        updateEntries.add(new DropSequenceEntry(sequence.id()));
        return updateEntries;
    }

    private void validateDependencies(Catalog catalog, CatalogSequenceDescriptor sequence) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (CatalogTableDescriptor table : catalog.tables()) {
            for (CatalogTableColumnDescriptor column : table.columns()) {
                List<Object> parameters;
                Integer sequenceId;
                DefaultValue.FunctionCall functionCall;
                DefaultValue defaultValue = column.defaultValue();
                if (!(defaultValue instanceof DefaultValue.FunctionCall) || !"NEXTVAL".equalsIgnoreCase((functionCall = (DefaultValue.FunctionCall)defaultValue).functionName()) || !Objects.equals(sequenceId = (Integer)(parameters = functionCall.parameters()).get(2), sequence.id())) continue;
                String objectType = table.cache() ? "cache" : "table";
                dependencies.add(IgniteStringFormatter.format((String)"column {} of {} {}.{}", (Object[])new Object[]{column.name(), objectType, this.schemaName, table.name()}));
            }
        }
        if (!dependencies.isEmpty()) {
            dependencies.sort(Comparator.naturalOrder());
            String message = IgniteStringFormatter.format((String)"Sequence {} is used by {}.", (Object[])new Object[]{this.sequenceName, String.join((CharSequence)", ", dependencies)});
            throw new CatalogValidationException(message);
        }
    }

    private static class Builder
    implements DropSequenceCommandBuilder {
        private String schemaName;
        private String sequenceName;
        private boolean ifExists;

        private Builder() {
        }

        @Override
        public DropSequenceCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public DropSequenceCommandBuilder sequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
            return this;
        }

        @Override
        public DropSequenceCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public DropSequenceCommand build() {
            return new DropSequenceCommand(this.schemaName, this.sequenceName, this.ifExists);
        }
    }
}

