/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.CreateSchemaCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CreateSystemSchemaCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTablePolicyDescriptor;
import org.apache.ignite.internal.catalog.storage.NewSchemaEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class CreateSchemaCommand
implements CatalogCommand {
    private final String schemaName;
    private final boolean ifNotExists;

    private CreateSchemaCommand(String schemaName, boolean ifNotExists, boolean systemSchemaCommand) {
        CatalogParamsValidationUtils.validateIdentifier(schemaName, "Name of the schema");
        if (systemSchemaCommand) {
            if (!CatalogUtils.isSystemSchema(schemaName)) {
                throw new CatalogValidationException("Not a system schema, schema: '{}'", schemaName);
            }
        } else if (CatalogUtils.isSystemSchema(schemaName)) {
            throw new CatalogValidationException("Reserved system schema with name '{}' can't be created.", schemaName);
        }
        this.schemaName = schemaName;
        this.ifNotExists = ifNotExists;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        int id = catalog.objectIdGenState();
        CatalogSchemaDescriptor schema = catalog.schema(this.schemaName);
        if (this.ifNotExists && schema != null) {
            return List.of();
        }
        if (schema != null) {
            throw new CatalogValidationException("Schema with name '{}' already exists.", this.schemaName);
        }
        CatalogSchemaDescriptor newSchema = new CatalogSchemaDescriptor(id, this.schemaName, new CatalogTableDescriptor[0], new CatalogIndexDescriptor[0], new CatalogSystemViewDescriptor[0], new CatalogSequenceDescriptor[0], new CatalogTablePolicyDescriptor[0], new CatalogMapDescriptor[0], CatalogManager.INITIAL_TIMESTAMP);
        return List.of(new NewSchemaEntry(newSchema), new ObjectIdGenUpdateEntry(1));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SystemSchemaBuilder systemSchemaBuilder() {
        return new SystemSchemaBuilder();
    }

    public static class Builder
    implements CreateSchemaCommandBuilder {
        private String name;
        private boolean ifNotExists;

        @Override
        public CreateSchemaCommandBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateSchemaCommandBuilder ifNotExists(boolean value) {
            this.ifNotExists = value;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateSchemaCommand(this.name, this.ifNotExists, false);
        }
    }

    public static class SystemSchemaBuilder
    implements CreateSystemSchemaCommandBuilder {
        private String name;

        @Override
        public CreateSystemSchemaCommandBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateSchemaCommand(this.name, false, true);
        }
    }
}

