/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.systemviews;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.systemview.api.ClusterSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;
import org.jetbrains.annotations.Nullable;

public class TablesSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        return List.of(TablesSystemViewProvider.getTablesSystemView(catalogSupplier), TablesSystemViewProvider.getTableColumnsSystemView(catalogSupplier));
    }

    private static SystemView<?> getTablesSystemView(Supplier<Catalog> catalogSupplier) {
        Iterable tablesData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.tables().stream().map(table -> {
                String schemaName = Objects.requireNonNull(catalog.schema(table.schemaId()), "Schema must be not null.").name();
                String zoneName = Objects.requireNonNull(catalog.zone(table.zoneId()), "Zone must be not null.").name();
                return new TableWithSchemaAndZoneName((CatalogTableDescriptor)table, schemaName, zoneName);
            }).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(tablesData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("TABLES")).addColumn("SCHEMA_NAME", NativeTypes.STRING, entry -> entry.schemaName)).addColumn("TABLE_NAME", NativeTypes.STRING, entry -> entry.table.name())).addColumn("TABLE_ID", NativeTypes.INT32, entry -> entry.table.id())).addColumn("TABLE_PK_INDEX_ID", NativeTypes.INT32, entry -> entry.table.primaryKeyIndexId())).addColumn("ZONE_NAME", NativeTypes.STRING, entry -> entry.zoneName)).addColumn("STORAGE_PROFILE", NativeTypes.STRING, entry -> entry.table.storageProfile())).addColumn("TABLE_COLOCATION_COLUMNS", NativeTypes.STRING, entry -> TablesSystemViewProvider.concatColumns(entry.table.colocationColumns()))).addColumn("SCHEMA_ID", NativeTypes.INT32, entry -> entry.table.schemaId())).addColumn("ZONE_ID", NativeTypes.INT32, entry -> entry.table.zoneId())).addColumn("IS_CACHE", NativeTypes.BOOLEAN, entry -> entry.table.cache())).addColumn("SCHEMA", NativeTypes.STRING, entry -> entry.schemaName)).addColumn("NAME", NativeTypes.STRING, entry -> entry.table.name())).addColumn("ID", NativeTypes.INT32, entry -> entry.table.id())).addColumn("PK_INDEX_ID", NativeTypes.INT32, entry -> entry.table.primaryKeyIndexId())).addColumn("COLOCATION_KEY_INDEX", NativeTypes.STRING, entry -> TablesSystemViewProvider.concatColumns(entry.table.colocationColumns()))).addColumn("ZONE", NativeTypes.STRING, entry -> entry.zoneName)).dataProvider(viewDataPublisher)).build();
    }

    private static String concatColumns(List<String> columns) {
        if (columns == null || columns.isEmpty()) {
            return "NULL";
        }
        return String.join((CharSequence)", ", columns);
    }

    private static SystemView<?> getTableColumnsSystemView(Supplier<Catalog> catalogSupplier) {
        Iterable viewData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.tables().stream().flatMap(table -> table.columns().stream().map(columnDescriptor -> new ColumnMetadata(catalog.schema(table.schemaId()).name(), (CatalogTableDescriptor)table, (CatalogTableColumnDescriptor)columnDescriptor))).iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(viewData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("TABLE_COLUMNS")).addColumn("SCHEMA_NAME", NativeTypes.STRING, entry -> entry.schema)).addColumn("TABLE_NAME", NativeTypes.STRING, entry -> entry.tableDescriptor.name())).addColumn("TABLE_ID", NativeTypes.INT32, entry -> entry.tableDescriptor.id())).addColumn("COLUMN_NAME", NativeTypes.STRING, entry -> entry.columnDescriptor.name())).addColumn("COLUMN_TYPE", NativeTypes.STRING, entry -> entry.columnDescriptor.type().name())).addColumn("IS_NULLABLE_COLUMN", NativeTypes.BOOLEAN, entry -> entry.columnDescriptor.nullable())).addColumn("COLUMN_PRECISION", NativeTypes.INT32, entry -> entry.columnDescriptor.precision())).addColumn("COLUMN_SCALE", NativeTypes.INT32, entry -> entry.columnDescriptor.scale())).addColumn("COLUMN_LENGTH", NativeTypes.INT32, entry -> entry.columnDescriptor.length())).addColumn("COLUMN_ORDINAL", NativeTypes.INT32, ColumnMetadata::columnOrdinal)).addColumn("SCHEMA_ID", NativeTypes.INT32, entry -> entry.tableDescriptor.schemaId())).addColumn("PK_COLUMN_ORDINAL", NativeTypes.INT32, ColumnMetadata::pkColumnOrdinal)).addColumn("COLOCATION_COLUMN_ORDINAL", NativeTypes.INT32, ColumnMetadata::colocationColumnOrdinal)).addColumn("SCHEMA", NativeTypes.STRING, entry -> entry.schema)).addColumn("TYPE", NativeTypes.STRING, entry -> entry.columnDescriptor.type().name())).addColumn("NULLABLE", NativeTypes.BOOLEAN, entry -> entry.columnDescriptor.nullable())).addColumn("PREC", NativeTypes.INT32, entry -> entry.columnDescriptor.precision())).addColumn("SCALE", NativeTypes.INT32, entry -> entry.columnDescriptor.scale())).addColumn("LENGTH", NativeTypes.INT32, entry -> entry.columnDescriptor.length())).dataProvider(viewDataPublisher)).build();
    }

    private static class ColumnMetadata {
        private final CatalogTableColumnDescriptor columnDescriptor;
        private final String schema;
        private final CatalogTableDescriptor tableDescriptor;

        private ColumnMetadata(String schema, CatalogTableDescriptor tableDescriptor, CatalogTableColumnDescriptor columnDescriptor) {
            this.schema = schema;
            this.columnDescriptor = columnDescriptor;
            this.tableDescriptor = tableDescriptor;
        }

        int columnOrdinal() {
            return this.tableDescriptor.columnIndex(this.columnDescriptor.name());
        }

        @Nullable
        Integer pkColumnOrdinal() {
            int idx = this.tableDescriptor.primaryKeyColumns().indexOf(this.columnDescriptor.name());
            return idx >= 0 ? Integer.valueOf(idx) : null;
        }

        @Nullable
        Integer colocationColumnOrdinal() {
            int idx = this.tableDescriptor.colocationColumns().indexOf(this.columnDescriptor.name());
            return idx >= 0 ? Integer.valueOf(idx) : null;
        }
    }

    private static class TableWithSchemaAndZoneName {
        private final CatalogTableDescriptor table;
        private final String schemaName;
        private final String zoneName;

        private TableWithSchemaAndZoneName(CatalogTableDescriptor table, String schemaName, String zoneName) {
            this.table = table;
            this.schemaName = schemaName;
            this.zoneName = zoneName;
        }
    }
}

