/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage.serialization;

import java.util.HashSet;
import org.apache.ignite.internal.catalog.descriptors.CatalogHashIndexDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogMapDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfileDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogStorageProfilesDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogTablePolicyDescriptorSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersionsSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableVersionSerializers;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptorSerializers;
import org.apache.ignite.internal.catalog.storage.AddSecondaryZoneEntrySerializers;
import org.apache.ignite.internal.catalog.storage.AlterColumnEntrySerializers;
import org.apache.ignite.internal.catalog.storage.AlterSequenceEntrySerializers;
import org.apache.ignite.internal.catalog.storage.AlterTablePropertiesEntrySerializers;
import org.apache.ignite.internal.catalog.storage.AlterZoneEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropArchiveEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropColumnsEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropExpireEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropIndexEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropMapEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropSchemaSerializers;
import org.apache.ignite.internal.catalog.storage.DropSecondaryZoneEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropSequenceSerializers;
import org.apache.ignite.internal.catalog.storage.DropTableEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropTablePolicyEntrySerializers;
import org.apache.ignite.internal.catalog.storage.DropZoneEntrySerializers;
import org.apache.ignite.internal.catalog.storage.LockTableAccessEntrySerializers;
import org.apache.ignite.internal.catalog.storage.MakeIndexAvailableEntrySerializers;
import org.apache.ignite.internal.catalog.storage.ModifyTableRowLevelSecurityEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewColumnsEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewIndexEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewMapEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewSchemaEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewSequenceEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewSystemViewEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewTableEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewTablePolicyEntrySerializers;
import org.apache.ignite.internal.catalog.storage.NewZoneEntrySerializers;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntrySerializers;
import org.apache.ignite.internal.catalog.storage.RemoveIndexEntrySerializers;
import org.apache.ignite.internal.catalog.storage.RenameIndexEntrySerializers;
import org.apache.ignite.internal.catalog.storage.RenameTableEntrySerializers;
import org.apache.ignite.internal.catalog.storage.SecondaryStorageAvailableSerializers;
import org.apache.ignite.internal.catalog.storage.SetDefaultZoneEntrySerializers;
import org.apache.ignite.internal.catalog.storage.SetExpireEntrySerializers;
import org.apache.ignite.internal.catalog.storage.SnapshotEntrySerializers;
import org.apache.ignite.internal.catalog.storage.StartBuildingIndexEntrySerializers;
import org.apache.ignite.internal.catalog.storage.VersionedUpdateSerializers;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializerTypeDefinition;
import org.apache.ignite.internal.util.IgniteUtils;

public enum MarshallableEntryType implements CatalogSerializerTypeDefinition
{
    ALTER_COLUMN(0, AlterColumnEntrySerializers.class),
    ALTER_ZONE(1, AlterZoneEntrySerializers.class),
    NEW_ZONE(2, NewZoneEntrySerializers.class),
    DROP_COLUMN(3, DropColumnsEntrySerializers.class),
    DROP_INDEX(4, DropIndexEntrySerializers.class),
    DROP_TABLE(5, DropTableEntrySerializers.class),
    DROP_ZONE(6, DropZoneEntrySerializers.class),
    MAKE_INDEX_AVAILABLE(7, MakeIndexAvailableEntrySerializers.class),
    REMOVE_INDEX(8, RemoveIndexEntrySerializers.class),
    START_BUILDING_INDEX(9, StartBuildingIndexEntrySerializers.class),
    NEW_COLUMN(10, NewColumnsEntrySerializers.class),
    NEW_INDEX(11, NewIndexEntrySerializers.class),
    NEW_SYS_VIEW(12, NewSystemViewEntrySerializers.class),
    NEW_TABLE(13, NewTableEntrySerializers.class),
    RENAME_TABLE(14, RenameTableEntrySerializers.class),
    ID_GENERATOR(15, ObjectIdGenUpdateEntrySerializers.class),
    SNAPSHOT(16, SnapshotEntrySerializers.class),
    VERSIONED_UPDATE(17, VersionedUpdateSerializers.class),
    RENAME_INDEX(18, RenameIndexEntrySerializers.class),
    SET_DEFAULT_ZONE(19, SetDefaultZoneEntrySerializers.class),
    NEW_SCHEMA(20, NewSchemaEntrySerializers.class),
    DROP_SCHEMA(21, DropSchemaSerializers.class),
    DESCRIPTOR_HASH_INDEX(22, CatalogHashIndexDescriptorSerializers.class),
    DESCRIPTOR_SORTED_INDEX(23, CatalogSortedIndexDescriptorSerializers.class),
    DESCRIPTOR_SCHEMA(24, CatalogSchemaDescriptorSerializers.class),
    DESCRIPTOR_STORAGE_PROFILE(25, CatalogStorageProfileDescriptorSerializers.class),
    DESCRIPTOR_STORAGE_PROFILES(26, CatalogStorageProfilesDescriptorSerializers.class),
    DESCRIPTOR_SYSTEM_VIEW(27, CatalogSystemViewDescriptorSerializers.class),
    DESCRIPTOR_TABLE(28, CatalogTableDescriptorSerializers.class),
    DESCRIPTOR_TABLE_COLUMN(29, CatalogTableColumnDescriptorSerializers.class),
    DESCRIPTOR_TABLE_VERSION(30, CatalogTableVersionSerializers.class),
    DESCRIPTOR_TABLE_SCHEMA_VERSIONS(31, CatalogTableSchemaVersionsSerializers.class),
    DESCRIPTOR_ZONE(32, CatalogZoneDescriptorSerializers.class),
    ALTER_TABLE_PROPERTIES(33, AlterTablePropertiesEntrySerializers.class),
    SET_EXPIRE(-3, SetExpireEntrySerializers.class),
    DROP_EXPIRE(-4, DropExpireEntrySerializers.class),
    LOCK_TABLE_ACCESS(-5, LockTableAccessEntrySerializers.class),
    NEW_SEQUENCE(-6, NewSequenceEntrySerializers.class),
    DROP_SEQUENCE(-7, DropSequenceSerializers.class),
    ALTER_SEQUENCE(-8, AlterSequenceEntrySerializers.class),
    DROP_SECONDARY_ZONE(-9, DropSecondaryZoneEntrySerializers.class),
    DESCRIPTOR_SEQUENCE(-10, CatalogSequenceDescriptorSerializers.class),
    ADD_SECONDARY_ZONE(-11, AddSecondaryZoneEntrySerializers.class),
    SECONDARY_STORAGE_AVAILABLE(-12, SecondaryStorageAvailableSerializers.class),
    DROP_ARCHIVE(-13, DropArchiveEntrySerializers.class),
    DESCRIPTOR_TABLE_POLICY(-14, CatalogTablePolicyDescriptorSerializers.class),
    NEW_TABLE_POLICY(-15, NewTablePolicyEntrySerializers.class),
    DROP_TABLE_POLICY(-16, DropTablePolicyEntrySerializers.class),
    MODIFY_ROW_LEVEL_SECURITY(-17, ModifyTableRowLevelSecurityEntrySerializers.class),
    DESCRIPTOR_MAP(-18, CatalogMapDescriptorSerializers.class),
    NEW_MAP(-19, NewMapEntrySerializers.class),
    DROP_MAP(-20, DropMapEntrySerializers.class);

    private final int id;
    private final Class<?> serializerContainer;

    private MarshallableEntryType(int id, Class<?> serializerContainer) {
        this.id = id;
        this.serializerContainer = serializerContainer;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Class<?> container() {
        return this.serializerContainer;
    }

    static {
        HashSet<Integer> ids = new HashSet<Integer>(IgniteUtils.capacity((int)MarshallableEntryType.values().length));
        HashSet containerClasses = new HashSet(IgniteUtils.capacity((int)MarshallableEntryType.values().length));
        for (MarshallableEntryType entryType : MarshallableEntryType.values()) {
            if (!ids.add(entryType.id)) {
                throw new IllegalStateException("Found duplicate id " + entryType.id);
            }
            if (containerClasses.add(entryType.serializerContainer)) continue;
            throw new IllegalStateException("Found duplicate serializer container [class=" + entryType.serializerContainer.getCanonicalName() + "].");
        }
    }
}

