/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateSequenceEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.util.ArrayUtils;

public class NewSequenceEntry
implements UpdateEntry,
Fireable {
    private final CatalogSequenceDescriptor descriptor;

    public NewSequenceEntry(CatalogSequenceDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogSequenceDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_SEQUENCE.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.SEQUENCE_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateSequenceEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, HybridTimestamp timestamp) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.descriptor.schemaId());
        this.descriptor.updateTimestamp(timestamp);
        List<CatalogSchemaDescriptor> schemas = CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), schema.indexes(), schema.systemViews(), (CatalogSequenceDescriptor[])ArrayUtils.concat((Object[])schema.sequences(), (Object[])new CatalogSequenceDescriptor[]{this.descriptor}), schema.policies(), schema.maps(), timestamp), catalog.schemas());
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), schemas, CatalogUtils.defaultZoneIdOpt(catalog));
    }
}

