/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractTableCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableModifyRowLevelSecurityCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.ModifyTableRowLevelSecurityEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class AlterTableModifyRowLevelSecurityCommand
extends AbstractTableCommand {
    private final boolean securityEnable;

    public static AlterTableModifyRowLevelSecurityCommandBuilder builder() {
        return new Builder();
    }

    private AlterTableModifyRowLevelSecurityCommand(String tableName, String schemaName, boolean ifTableExists, boolean securityEnable) throws CatalogValidationException {
        super(schemaName, tableName, ifTableExists, true);
        this.securityEnable = securityEnable;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifTableExists);
        if (schema == null) {
            return List.of();
        }
        CatalogTableDescriptor table = CatalogUtils.table(schema, this.tableName, !this.ifTableExists);
        if (table == null) {
            return List.of();
        }
        if (table.securityEnabled() == this.securityEnable) {
            return List.of();
        }
        return List.of(new ModifyTableRowLevelSecurityEntry(table.id(), this.securityEnable));
    }

    private static class Builder
    implements AlterTableModifyRowLevelSecurityCommandBuilder {
        private String schemaName;
        private String tableName;
        private boolean ifTableExists;
        private boolean enableRls;

        private Builder() {
        }

        @Override
        public AlterTableModifyRowLevelSecurityCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterTableModifyRowLevelSecurityCommandBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public AlterTableModifyRowLevelSecurityCommandBuilder ifTableExists(boolean ifTableExists) {
            this.ifTableExists = ifTableExists;
            return this;
        }

        @Override
        public AlterTableModifyRowLevelSecurityCommandBuilder enable(boolean enable) {
            this.enableRls = enable;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new AlterTableModifyRowLevelSecurityCommand(this.tableName, this.schemaName, this.ifTableExists, this.enableRls);
        }
    }
}

