/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateTable;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

abstract class ModifyTableArchiveEntry
extends UpdateTable
implements Fireable {
    protected final int tableId;
    @Nullable
    protected final String archiveColumn;
    @Nullable
    protected final Integer archiveColumnIndexId;

    ModifyTableArchiveEntry(int tableId, @Nullable String archiveColumn, @Nullable Integer archiveColumnIndexId) {
        assert (archiveColumn == null == (archiveColumnIndexId == null)) : "archiveColumn=" + archiveColumn + ", archiveColumnIndexId=" + archiveColumnIndexId;
        this.tableId = tableId;
        this.archiveColumn = archiveColumn;
        this.archiveColumnIndexId = archiveColumnIndexId;
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.TABLE_ALTER;
    }

    @Override
    public CatalogTableDescriptor.Builder newTableDescriptor(CatalogTableDescriptor table) {
        return table.copyBuilder().archiveColumn(this.archiveColumn).archiveColumnIndexId(this.archiveColumnIndexId);
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public String toString() {
        return S.toString((Object)this);
    }
}

