/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class CatalogTableSchemaVersionsSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class TableSchemaVersionsSerializerV2
    implements CatalogObjectSerializer<CatalogTableSchemaVersions> {
        TableSchemaVersionsSerializerV2() {
        }

        @Override
        public CatalogTableSchemaVersions readFrom(CatalogObjectDataInput input) throws IOException {
            List<CatalogTableSchemaVersions.TableVersion> versions = input.readCompactEntryList(CatalogTableSchemaVersions.TableVersion.class);
            int base = input.readVarIntAsInt();
            return new CatalogTableSchemaVersions(base, versions.toArray(new CatalogTableSchemaVersions.TableVersion[0]));
        }

        @Override
        public void writeTo(CatalogTableSchemaVersions tabVersions, CatalogObjectDataOutput output) throws IOException {
            output.writeCompactEntryList(Arrays.asList(tabVersions.versions()));
            output.writeVarInt(tabVersions.earliestVersion());
        }
    }
}

