/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class CatalogSequenceDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry {
    private static final int INITIAL_SEQUENCE_VERSION = 1;
    private final int tableId;
    private final int schemaId;
    private final int version;
    private final long increment;
    private final long minvalue;
    private final long maxvalue;
    private final long start;
    private final long cache;

    public CatalogSequenceDescriptor(int id, int tableId, int schemaId, String name, long increment, long minvalue, long maxvalue, long start, long cache) {
        this(CatalogManager.INITIAL_TIMESTAMP, id, tableId, schemaId, 1, name, increment, minvalue, maxvalue, start, cache);
    }

    CatalogSequenceDescriptor(HybridTimestamp timestamp, int id, int tableId, int schemaId, int version, String name, long increment, long minvalue, long maxvalue, long start, long cache) {
        super(id, CatalogObjectDescriptor.Type.SEQUENCE, name, timestamp);
        this.tableId = tableId;
        this.schemaId = schemaId;
        this.version = version;
        this.increment = increment;
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.start = start;
        this.cache = cache;
        this.validate();
    }

    public CatalogSequenceDescriptor newSequence(@Nullable Long increment, @Nullable Long minvalue, @Nullable Long maxvalue, @Nullable Long start, @Nullable Long cache) {
        return new CatalogSequenceDescriptor(CatalogManager.INITIAL_TIMESTAMP, this.id(), this.tableId(), this.schemaId(), this.version() + 1, this.name(), Objects.requireNonNullElse(increment, this.increment), Objects.requireNonNullElse(minvalue, this.minvalue), Objects.requireNonNullElse(maxvalue, this.maxvalue), Objects.requireNonNullElse(start, this.start), Objects.requireNonNullElse(cache, this.cache));
    }

    public int tableId() {
        return this.tableId;
    }

    public int schemaId() {
        return this.schemaId;
    }

    public int version() {
        return this.version;
    }

    public long increment() {
        return this.increment;
    }

    public long minvalue() {
        return this.minvalue;
    }

    public long maxvalue() {
        return this.maxvalue;
    }

    public long start() {
        return this.start;
    }

    public long cachevalue() {
        return this.cache;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_SEQUENCE.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogSequenceDescriptor.class, (Object)this, (String)super.toString());
    }

    private void validate() {
        if (this.increment == 0L) {
            throw new CatalogValidationException("increment must not be zero");
        }
        if (this.minvalue > this.maxvalue) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"minvalue ({}) must be less than maxvalue ({})", (Object[])new Object[]{this.minvalue, this.maxvalue}));
        }
        if (this.start < this.minvalue) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"start ({}) cannot be less than minvalue ({})", (Object[])new Object[]{this.start, this.minvalue}));
        }
        if (this.start > this.maxvalue) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"start ({}) cannot be greater than maxvalue ({})", (Object[])new Object[]{this.start, this.maxvalue}));
        }
        if (this.cache <= 0L) {
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"cache ({}) must be greater than zero", (Object[])new Object[]{this.cache}));
        }
        if (this.cache > 1L) {
            BigDecimal max = BigDecimal.valueOf(this.maxvalue);
            BigDecimal min = BigDecimal.valueOf(this.minvalue);
            BigDecimal inc = BigDecimal.valueOf(this.increment).abs();
            BigDecimal totalValues = max.subtract(min).add(BigDecimal.ONE).divide(inc, RoundingMode.CEILING);
            if (BigDecimal.valueOf(this.cache).compareTo(totalValues) > 0) {
                String msg = IgniteStringFormatter.format((String)"cannot cache more values ({}) than will fit in a given sequence ({})", (Object[])new Object[]{this.cache, totalValues});
                throw new CatalogValidationException(msg);
            }
        }
    }
}

