/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.storage.RenameIndexEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;

public class RenameIndexEntrySerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class RenameIndexEntrySerializerV2
    implements CatalogObjectSerializer<RenameIndexEntry> {
        RenameIndexEntrySerializerV2() {
        }

        @Override
        public RenameIndexEntry readFrom(CatalogObjectDataInput input) throws IOException {
            int indexId = input.readVarIntAsInt();
            String newIndexName = input.readUTF();
            return new RenameIndexEntry(indexId, newIndexName);
        }

        @Override
        public void writeTo(RenameIndexEntry entry, CatalogObjectDataOutput out) throws IOException {
            out.writeVarInt(entry.indexId());
            out.writeUTF(entry.newIndexName());
        }
    }
}

