/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.cache.CacheWriteMode;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnContainer;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSecondaryStorageState;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableSchemaVersions;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntry;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.sql.ColumnType;
import org.jetbrains.annotations.Nullable;

public class CatalogTableDescriptor
extends CatalogObjectDescriptor
implements MarshallableEntry,
CatalogColumnContainer {
    public static final int INITIAL_TABLE_VERSION = 1;
    private final int zoneId;
    @Nullable
    private final Integer secondaryZoneId;
    private final int schemaId;
    private final int pkIndexId;
    @IgniteToStringExclude
    private final CatalogTableSchemaVersions schemaVersions;
    @IgniteToStringInclude
    private final List<CatalogTableColumnDescriptor> columns;
    @IgniteToStringInclude
    private final List<String> primaryKeyColumns;
    @IgniteToStringInclude
    private final List<String> colocationColumns;
    @IgniteToStringExclude
    private final Map<String, Int2ObjectMap.Entry<CatalogTableColumnDescriptor>> columnsMap;
    private final String storageProfile;
    @Nullable
    private final String secondaryStorageProfile;
    private final boolean cache;
    @Nullable
    private final String expireColumn;
    @Nullable
    private final Integer expireColumnIndexId;
    @Nullable
    private final String archiveColumn;
    @Nullable
    private final Integer archiveColumnIndexId;
    private final boolean isLockedForAccess;
    private final CacheWriteMode cacheWriteMode;
    private final CatalogSecondaryStorageState secondaryStorageState;
    private final boolean securityEnabled;

    private CatalogTableDescriptor(int id, int schemaId, int pkIndexId, String name, int zoneId, @Nullable Integer secondaryZoneId, List<CatalogTableColumnDescriptor> columns, List<String> pkCols, @Nullable List<String> colocationCols, CatalogTableSchemaVersions schemaVersions, String storageProfile, @Nullable String secondaryStorageProfile, HybridTimestamp timestamp, boolean cache, @Nullable String expireColumn, @Nullable Integer expireColumnIndexId, boolean isLockedForAccess, CacheWriteMode cacheWriteMode, @Nullable String archiveColumn, @Nullable Integer archiveColumnIndexId, CatalogSecondaryStorageState secondaryStorageState, boolean securityEnabled) {
        super(id, CatalogObjectDescriptor.Type.TABLE, name, timestamp);
        this.schemaId = schemaId;
        this.pkIndexId = pkIndexId;
        this.zoneId = zoneId;
        this.secondaryZoneId = secondaryZoneId;
        this.columns = columns;
        this.primaryKeyColumns = pkCols;
        HashMap columnMap = IgniteUtils.newHashMap((int)columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            CatalogTableColumnDescriptor column = columns.get(i);
            columnMap.put(column.name(), new AbstractInt2ObjectMap.BasicEntry(i, (Object)column));
        }
        this.columnsMap = columnMap;
        this.colocationColumns = Objects.requireNonNullElse(colocationCols, pkCols);
        this.schemaVersions = Objects.requireNonNull(schemaVersions, "No catalog schema versions.");
        this.storageProfile = Objects.requireNonNull(storageProfile, "No storage profile.");
        this.secondaryStorageProfile = secondaryStorageProfile;
        this.cache = cache;
        this.expireColumn = expireColumn;
        this.expireColumnIndexId = expireColumnIndexId;
        this.isLockedForAccess = isLockedForAccess;
        this.cacheWriteMode = cacheWriteMode;
        this.archiveColumn = archiveColumn;
        this.archiveColumnIndexId = archiveColumnIndexId;
        this.secondaryStorageState = secondaryStorageState;
        this.securityEnabled = securityEnabled;
    }

    public Builder copyBuilder() {
        return new Builder().id(this.id()).name(this.name()).timestamp(this.updateTimestamp()).zoneId(this.zoneId()).schemaId(this.schemaId()).primaryKeyIndexId(this.primaryKeyIndexId()).schemaVersions(this.schemaVersions).columns(this.columns).primaryKeyColumns(this.primaryKeyColumns()).colocationColumns(this.colocationColumns()).storageProfile(this.storageProfile()).secondaryZoneId(this.secondaryZoneId()).secondaryStorageProfile(this.secondaryStorageProfile()).cache(this.cache()).expireColumn(this.expireColumn()).expireColumnIndexId(this.expireColumnIndexId()).lockedForAccess(this.isLockedForAccess()).cacheWriteMode(this.cacheWriteMode).archiveColumn(this.archiveColumn()).archiveColumnIndexId(this.archiveColumnIndexId()).secondaryStorageState(this.secondaryStorageState()).rowLevelSecurityEnabled(this.securityEnabled());
    }

    public static Builder builder() {
        return new Builder();
    }

    public int schemaId() {
        return this.schemaId;
    }

    public CatalogTableSchemaVersions schemaVersions() {
        return this.schemaVersions;
    }

    public int zoneId() {
        return this.zoneId;
    }

    @Nullable
    public Integer secondaryZoneId() {
        return this.secondaryZoneId;
    }

    public int primaryKeyIndexId() {
        return this.pkIndexId;
    }

    public int latestSchemaVersion() {
        return this.schemaVersions.latestVersion();
    }

    public List<String> primaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public List<String> colocationColumns() {
        return this.colocationColumns;
    }

    @Override
    public List<CatalogTableColumnDescriptor> columns() {
        return this.columns;
    }

    public CacheWriteMode writeMode() {
        return this.cacheWriteMode;
    }

    @Nullable
    public CatalogTableColumnDescriptor column(String name) {
        Int2ObjectMap.Entry<CatalogTableColumnDescriptor> column = this.columnsMap.get(name);
        if (column != null) {
            return (CatalogTableColumnDescriptor)column.getValue();
        }
        return null;
    }

    public int columnIndex(String name) {
        Int2ObjectMap.Entry<CatalogTableColumnDescriptor> column = this.columnsMap.get(name);
        if (column != null) {
            return column.getIntKey();
        }
        return -1;
    }

    public boolean isPrimaryKeyColumn(String name) {
        return this.primaryKeyColumns.contains(name);
    }

    public boolean isColocationColumn(String name) {
        return this.colocationColumns.contains(name);
    }

    @Nullable
    public String expireColumn() {
        return this.expireColumn;
    }

    @Nullable
    public Integer expireColumnIndexId() {
        return this.expireColumnIndexId;
    }

    @Nullable
    public ColumnType expireColumnType() {
        return this.expireColumn == null ? null : this.column(this.expireColumn).type();
    }

    @Nullable
    public String archiveColumn() {
        return this.archiveColumn;
    }

    @Nullable
    public Integer archiveColumnIndexId() {
        return this.archiveColumnIndexId;
    }

    @Nullable
    public ColumnType archiveColumnType() {
        return this.archiveColumn == null ? null : this.column(this.archiveColumn).type();
    }

    public boolean isLockedForAccess() {
        return this.isLockedForAccess;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.DESCRIPTOR_TABLE.id();
    }

    @Override
    public String toString() {
        return S.toString(CatalogTableDescriptor.class, (Object)this, (String)super.toString());
    }

    public String storageProfile() {
        return this.storageProfile;
    }

    @Nullable
    public String secondaryStorageProfile() {
        return this.secondaryStorageProfile;
    }

    public boolean cache() {
        return this.cache;
    }

    public CatalogSecondaryStorageState secondaryStorageState() {
        return this.secondaryStorageState;
    }

    public boolean securityEnabled() {
        return this.securityEnabled;
    }

    public static final class Builder {
        private int id;
        private String name;
        private int zoneId;
        private int schemaId;
        private int pkIndexId;
        private CatalogTableSchemaVersions schemaVersions;
        private List<CatalogTableColumnDescriptor> columns;
        private List<String> primaryKeyColumns;
        @Nullable
        private List<String> colocationColumns;
        private String storageProfile;
        private HybridTimestamp timestamp = CatalogManager.INITIAL_TIMESTAMP;
        private int latestSchemaVersion = 0;
        @Nullable
        private Integer secondaryZoneId;
        @Nullable
        private String secondaryStorageProfile;
        private boolean cache;
        @Nullable
        private String expireColumn;
        @Nullable
        private Integer expireColumnIndexId;
        @Nullable
        private String archiveColumn;
        @Nullable
        private Integer archiveColumnIndexId;
        private boolean isLockedForAccess;
        private CacheWriteMode cacheWriteMode = CacheWriteMode.SYNC;
        private CatalogSecondaryStorageState secondaryStorageState = CatalogSecondaryStorageState.NOT_AVAILABLE;
        private boolean rowLevelSecurityEnabled;

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder zoneId(int zoneId) {
            this.zoneId = zoneId;
            return this;
        }

        public Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public Builder primaryKeyIndexId(int primaryKeyIndexId) {
            this.pkIndexId = primaryKeyIndexId;
            return this;
        }

        public Builder schemaVersions(CatalogTableSchemaVersions schemaVersions) {
            this.schemaVersions = schemaVersions;
            return this;
        }

        public Builder columns(List<CatalogTableColumnDescriptor> columns) {
            this.columns = columns;
            return this;
        }

        public Builder primaryKeyColumns(List<String> primaryKeyColumns) {
            this.primaryKeyColumns = primaryKeyColumns;
            return this;
        }

        public Builder colocationColumns(@Nullable List<String> colocationColumns) {
            this.colocationColumns = colocationColumns;
            return this;
        }

        public Builder storageProfile(String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        public Builder latestSchemaVersion(int latestSchemaVersion) {
            this.latestSchemaVersion = latestSchemaVersion;
            return this;
        }

        public Builder secondaryZoneId(@Nullable Integer secondaryZoneId) {
            this.secondaryZoneId = secondaryZoneId;
            return this;
        }

        public Builder secondaryStorageProfile(@Nullable String secondaryStorageProfile) {
            this.secondaryStorageProfile = secondaryStorageProfile;
            return this;
        }

        public Builder cache(boolean cache) {
            this.cache = cache;
            return this;
        }

        public Builder expireColumn(@Nullable String expireColumn) {
            this.expireColumn = expireColumn;
            return this;
        }

        public Builder expireColumnIndexId(@Nullable Integer expireColumnIndexId) {
            this.expireColumnIndexId = expireColumnIndexId;
            return this;
        }

        public Builder archiveColumn(@Nullable String archiveColumn) {
            this.archiveColumn = archiveColumn;
            return this;
        }

        public Builder archiveColumnIndexId(@Nullable Integer archiveColumnIndexId) {
            this.archiveColumnIndexId = archiveColumnIndexId;
            return this;
        }

        public Builder lockedForAccess(boolean lockedForAccess) {
            this.isLockedForAccess = lockedForAccess;
            return this;
        }

        public Builder cacheWriteMode(CacheWriteMode cacheWriteMode) {
            this.cacheWriteMode = cacheWriteMode;
            return this;
        }

        public Builder secondaryStorageState(CatalogSecondaryStorageState secondaryStorageState) {
            this.secondaryStorageState = secondaryStorageState;
            return this;
        }

        public Builder rowLevelSecurityEnabled(boolean securityEnabled) {
            this.rowLevelSecurityEnabled = securityEnabled;
            return this;
        }

        public CatalogTableDescriptor build() {
            CatalogTableSchemaVersions.TableVersion latestTableVersion;
            Objects.requireNonNull(this.columns, "No columns defined.");
            if (this.columns.isEmpty()) {
                throw new IllegalArgumentException("No columns defined.");
            }
            Objects.requireNonNull(this.primaryKeyColumns, "No primary key columns.");
            if (this.primaryKeyColumns.isEmpty()) {
                throw new IllegalArgumentException("No primary key columns.");
            }
            if (this.schemaVersions == null) {
                this.schemaVersions = new CatalogTableSchemaVersions(new CatalogTableSchemaVersions.TableVersion(this.columns));
            }
            if (this.latestSchemaVersion == 0) {
                this.latestSchemaVersion = this.schemaVersions.latestVersion();
            } else if (this.latestSchemaVersion < this.schemaVersions.latestVersion()) {
                throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Latest schema version {} should not be less than a previous version {}.", (Object[])new Object[]{this.latestSchemaVersion, this.schemaVersions.latestVersion()}));
            }
            if (this.latestSchemaVersion == this.schemaVersions.latestVersion() && !Objects.equals((latestTableVersion = Objects.requireNonNull(this.schemaVersions.get(this.schemaVersions.latestVersion()))).columns(), this.columns)) {
                throw new IllegalArgumentException(IgniteStringFormatter.format((String)"Latest schema version columns do not match descriptor definition columns. Schema columns: {}, table columns: {}.", (Object[])new Object[]{latestTableVersion.columns(), this.columns}));
            }
            CatalogTableSchemaVersions newSchemaVersions = this.latestSchemaVersion == this.schemaVersions.latestVersion() ? this.schemaVersions : this.schemaVersions.append(new CatalogTableSchemaVersions.TableVersion(this.columns), this.latestSchemaVersion);
            return new CatalogTableDescriptor(this.id, this.schemaId, this.pkIndexId, this.name, this.zoneId, this.secondaryZoneId, this.columns, this.primaryKeyColumns, this.colocationColumns, newSchemaVersions, this.storageProfile, this.secondaryStorageProfile, this.timestamp, this.cache, this.expireColumn, this.expireColumnIndexId, this.isLockedForAccess, this.cacheWriteMode, this.archiveColumn, this.archiveColumnIndexId, this.secondaryStorageState, this.rowLevelSecurityEnabled);
        }
    }
}

