/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.descriptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.catalog.descriptors.CatalogColumnCollation;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexColumnDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSortedIndexDescriptor;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataInput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectDataOutput;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializer;
import org.apache.ignite.internal.hlc.HybridTimestamp;

public class CatalogSortedIndexDescriptorSerializers {

    @CatalogSerializer(version=2, since="gridgain-9.1.0")
    static class SortedIndexDescriptorSerializerV2
    implements CatalogObjectSerializer<CatalogSortedIndexDescriptor> {
        SortedIndexDescriptorSerializerV2() {
        }

        @Override
        public CatalogSortedIndexDescriptor readFrom(CatalogObjectDataInput input) throws IOException {
            int id = input.readVarIntAsInt();
            String name = input.readUTF();
            long updateTimestampLong = input.readVarInt();
            HybridTimestamp updateTimestamp = updateTimestampLong == 0L ? HybridTimestamp.MIN_VALUE : HybridTimestamp.hybridTimestamp((long)updateTimestampLong);
            int tableId = input.readVarIntAsInt();
            boolean unique = input.readBoolean();
            CatalogIndexStatus status = CatalogIndexStatus.forId(input.readByte());
            boolean isCreatedWithTable = input.readBoolean();
            List columns = input.readObjectCollection(in -> {
                String columnName = input.readUTF();
                CatalogColumnCollation collation = CatalogColumnCollation.unpack(input.readByte());
                return new CatalogIndexColumnDescriptor(columnName, collation);
            }, ArrayList::new);
            return new CatalogSortedIndexDescriptor(id, name, tableId, unique, status, columns, updateTimestamp, isCreatedWithTable);
        }

        @Override
        public void writeTo(CatalogSortedIndexDescriptor descriptor, CatalogObjectDataOutput output) throws IOException {
            output.writeVarInt(descriptor.id());
            output.writeUTF(descriptor.name());
            output.writeVarInt(descriptor.updateTimestamp().longValue());
            output.writeVarInt(descriptor.tableId());
            output.writeBoolean(descriptor.unique());
            output.writeByte(descriptor.status().id());
            output.writeBoolean(descriptor.isCreatedWithTable());
            output.writeObjectCollection((out, elem) -> {
                output.writeUTF(elem.name());
                output.writeByte(CatalogColumnCollation.pack(elem.collation()));
            }, descriptor.columns());
        }
    }
}

