/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.commands.DefaultPartitionCountProvider;
import org.apache.ignite.internal.catalog.commands.EstimatedDataNodesNumberProvider;
import org.jetbrains.annotations.Nullable;

public class DefaultPartitionCountProviderImpl
implements DefaultPartitionCountProvider {
    private final EstimatedDataNodesNumberProvider estimatedDataNodesCountProvider;

    public DefaultPartitionCountProviderImpl(EstimatedDataNodesNumberProvider estimatedDataNodesCountProvider) {
        this.estimatedDataNodesCountProvider = estimatedDataNodesCountProvider;
    }

    @Override
    public int calculate(@Nullable String dataNodesFilter, @Nullable List<String> storageProfiles, @Nullable Integer replicaFactor) {
        int dataNodesCount = this.estimatedDataNodesCountProvider.estimatedDataNodesNumber(Objects.requireNonNullElse(dataNodesFilter, "$..*"), Objects.requireNonNullElse(storageProfiles, List.of("default")));
        int cores = Runtime.getRuntime().availableProcessors();
        int replicas = Objects.requireNonNullElse(replicaFactor, 1);
        if (replicas <= 0) {
            throw new IllegalArgumentException("Replica factor should be greater than 0.");
        }
        return Math.max(dataNodesCount * cores * 2 / replicas, 1);
    }
}

