/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.UpdateContext;
import org.apache.ignite.internal.catalog.commands.AbstractSequenceCommand;
import org.apache.ignite.internal.catalog.commands.AlterSequenceCommandBuilder;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSequenceDescriptor;
import org.apache.ignite.internal.catalog.storage.AlterSequenceEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.jetbrains.annotations.Nullable;

public class AlterSequenceCommand
extends AbstractSequenceCommand {
    @Nullable
    private final Long increment;
    @Nullable
    private final Long minvalue;
    @Nullable
    private final Long maxvalue;
    @Nullable
    private final Long start;
    @Nullable
    private final Long cache;

    public static AlterSequenceCommandBuilder builder() {
        return new Builder();
    }

    private AlterSequenceCommand(String schemaName, String sequenceName, boolean ifExists, @Nullable Long increment, @Nullable Long minvalue, @Nullable Long maxvalue, @Nullable Long start, @Nullable Long cache) {
        super(schemaName, sequenceName, ifExists);
        this.increment = increment;
        this.minvalue = minvalue;
        this.maxvalue = maxvalue;
        this.start = start;
        this.cache = cache;
    }

    @Override
    public List<UpdateEntry> get(UpdateContext updateContext) {
        Catalog catalog = updateContext.catalog();
        CatalogSchemaDescriptor schema = CatalogUtils.schema(catalog, this.schemaName, !this.ifExists);
        if (schema == null) {
            return List.of();
        }
        CatalogSequenceDescriptor sequence = CatalogUtils.sequence(schema, this.sequenceName, !this.ifExists);
        if (sequence == null) {
            return List.of();
        }
        CatalogSequenceDescriptor newDescriptor = sequence.newSequence(this.increment, this.minvalue, this.maxvalue, this.start, this.cache);
        return List.of(new AlterSequenceEntry(newDescriptor));
    }

    public static class Builder
    implements AlterSequenceCommandBuilder {
        private String schemaName;
        private String sequenceName;
        private boolean ifExists;
        @Nullable
        private Long increment;
        @Nullable
        private Long minvalue;
        @Nullable
        private Long maxvalue;
        @Nullable
        private Long start;
        @Nullable
        private Long cache;

        @Override
        public AlterSequenceCommandBuilder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        @Override
        public AlterSequenceCommandBuilder sequenceName(String sequenceName) {
            this.sequenceName = sequenceName;
            return this;
        }

        @Override
        public AlterSequenceCommandBuilder ifExists(boolean ifExists) {
            this.ifExists = ifExists;
            return this;
        }

        @Override
        public AlterSequenceCommandBuilder increment(@Nullable Long increment) {
            this.increment = increment;
            return this;
        }

        @Override
        public AlterSequenceCommandBuilder minvalue(@Nullable Long minvalue) {
            this.minvalue = minvalue;
            return this;
        }

        @Override
        public AlterSequenceCommandBuilder maxvalue(@Nullable Long maxvalue) {
            this.maxvalue = maxvalue;
            return this;
        }

        @Override
        public Builder start(@Nullable Long start) {
            this.start = start;
            return this;
        }

        @Override
        public Builder cache(@Nullable Long cache) {
            this.cache = cache;
            return this;
        }

        @Override
        public AlterSequenceCommand build() {
            return new AlterSequenceCommand(this.schemaName, this.sequenceName, this.ifExists, this.increment, this.minvalue, this.maxvalue, this.start, this.cache);
        }
    }
}

