/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;

public abstract class AbstractCacheCommand
implements CatalogCommand {
    protected final String schemaName;
    protected final String cacheName;
    protected final boolean ifTableExists;

    AbstractCacheCommand(String schemaName, String cacheName, boolean ifTableExists) throws CatalogValidationException {
        this.schemaName = schemaName;
        this.cacheName = cacheName;
        this.ifTableExists = ifTableExists;
        this.validate();
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public boolean ifTableExists() {
        return this.ifTableExists;
    }

    private void validate() {
        CatalogParamsValidationUtils.validateIdentifier(this.schemaName, "Name of the schema");
        CatalogParamsValidationUtils.validateIdentifier(this.cacheName, "Name of the cache");
        CatalogParamsValidationUtils.ensureNonSystemSchemaUsed(this.schemaName);
    }
}

