/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.internal.catalog.sql.DefinitionCollector;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.QualifiedName;

class TableDefinitionCollector {
    private final DefinitionCollector<TableDefinition> collector;

    TableDefinitionCollector(QualifiedName tableName, IgniteSql sql) {
        this.collector = new DefinitionCollector<TableDefinition>(tableName, sql, new CollectorTableDefinitionBuilder(), "IS FALSE");
    }

    CompletableFuture<TableDefinition> collectDefinition() {
        return this.collector.collectDefinition();
    }

    private static class CollectorTableDefinitionBuilder
    implements DefinitionCollector.DefinitionBuilder<TableDefinition> {
        private TableDefinition.Builder builder;

        private CollectorTableDefinitionBuilder() {
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<TableDefinition> newBuilder(QualifiedName objectName) {
            this.builder = TableDefinition.builder((QualifiedName)objectName);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<TableDefinition> zone(String zone) {
            this.builder.zone(zone);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<TableDefinition> primaryKey(IndexType type, List<ColumnSorted> columns) {
            this.builder.primaryKey(type, columns);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<TableDefinition> index(String name, IndexType type, List<ColumnSorted> columns) {
            this.builder.index(name, type, columns);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<TableDefinition> colocateBy(List<String> colocationColumn) {
            this.builder.colocateBy(colocationColumn);
            return this;
        }

        @Override
        public DefinitionCollector.DefinitionBuilder<TableDefinition> columns(List<ColumnDefinition> columns) {
            this.builder.columns(columns);
            return this;
        }

        @Override
        public TableDefinition build() {
            return this.builder.build();
        }
    }
}

