/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.ColumnType;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.SortOrder;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.Colocate;
import org.apache.ignite.internal.catalog.sql.Column;
import org.apache.ignite.internal.catalog.sql.ColumnTypeImpl;
import org.apache.ignite.internal.catalog.sql.Constraint;
import org.apache.ignite.internal.catalog.sql.CreateIndexImpl;
import org.apache.ignite.internal.catalog.sql.Name;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPartCollection;
import org.apache.ignite.internal.catalog.sql.Zone;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.QualifiedName;

abstract class CreateDataSource
extends AbstractCatalogQuery<Name> {
    private final String dataSourceIdentifier;
    private Name name;
    private boolean ifNotExists;
    private final List<Column> columns = new ArrayList<Column>();
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private Colocate colocate;
    private Zone zone;
    private final List<CreateIndexImpl> indexes = new ArrayList<CreateIndexImpl>();

    CreateDataSource(IgniteSql sql, String dataSourceIdentifier) {
        super(sql);
        this.dataSourceIdentifier = dataSourceIdentifier;
    }

    @Override
    protected Name result() {
        return this.name;
    }

    CreateDataSource name(QualifiedName name) {
        Objects.requireNonNull(name, "Name must not be null.");
        this.name = Name.qualified(name);
        return this;
    }

    CreateDataSource ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    CreateDataSource addColumn(String name, String definition) {
        Objects.requireNonNull(name, "Column name must not be null.");
        Objects.requireNonNull(definition, "Column type must not be null.");
        this.columns.add(new Column(name, definition));
        return this;
    }

    CreateDataSource addColumn(String name, ColumnType<?> type) {
        Objects.requireNonNull(name, "Column name must not be null.");
        Objects.requireNonNull(type, "Column type must not be null.");
        this.columns.add(new Column(name, ColumnTypeImpl.wrap(type)));
        return this;
    }

    CreateDataSource primaryKey(List<String> columns) {
        return this.primaryKey(IndexType.DEFAULT, columns.stream().map(ColumnSorted::column).collect(Collectors.toList()));
    }

    CreateDataSource primaryKey(IndexType type, List<ColumnSorted> columns) {
        Objects.requireNonNull(columns, "PK columns must not be null.");
        this.constraints.add(new Constraint().primaryKey(type, columns));
        return this;
    }

    CreateDataSource colocateBy(String ... columns) {
        return this.colocateBy(Arrays.asList(columns));
    }

    CreateDataSource colocateBy(List<String> columns) {
        Objects.requireNonNull(columns, "Colocate columns must not be null.");
        this.colocate = new Colocate(columns);
        return this;
    }

    CreateDataSource zone(String zone) {
        Objects.requireNonNull(zone, "Zone name must not be null.");
        this.zone = new Zone(zone);
        return this;
    }

    CreateDataSource addIndex(String name, IndexType type, List<ColumnSorted> columns) {
        Objects.requireNonNull(name, "Index name must not be null.");
        Objects.requireNonNull(columns, "Index columns list must not be null.");
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("Index columns list must not be empty.");
        }
        if (type == IndexType.HASH) {
            for (ColumnSorted c : columns) {
                if (c.sortOrder() == SortOrder.DEFAULT) continue;
                throw new IllegalArgumentException("Index columns must not define a sort order in hash indexes.");
            }
        }
        this.indexes.add(new CreateIndexImpl(this.sql).ifNotExists().name(name).using(type).on(this.name, columns));
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.columns.isEmpty()) {
            throw new IllegalArgumentException("Columns list must not be empty.");
        }
        ctx.sql("CREATE " + this.dataSourceIdentifier + " ");
        if (this.ifNotExists) {
            ctx.sql("IF NOT EXISTS ");
        }
        ctx.visit(this.name);
        ctx.sqlIndentStart(" (");
        ctx.visit(QueryPartCollection.partsList(this.columns));
        if (!this.constraints.isEmpty()) {
            ctx.sql(", ");
            ctx.visit(QueryPartCollection.partsList(this.constraints));
        }
        ctx.sql(")");
        if (this.colocate != null) {
            ctx.sql(" ").visit(this.colocate);
        }
        if (this.zone != null) {
            ctx.sql(" ").visit(this.zone);
        }
        ctx.sql(";");
        for (CreateIndexImpl index : this.indexes) {
            ctx.formatSeparator().visit(index);
        }
    }
}

