/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.compaction.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.catalog.compaction.message.AvailablePartitionsMessage;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMinimumTimesResponse;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMinimumTimesResponseBuilder;
import org.apache.ignite.internal.catalog.compaction.message.CatalogCompactionMinimumTimesResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class CatalogCompactionMinimumTimesResponseImpl
implements CatalogCompactionMinimumTimesResponse,
Cloneable {
    public static final short GROUP_TYPE = 14;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final long activeTxMinimumRequiredTime;
    @IgniteToStringInclude
    private final long minimumRequiredTime;
    @IgniteToStringInclude
    private final List<AvailablePartitionsMessage> partitions;

    private CatalogCompactionMinimumTimesResponseImpl(long activeTxMinimumRequiredTime, long minimumRequiredTime, List<AvailablePartitionsMessage> partitions) {
        this.activeTxMinimumRequiredTime = activeTxMinimumRequiredTime;
        this.minimumRequiredTime = minimumRequiredTime;
        this.partitions = partitions;
    }

    @Override
    public long activeTxMinimumRequiredTime() {
        return this.activeTxMinimumRequiredTime;
    }

    @Override
    public long minimumRequiredTime() {
        return this.minimumRequiredTime;
    }

    @Override
    public List<AvailablePartitionsMessage> partitions() {
        return this.partitions;
    }

    public MessageSerializer serializer() {
        return CatalogCompactionMinimumTimesResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 14;
    }

    public String toString() {
        return S.toString(CatalogCompactionMinimumTimesResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CatalogCompactionMinimumTimesResponseImpl otherMessage = (CatalogCompactionMinimumTimesResponseImpl)other;
        return Objects.equals(this.partitions, otherMessage.partitions) && this.activeTxMinimumRequiredTime == otherMessage.activeTxMinimumRequiredTime && this.minimumRequiredTime == otherMessage.minimumRequiredTime;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.activeTxMinimumRequiredTime, this.minimumRequiredTime, this.partitions);
        return result;
    }

    public CatalogCompactionMinimumTimesResponseImpl clone() {
        try {
            return (CatalogCompactionMinimumTimesResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CatalogCompactionMinimumTimesResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitions != null) {
            for (AvailablePartitionsMessage obj : this.partitions) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitions != null) {
            for (AvailablePartitionsMessage obj : this.partitions) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements CatalogCompactionMinimumTimesResponseBuilder {
        private long activeTxMinimumRequiredTime;
        private long minimumRequiredTime;
        private List<AvailablePartitionsMessage> partitions;

        private Builder() {
        }

        @Override
        public CatalogCompactionMinimumTimesResponseBuilder activeTxMinimumRequiredTime(long activeTxMinimumRequiredTime) {
            this.activeTxMinimumRequiredTime = activeTxMinimumRequiredTime;
            return this;
        }

        @Override
        public CatalogCompactionMinimumTimesResponseBuilder minimumRequiredTime(long minimumRequiredTime) {
            this.minimumRequiredTime = minimumRequiredTime;
            return this;
        }

        @Override
        public CatalogCompactionMinimumTimesResponseBuilder partitions(List<AvailablePartitionsMessage> partitions) {
            Objects.requireNonNull(partitions, "partitions is not marked @Nullable");
            this.partitions = partitions;
            return this;
        }

        @Override
        public long activeTxMinimumRequiredTime() {
            return this.activeTxMinimumRequiredTime;
        }

        @Override
        public long minimumRequiredTime() {
            return this.minimumRequiredTime;
        }

        @Override
        public List<AvailablePartitionsMessage> partitions() {
            return this.partitions;
        }

        @Override
        public CatalogCompactionMinimumTimesResponse build() {
            return new CatalogCompactionMinimumTimesResponseImpl(this.activeTxMinimumRequiredTime, this.minimumRequiredTime, Objects.requireNonNull(this.partitions, "partitions is not marked @Nullable"));
        }

        @Override
        public CatalogCompactionMinimumTimesResponse buildDeserialized() {
            return new CatalogCompactionMinimumTimesResponseImpl(this.activeTxMinimumRequiredTime, this.minimumRequiredTime, this.partitions);
        }
    }
}

