/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceStrategy;
import org.apache.ignite.cache.store.cassandra.persistence.PojoField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.apache.ignite.cache.store.cassandra.persistence.PojoKeyField;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyPersistenceSettings
extends PersistenceSettings<PojoKeyField> {
    private static final String PARTITION_KEY_ELEMENT = "partitionKey";
    private static final String CLUSTER_KEY_ELEMENT = "clusterKey";
    private static final String FIELD_ELEMENT = "field";
    private List<PojoKeyField> fields = new LinkedList<PojoKeyField>();
    private List<PojoKeyField> partKeyFields = new LinkedList<PojoKeyField>();
    private List<PojoKeyField> clusterKeyFields = new LinkedList<PojoKeyField>();

    public KeyPersistenceSettings(Element element) {
        super(element);
        NodeList nodeList;
        if (PersistenceStrategy.POJO != this.getStrategy()) {
            this.init();
            return;
        }
        Element element2 = element.getElementsByTagName(PARTITION_KEY_ELEMENT) != null ? (Element)element.getElementsByTagName(PARTITION_KEY_ELEMENT).item(0) : null;
        NodeList nodeList2 = element2 == null ? null : element2.getElementsByTagName(FIELD_ELEMENT);
        element2 = element.getElementsByTagName(CLUSTER_KEY_ELEMENT) != null ? (Element)element.getElementsByTagName(CLUSTER_KEY_ELEMENT).item(0) : null;
        NodeList nodeList3 = nodeList = element2 == null ? null : element2.getElementsByTagName(FIELD_ELEMENT);
        if ((nodeList2 == null || nodeList2.getLength() == 0) && nodeList != null && nodeList.getLength() > 0) {
            throw new IllegalArgumentException("It's not allowed to specify cluster key fields mapping, but doesn't specify partition key mappings");
        }
        this.partKeyFields = this.detectPojoFields(nodeList2);
        if (this.partKeyFields == null || this.partKeyFields.isEmpty()) {
            throw new IllegalStateException("Failed to initialize partition key fields for class '" + this.getJavaClass().getName() + "'");
        }
        LinkedList<PojoKeyField> linkedList = new LinkedList<PojoKeyField>();
        for (PojoKeyField pojoKeyField : this.partKeyFields) {
            if (pojoKeyField.getAnnotation(AffinityKeyMapped.class) == null) continue;
            linkedList.add(pojoKeyField);
        }
        this.partKeyFields = !linkedList.isEmpty() ? linkedList : this.partKeyFields;
        this.clusterKeyFields = this.detectPojoFields(nodeList);
        linkedList = new LinkedList();
        for (PojoKeyField pojoKeyField : this.clusterKeyFields) {
            if (PojoField.containsField(this.partKeyFields, pojoKeyField.getName())) continue;
            linkedList.add(pojoKeyField);
        }
        this.clusterKeyFields = linkedList;
        this.fields = new LinkedList<PojoKeyField>();
        this.fields.addAll(this.partKeyFields);
        this.fields.addAll(this.clusterKeyFields);
        this.checkDuplicates(this.fields);
        this.init();
    }

    @Override
    public List<PojoKeyField> getFields() {
        return this.fields;
    }

    @Override
    protected PojoKeyField createPojoField(Element element, Class clazz) {
        return new PojoKeyField(element, clazz);
    }

    @Override
    protected PojoKeyField createPojoField(PojoFieldAccessor pojoFieldAccessor) {
        return new PojoKeyField(pojoFieldAccessor);
    }

    @Override
    protected PojoKeyField createPojoField(PojoKeyField pojoKeyField, Class clazz) {
        return new PojoKeyField(pojoKeyField, clazz);
    }

    public String getPrimaryKeyDDL() {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list = this.getPartitionKeyColumns();
        for (String object : list) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("\"").append(object).append("\"");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        list = this.getClusterKeyColumns();
        if (list != null) {
            for (String string : list) {
                if (stringBuilder2.length() != 0) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append("\"").append(string).append("\"");
            }
        }
        return stringBuilder2.length() == 0 ? "  primary key ((" + stringBuilder + "))" : "  primary key ((" + stringBuilder + "), " + stringBuilder2 + ")";
    }

    public String getClusteringDDL() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PojoField pojoField : this.clusterKeyFields) {
            PojoKeyField.SortOrder sortOrder = ((PojoKeyField)pojoField).getSortOrder();
            if (sortOrder == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            boolean bl = PojoKeyField.SortOrder.ASC == sortOrder;
            stringBuilder.append("\"").append(pojoField.getColumn()).append("\" ").append(bl ? "asc" : "desc");
        }
        return stringBuilder.length() == 0 ? null : "clustering order by (" + stringBuilder + ")";
    }

    @Override
    protected String defaultColumnName() {
        return "key";
    }

    private List<String> getPartitionKeyColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (PersistenceStrategy.BLOB == this.getStrategy() || PersistenceStrategy.PRIMITIVE == this.getStrategy()) {
            linkedList.add(this.getColumn());
            return linkedList;
        }
        if (this.partKeyFields != null) {
            for (PojoField pojoField : this.partKeyFields) {
                linkedList.add(pojoField.getColumn());
            }
        }
        return linkedList;
    }

    private List<String> getClusterKeyColumns() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.clusterKeyFields != null) {
            for (PojoField pojoField : this.clusterKeyFields) {
                linkedList.add(pojoField.getColumn());
            }
        }
        return linkedList;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.fields = this.enrichFields(this.fields);
    }
}

