/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra;

import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.cassandra.CassandraCacheStore;
import org.apache.ignite.cache.store.cassandra.datasource.DataSource;
import org.apache.ignite.cache.store.cassandra.persistence.KeyValuePersistenceSettings;
import org.apache.ignite.internal.IgniteComponentType;
import org.apache.ignite.internal.util.spring.IgniteSpringHelper;
import org.apache.ignite.resources.SpringApplicationContextResource;

public class CassandraCacheStoreFactory<K, V>
implements Factory<CassandraCacheStore<K, V>> {
    private static final long serialVersionUID = 0L;
    @SpringApplicationContextResource
    private Object appCtx;
    private String dataSrcBean;
    private String persistenceSettingsBean;
    private DataSource dataSrc;
    private KeyValuePersistenceSettings persistenceSettings;
    private int maxPoolSize = Runtime.getRuntime().availableProcessors();

    public CassandraCacheStore<K, V> create() {
        return new CassandraCacheStore(this.getDataSource(), this.getPersistenceSettings(), this.getMaxPoolSize());
    }

    public CassandraCacheStoreFactory<K, V> setDataSource(DataSource dataSource) {
        this.dataSrc = dataSource;
        return this;
    }

    public CassandraCacheStoreFactory<K, V> setDataSourceBean(String string) {
        this.dataSrcBean = string;
        return this;
    }

    public CassandraCacheStoreFactory<K, V> setPersistenceSettings(KeyValuePersistenceSettings keyValuePersistenceSettings) {
        this.persistenceSettings = keyValuePersistenceSettings;
        return this;
    }

    public CassandraCacheStoreFactory<K, V> setPersistenceSettingsBean(String string) {
        this.persistenceSettingsBean = string;
        return this;
    }

    private DataSource getDataSource() {
        if (this.dataSrc != null) {
            return this.dataSrc;
        }
        if (this.dataSrcBean == null) {
            throw new IllegalStateException("Either DataSource bean or DataSource itself should be specified");
        }
        if (this.appCtx == null) {
            throw new IllegalStateException("Failed to get Cassandra DataSource cause Spring application context wasn't injected into CassandraCacheStoreFactory");
        }
        Object object = this.loadSpringContextBean(this.appCtx, this.dataSrcBean);
        if (!(object instanceof DataSource)) {
            throw new IllegalStateException("Incorrect connection bean '" + this.dataSrcBean + "' specified");
        }
        this.dataSrc = (DataSource)object;
        return this.dataSrc;
    }

    private KeyValuePersistenceSettings getPersistenceSettings() {
        if (this.persistenceSettings != null) {
            return this.persistenceSettings;
        }
        if (this.persistenceSettingsBean == null) {
            throw new IllegalStateException("Either persistence settings bean or persistence settings itself should be specified");
        }
        if (this.appCtx == null) {
            throw new IllegalStateException("Failed to get Cassandra persistence settings cause Spring application context wasn't injected into CassandraCacheStoreFactory");
        }
        Object object = this.loadSpringContextBean(this.appCtx, this.persistenceSettingsBean);
        if (!(object instanceof KeyValuePersistenceSettings)) {
            throw new IllegalStateException("Incorrect persistence settings bean '" + this.persistenceSettingsBean + "' specified");
        }
        this.persistenceSettings = (KeyValuePersistenceSettings)object;
        return this.persistenceSettings;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public CassandraCacheStoreFactory<K, V> setMaxPoolSize(int n) {
        this.maxPoolSize = n;
        return this;
    }

    private Object loadSpringContextBean(Object object, String string) {
        try {
            IgniteSpringHelper igniteSpringHelper = (IgniteSpringHelper)IgniteComponentType.SPRING.create(false);
            return igniteSpringHelper.loadBeanFromAppContext(object, string);
        }
        catch (Exception exception) {
            throw new IgniteException("Failed to load bean in application context [beanName=" + string + ", igniteConfig=" + object + ']', (Throwable)exception);
        }
    }
}

