/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.checkpoint.s3;

import java.io.IOException;
import java.io.InputStream;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

class S3CheckpointData {
    private final byte[] state;
    private final long expTime;
    private final String key;

    S3CheckpointData(byte[] state, long expTime, String key) {
        assert (expTime >= 0L);
        this.state = state;
        this.expTime = expTime;
        this.key = key;
    }

    byte[] getState() {
        return this.state;
    }

    long getExpireTime() {
        return this.expTime;
    }

    public String getKey() {
        return this.key;
    }

    public byte[] toBytes() {
        byte[] keyBytes = this.key.getBytes();
        byte[] bytes = new byte[4 + this.state.length + 8 + 4 + keyBytes.length];
        U.intToBytes((int)this.state.length, (byte[])bytes, (int)0);
        U.arrayCopy((byte[])this.state, (int)0, (byte[])bytes, (int)4, (int)this.state.length);
        U.longToBytes((long)this.expTime, (byte[])bytes, (int)(4 + this.state.length));
        U.intToBytes((int)keyBytes.length, (byte[])bytes, (int)(4 + this.state.length + 8));
        U.arrayCopy((byte[])keyBytes, (int)0, (byte[])bytes, (int)(4 + this.state.length + 8 + 4), (int)keyBytes.length);
        return bytes;
    }

    public static S3CheckpointData fromStream(InputStream in) throws IOException {
        byte[] buf = new byte[8];
        S3CheckpointData.read(in, buf, 4);
        byte[] state = new byte[U.bytesToInt((byte[])buf, (int)0)];
        S3CheckpointData.read(in, state, state.length);
        S3CheckpointData.read(in, buf, 8);
        long expTime = U.bytesToLong((byte[])buf, (int)0);
        S3CheckpointData.read(in, buf, 4);
        byte[] keyBytes = new byte[U.bytesToInt((byte[])buf, (int)0)];
        S3CheckpointData.read(in, keyBytes, keyBytes.length);
        return new S3CheckpointData(state, expTime, new String(keyBytes));
    }

    private static void read(InputStream in, byte[] buf, int len) throws IOException {
        int cnt = in.read(buf, 0, len);
        if (cnt < len) {
            throw new IOException("End of stream reached.");
        }
    }

    public String toString() {
        return S.toString(S3CheckpointData.class, (Object)this);
    }
}

