/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.structure;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.marshalling.ByteArrayMarshaller;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.marshalling.NoopMarshaller;
import org.apache.ignite.marshalling.UnsupportedObjectTypeMarshallingException;
import org.apache.ignite.sql.ColumnType;

public final class StructureUtils {
    private static final Map<Class<?>, ColumnType> NATIVE_CLASSES = Arrays.stream(ColumnType.values()).collect(Collectors.toMap(ColumnType::javaClass, Function.identity()));

    private StructureUtils() {
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static <T, R> Marshaller<T, R> cast(Marshaller<?, ?> marshaller) {
        return marshaller;
    }

    public static <K, V> Map<K, V> cast(Map<?, ?> map) {
        return map;
    }

    public static <T> Class<T> nativeOrByteArray(Class<?> clazz) {
        if (StructureUtils.isNativelySupported(clazz)) {
            return clazz;
        }
        return byte[].class;
    }

    public static <T> Marshaller<T, ?> marshaller(Class<T> clazz) {
        if (StructureUtils.isNativelySupported(clazz)) {
            return NoopMarshaller.create();
        }
        if (clazz != null && !Serializable.class.isAssignableFrom(clazz)) {
            throw new UnsupportedObjectTypeMarshallingException(clazz);
        }
        return ByteArrayMarshaller.create();
    }

    public static ColumnType columnType(Class<?> clazz) {
        return NATIVE_CLASSES.getOrDefault(clazz, ColumnType.BYTE_ARRAY);
    }

    private static boolean isNativelySupported(Class<?> clazz) {
        return NATIVE_CLASSES.get(clazz) != null;
    }
}

