/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.catalog.definitions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.catalog.definitions.IndexDefinition;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.table.QualifiedName;
import org.jetbrains.annotations.Nullable;

public class CacheDefinition {
    private final QualifiedName qualifiedName;
    private final boolean ifNotExists;
    private final List<ColumnDefinition> columns;
    private final IndexType pkType;
    private final List<ColumnSorted> pkColumns;
    private final List<String> colocationColumns;
    private final String zoneName;
    private final Class<?> keyClass;
    private final Class<?> valueClass;
    private final List<IndexDefinition> indexes;

    private CacheDefinition(QualifiedName qualifiedName, boolean ifNotExists, List<ColumnDefinition> columns, IndexType pkType, List<ColumnSorted> pkColumns, List<String> colocationColumns, String zoneName, Class<?> keyClass, Class<?> valueClass, List<IndexDefinition> indexes) {
        this.qualifiedName = qualifiedName;
        this.ifNotExists = ifNotExists;
        this.columns = columns;
        this.pkType = pkType;
        this.pkColumns = pkColumns;
        this.colocationColumns = colocationColumns;
        this.zoneName = zoneName;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.indexes = indexes;
    }

    public static Builder builder(String cacheName) {
        return new Builder().cacheName(cacheName);
    }

    public static Builder builder(QualifiedName qualifiedName) {
        Objects.requireNonNull(qualifiedName, "Qualified cache name must not be null.");
        String schemaName = IgniteNameUtils.quoteIfNeeded(qualifiedName.schemaName());
        String tableName = IgniteNameUtils.quoteIfNeeded(qualifiedName.objectName());
        return new Builder().cacheName(tableName).schema(schemaName);
    }

    public String cacheName() {
        return IgniteNameUtils.quoteIfNeeded(this.qualifiedName.objectName());
    }

    @Nullable
    public String schemaName() {
        return IgniteNameUtils.quoteIfNeeded(this.qualifiedName.schemaName());
    }

    public QualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Nullable
    public List<ColumnDefinition> columns() {
        return this.columns;
    }

    @Nullable
    public IndexType primaryKeyType() {
        return this.pkType;
    }

    @Nullable
    public List<ColumnSorted> primaryKeyColumns() {
        return this.pkColumns;
    }

    @Nullable
    public String zoneName() {
        return this.zoneName;
    }

    public List<String> colocationColumns() {
        return this.colocationColumns;
    }

    @Nullable
    public Class<?> keyClass() {
        return this.keyClass;
    }

    @Nullable
    public Class<?> valueClass() {
        return this.valueClass;
    }

    @Nullable
    public List<IndexDefinition> indexes() {
        return this.indexes;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheDefinition that = (CacheDefinition)o;
        return this.ifNotExists == that.ifNotExists && Objects.equals(this.qualifiedName, that.qualifiedName) && Objects.equals(this.columns, that.columns) && this.pkType == that.pkType && Objects.equals(this.pkColumns, that.pkColumns) && Objects.equals(this.colocationColumns, that.colocationColumns) && Objects.equals(this.zoneName, that.zoneName) && Objects.equals(this.indexes, that.indexes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.qualifiedName, this.ifNotExists, this.columns, this.pkType, this.pkColumns, this.colocationColumns, this.zoneName, this.indexes});
    }

    public static class Builder {
        private String cacheName;
        private String schemaName;
        private boolean ifNotExists;
        private List<ColumnDefinition> columns;
        private IndexType pkType;
        private List<ColumnSorted> pkColumns;
        private List<String> colocationColumns;
        private String zoneName;
        private Class<?> keyClass;
        private Class<?> valueClass;
        private final List<IndexDefinition> indexes = new ArrayList<IndexDefinition>();

        private Builder() {
        }

        private Builder(CacheDefinition definition) {
            this.cacheName = IgniteNameUtils.quoteIfNeeded(definition.qualifiedName.objectName());
            this.schemaName = IgniteNameUtils.quoteIfNeeded(definition.qualifiedName.schemaName());
            this.ifNotExists = definition.ifNotExists;
            this.columns = definition.columns;
            this.pkType = definition.pkType;
            this.pkColumns = definition.pkColumns;
            this.colocationColumns = definition.colocationColumns;
            this.zoneName = definition.zoneName;
        }

        Builder cacheName(String name) {
            Objects.requireNonNull(name, "Cache name must not be null.");
            if (name.isBlank()) {
                throw new IllegalArgumentException("Cache name must not be blank.");
            }
            this.cacheName = name;
            return this;
        }

        public Builder schema(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder ifNotExists() {
            this.ifNotExists = true;
            return this;
        }

        public Builder columns(ColumnDefinition ... columns) {
            Objects.requireNonNull(columns, "Columns array must not be null.");
            for (ColumnDefinition column : columns) {
                Objects.requireNonNull(column, "Column must not be null.");
            }
            return this.columns(Arrays.asList(columns));
        }

        public Builder columns(List<ColumnDefinition> columns) {
            Objects.requireNonNull(columns, "Columns list must not be null.");
            for (ColumnDefinition column : columns) {
                Objects.requireNonNull(column, "Column must not be null.");
            }
            this.columns = columns;
            return this;
        }

        public Builder colocateBy(String ... colocationColumns) {
            Objects.requireNonNull(colocationColumns, "Colocation columns array must not be null.");
            for (String column : colocationColumns) {
                Objects.requireNonNull(column, "Colocation column must not be null.");
            }
            return this.colocateBy(Arrays.asList(colocationColumns));
        }

        public Builder colocateBy(List<String> colocationColumns) {
            Objects.requireNonNull(colocationColumns, "Colocation columns list must not be null.");
            for (String column : colocationColumns) {
                Objects.requireNonNull(column, "Colocation column must not be null.");
            }
            this.colocationColumns = colocationColumns;
            return this;
        }

        public Builder zone(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder key(Class<?> keyClass) {
            this.keyClass = keyClass;
            return this;
        }

        public Builder value(Class<?> valueClass) {
            this.valueClass = valueClass;
            return this;
        }

        public Builder primaryKey(String ... columnNames) {
            Objects.requireNonNull(columnNames, "Primary key columns array must not be null.");
            for (String column : columnNames) {
                Objects.requireNonNull(column, "Primary key column must not be null.");
            }
            return this.primaryKey(IndexType.DEFAULT, Builder.mapToSortedColumns(columnNames));
        }

        public Builder primaryKey(IndexType type, ColumnSorted ... columns) {
            Objects.requireNonNull(type, "Primary key index type must not be null.");
            Objects.requireNonNull(columns, "Primary key columns array must not be null.");
            for (ColumnSorted column : columns) {
                Objects.requireNonNull(column, "Primary key column must not be null.");
            }
            return this.primaryKey(type, Arrays.asList(columns));
        }

        public Builder primaryKey(IndexType type, List<ColumnSorted> columns) {
            Objects.requireNonNull(type, "Primary key index type must not be null.");
            Objects.requireNonNull(columns, "Primary key columns list must not be null.");
            for (ColumnSorted column : columns) {
                Objects.requireNonNull(column, "Primary key column must not be null.");
            }
            this.pkType = type;
            this.pkColumns = columns;
            return this;
        }

        public Builder index(String ... columnNames) {
            Objects.requireNonNull(columnNames, "Index columns array must not be null.");
            for (String column : columnNames) {
                Objects.requireNonNull(column, "Index column must not be null.");
                if (!column.isBlank()) continue;
                throw new IllegalArgumentException("Index column must not be blank.");
            }
            return this.index(null, IndexType.DEFAULT, Builder.mapToSortedColumns(columnNames));
        }

        public Builder index(@Nullable String indexName, IndexType type, ColumnSorted ... columns) {
            Objects.requireNonNull(type, "Index type must not be null.");
            Objects.requireNonNull(columns, "Index columns array must not be null.");
            for (ColumnSorted column : columns) {
                Objects.requireNonNull(column, "Index column must not be null.");
            }
            return this.index(indexName, type, Arrays.asList(columns));
        }

        public Builder index(@Nullable String indexName, IndexType type, List<ColumnSorted> columns) {
            Objects.requireNonNull(type, "Index type must not be null.");
            Objects.requireNonNull(columns, "Index columns list must not be null.");
            for (ColumnSorted column : columns) {
                Objects.requireNonNull(column, "Index column must not be null.");
            }
            if (columns.isEmpty()) {
                throw new IllegalArgumentException("Index columns list must not be empty.");
            }
            this.indexes.add(new IndexDefinition(indexName, type, columns));
            return this;
        }

        public CacheDefinition build() {
            return new CacheDefinition(QualifiedName.of(this.schemaName, this.cacheName), this.ifNotExists, this.columns, this.pkType, this.pkColumns, this.colocationColumns, this.zoneName, this.keyClass, this.valueClass, this.indexes);
        }

        private static List<ColumnSorted> mapToSortedColumns(String[] columnNames) {
            return Arrays.stream(columnNames).map(ColumnSorted::column).collect(Collectors.toList());
        }
    }
}

