/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.structure;

import java.util.Objects;
import org.apache.ignite.lang.util.IgniteNameUtils;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.QualifiedName;
import org.gridgain.structure.StructureUtils;
import org.jetbrains.annotations.Nullable;

public class MapConfiguration {
    private final QualifiedName name;
    private final Class<?> keyClass;
    private final Class<?> valueClass;
    private final Marshaller<?, byte[]> keyMarshaller;
    private final Marshaller<?, byte[]> valueMarshaller;
    @Nullable
    private final String distributionZone;
    @Nullable
    private final String storageProfile;

    private MapConfiguration(QualifiedName name, Class<?> keyClass, Class<?> valueClass, Marshaller<?, byte[]> keyMarshaller, Marshaller<?, byte[]> valueMarshaller, @Nullable String distributionZone, @Nullable String storageProfile) {
        this.name = name;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.keyMarshaller = keyMarshaller;
        this.valueMarshaller = valueMarshaller;
        this.distributionZone = distributionZone;
        this.storageProfile = storageProfile;
    }

    public static Builder builder(String mapName, Class<?> keyClass, Class<?> valueClass) {
        return new Builder().name(mapName).keyClass(keyClass).valueClass(valueClass);
    }

    public static Builder builder(String mapName, Marshaller<?, byte[]> keyMarshaller, Marshaller<?, byte[]> valueMarshaller) {
        return new Builder().name(mapName).keyMarshaller(keyMarshaller).valueMarshaller(valueMarshaller);
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Class<?> getKeyClass() {
        return this.keyClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public Marshaller<?, byte[]> getKeyMarshaller() {
        return this.keyMarshaller;
    }

    public Marshaller<?, byte[]> getValueMarshaller() {
        return this.valueMarshaller;
    }

    @Nullable
    public String getDistributionZone() {
        return this.distributionZone;
    }

    @Nullable
    public String getStorageProfile() {
        return this.storageProfile;
    }

    public static class Builder {
        private QualifiedName name;
        private Class<?> keyClass;
        private Class<?> valueClass;
        private Marshaller<?, byte[]> keyMarshaller;
        private Marshaller<?, byte[]> valueMarshaller;
        @Nullable
        private String distributionZone;
        @Nullable
        private String storageProfile;

        private Builder name(String mapName) {
            this.name = QualifiedName.fromSimple(IgniteNameUtils.quoteIfNeeded(mapName));
            return this;
        }

        private Builder keyClass(Class<?> keyClass) {
            this.keyClass = keyClass;
            return this;
        }

        private Builder valueClass(Class<?> valueClass) {
            this.valueClass = valueClass;
            return this;
        }

        private Builder keyMarshaller(Marshaller<?, byte[]> keyMarshaller) {
            this.keyMarshaller = keyMarshaller;
            return this;
        }

        private Builder valueMarshaller(Marshaller<?, byte[]> valueMarshaller) {
            this.valueMarshaller = valueMarshaller;
            return this;
        }

        public Builder distributionZone(@Nullable String distributionZone) {
            this.distributionZone = distributionZone;
            return this;
        }

        public Builder storageProfile(@Nullable String storageProfile) {
            this.storageProfile = storageProfile;
            return this;
        }

        public MapConfiguration build() {
            return new MapConfiguration(this.name, StructureUtils.nativeOrByteArray(this.keyClass), StructureUtils.nativeOrByteArray(this.valueClass), Objects.requireNonNullElse(this.keyMarshaller, StructureUtils.cast(StructureUtils.marshaller(this.keyClass))), Objects.requireNonNullElse(this.valueMarshaller, StructureUtils.cast(StructureUtils.marshaller(this.valueClass))), this.distributionZone, this.storageProfile);
        }
    }
}

