/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.catalog;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.catalog.definitions.CacheDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;

public interface IgniteCatalog {
    public CompletableFuture<Table> createTableAsync(Class<?> var1);

    public CompletableFuture<Table> createTableAsync(Class<?> var1, Class<?> var2);

    public CompletableFuture<Table> createTableAsync(TableDefinition var1);

    public Table createTable(Class<?> var1);

    public Table createTable(Class<?> var1, Class<?> var2);

    public Table createTable(TableDefinition var1);

    default public CompletableFuture<TableDefinition> tableDefinitionAsync(String tableName) {
        return this.tableDefinitionAsync(QualifiedName.parse(tableName));
    }

    public CompletableFuture<TableDefinition> tableDefinitionAsync(QualifiedName var1);

    default public TableDefinition tableDefinition(String tableName) {
        return this.tableDefinition(QualifiedName.parse(tableName));
    }

    public TableDefinition tableDefinition(QualifiedName var1);

    public CompletableFuture<Void> createZoneAsync(ZoneDefinition var1);

    public void createZone(ZoneDefinition var1);

    public CompletableFuture<ZoneDefinition> zoneDefinitionAsync(String var1);

    public ZoneDefinition zoneDefinition(String var1);

    public CompletableFuture<Void> dropTableAsync(TableDefinition var1);

    default public CompletableFuture<Void> dropTableAsync(String name) {
        return this.dropTableAsync(QualifiedName.parse(name));
    }

    public CompletableFuture<Void> dropTableAsync(QualifiedName var1);

    public void dropTable(TableDefinition var1);

    default public void dropTable(String tableName) {
        this.dropTable(QualifiedName.parse(tableName));
    }

    public void dropTable(QualifiedName var1);

    public CompletableFuture<Void> dropZoneAsync(ZoneDefinition var1);

    public CompletableFuture<Void> dropZoneAsync(String var1);

    public void dropZone(ZoneDefinition var1);

    public void dropZone(String var1);

    public Cache createCache(Class<?> var1, Class<?> var2);

    public Cache createCache(CacheDefinition var1);

    public CompletableFuture<Cache> createCacheAsync(Class<?> var1, Class<?> var2);

    public CompletableFuture<Cache> createCacheAsync(CacheDefinition var1);

    public CacheDefinition cacheDefinition(QualifiedName var1);

    default public CacheDefinition cacheDefinition(String name) {
        return this.cacheDefinition(QualifiedName.parse(name));
    }

    public CompletableFuture<CacheDefinition> cacheDefinitionAsync(QualifiedName var1);

    default public CompletableFuture<CacheDefinition> cacheDefinitionAsync(String name) {
        return this.cacheDefinitionAsync(QualifiedName.parse(name));
    }

    public void dropCache(CacheDefinition var1);

    public void dropCache(QualifiedName var1);

    default public void dropCache(String name) {
        this.dropCache(QualifiedName.parse(name));
    }

    public CompletableFuture<Void> dropCacheAsync(CacheDefinition var1);

    public CompletableFuture<Void> dropCacheAsync(QualifiedName var1);

    default public CompletableFuture<Void> dropCacheAsync(String name) {
        return this.dropCacheAsync(QualifiedName.parse(name));
    }
}

