/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop.aspectj;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.gridify.Gridify;
import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.compute.gridify.GridifyInterceptor;
import org.apache.ignite.compute.gridify.GridifyRuntimeException;
import org.apache.ignite.compute.gridify.aop.GridifyArgumentAdapter;
import org.apache.ignite.compute.gridify.aop.GridifyDefaultTask;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class GridifyAspectJAspect {
    @Around(value="execution(@org.apache.ignite.compute.gridify.Gridify * *(..)) && !cflow(call(* org.apache.ignite.compute.ComputeJob.*(..)))")
    public Object gridify(ProceedingJoinPoint joinPnt) throws Throwable {
        String igniteInstanceName;
        Method mtd = ((MethodSignature)joinPnt.getSignature()).getMethod();
        Gridify ann = mtd.getAnnotation(Gridify.class);
        assert (ann != null) : "Intercepted method does not have gridify annotation.";
        String string = igniteInstanceName = F.isEmpty((String)ann.igniteInstanceName()) ? ann.gridName() : ann.igniteInstanceName();
        if (F.isEmpty((String)igniteInstanceName)) {
            igniteInstanceName = null;
        }
        if (G.state((String)igniteInstanceName) != IgniteState.STARTED) {
            throw new IgniteCheckedException("Grid is not locally started: " + igniteInstanceName);
        }
        GridifyArgumentAdapter arg = new GridifyArgumentAdapter(mtd.getDeclaringClass(), mtd.getName(), (Class[])mtd.getParameterTypes(), joinPnt.getArgs(), joinPnt.getTarget());
        if (!ann.interceptor().equals(GridifyInterceptor.class) && !((GridifyInterceptor)ann.interceptor().newInstance()).isGridify((Annotation)ann, (GridifyArgument)arg)) {
            return joinPnt.proceed();
        }
        if (!ann.taskClass().equals(GridifyDefaultTask.class) && !ann.taskName().isEmpty()) {
            throw new IgniteCheckedException("Gridify annotation must specify either Gridify.taskName() or Gridify.taskClass(), but not both: " + ann);
        }
        try {
            Ignite ignite = G.ignite((String)igniteInstanceName);
            if (!ann.taskClass().equals(GridifyDefaultTask.class)) {
                return ignite.compute().withTimeout(ann.timeout()).execute(ann.taskClass(), (Object)arg);
            }
            if (ann.taskName().isEmpty()) {
                return ignite.compute().withTimeout(ann.timeout()).execute((ComputeTask)new GridifyDefaultTask(joinPnt.getSignature().getDeclaringType()), (Object)arg);
            }
            return ignite.compute().withTimeout(ann.timeout()).execute(ann.taskName(), (Object)arg);
        }
        catch (Exception e) {
            for (Class<?> ex : ((MethodSignature)joinPnt.getSignature()).getMethod().getExceptionTypes()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!ex.isAssignableFrom(cause.getClass())) continue;
                    throw cause;
                }
                if (!ex.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            throw new GridifyRuntimeException("Undeclared exception thrown: " + e.getMessage(), (Throwable)e);
        }
    }
}

