/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop.spring;

import org.aopalliance.aop.Advice;
import org.apache.ignite.compute.gridify.aop.spring.GridifySetToSetSpringAspect;
import org.apache.ignite.compute.gridify.aop.spring.GridifySetToValueSpringAspect;
import org.apache.ignite.compute.gridify.aop.spring.GridifySpringAspect;
import org.apache.ignite.compute.gridify.aop.spring.GridifySpringPointcut;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;

public final class GridifySpringEnhancer {
    private static final GridifySpringAspect dfltAsp = new GridifySpringAspect();
    private static final GridifySetToSetSpringAspect setToSetAsp = new GridifySetToSetSpringAspect();
    private static final GridifySetToValueSpringAspect setToValAsp = new GridifySetToValueSpringAspect();

    private GridifySpringEnhancer() {
    }

    public static <T> T enhance(T obj) {
        ProxyFactory proxyFac = new ProxyFactory(obj);
        proxyFac.addAdvice((Advice)dfltAsp);
        proxyFac.addAdvice((Advice)setToValAsp);
        proxyFac.addAdvice((Advice)setToSetAsp);
        while (proxyFac.getAdvisors().length > 0) {
            proxyFac.removeAdvisor(0);
        }
        proxyFac.addAdvisor((Advisor)new DefaultPointcutAdvisor((Pointcut)new GridifySpringPointcut(GridifySpringPointcut.GridifySpringPointcutType.DFLT), (Advice)dfltAsp));
        proxyFac.addAdvisor((Advisor)new DefaultPointcutAdvisor((Pointcut)new GridifySpringPointcut(GridifySpringPointcut.GridifySpringPointcutType.SET_TO_VALUE), (Advice)setToValAsp));
        proxyFac.addAdvisor((Advisor)new DefaultPointcutAdvisor((Pointcut)new GridifySpringPointcut(GridifySpringPointcut.GridifySpringPointcutType.SET_TO_SET), (Advice)setToSetAsp));
        return (T)proxyFac.getProxy();
    }
}

