/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.compute.gridify.aop.aspectj;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteState;
import org.apache.ignite.compute.gridify.GridifyArgument;
import org.apache.ignite.compute.gridify.GridifyInterceptor;
import org.apache.ignite.compute.gridify.GridifyNodeFilter;
import org.apache.ignite.compute.gridify.GridifyRuntimeException;
import org.apache.ignite.compute.gridify.GridifySetToValue;
import org.apache.ignite.compute.gridify.aop.GridifySetToValueAbstractAspect;
import org.apache.ignite.internal.util.gridify.GridifyArgumentBuilder;
import org.apache.ignite.internal.util.gridify.GridifyRangeArgument;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class GridifySetToValueAspectJAspect
extends GridifySetToValueAbstractAspect {
    @Around(value="execution(@org.apache.ignite.compute.gridify.GridifySetToValue * *(..)) && !cflow(call(* org.apache.ignite.compute.ComputeJob.*(..)))")
    public Object gridify(ProceedingJoinPoint joinPnt) throws Throwable {
        String igniteInstanceName;
        Method mtd = ((MethodSignature)joinPnt.getSignature()).getMethod();
        GridifySetToValue ann = mtd.getAnnotation(GridifySetToValue.class);
        assert (ann != null) : "Intercepted method does not have gridify annotation.";
        String string = igniteInstanceName = F.isEmpty((String)ann.igniteInstanceName()) ? ann.gridName() : ann.igniteInstanceName();
        if (F.isEmpty((String)igniteInstanceName)) {
            igniteInstanceName = null;
        }
        if (G.state((String)igniteInstanceName) != IgniteState.STARTED) {
            throw new IgniteCheckedException("Grid is not locally started: " + igniteInstanceName);
        }
        GridifyNodeFilter nodeFilter = null;
        if (!ann.nodeFilter().equals(GridifyNodeFilter.class)) {
            nodeFilter = (GridifyNodeFilter)ann.nodeFilter().newInstance();
        }
        this.checkMethodSignature(mtd);
        GridifyArgumentBuilder argBuilder = new GridifyArgumentBuilder();
        GridifyRangeArgument arg = argBuilder.createTaskArgument(mtd.getDeclaringClass(), mtd.getName(), mtd.getReturnType(), (Class[])mtd.getParameterTypes(), mtd.getParameterAnnotations(), joinPnt.getArgs(), joinPnt.getTarget());
        if (!ann.interceptor().equals(GridifyInterceptor.class) && !((GridifyInterceptor)ann.interceptor().newInstance()).isGridify((Annotation)ann, (GridifyArgument)arg)) {
            return joinPnt.proceed();
        }
        if (ann.threshold() < 0) {
            return joinPnt.proceed();
        }
        if (arg.getInputSize() != -1 && arg.getInputSize() <= ann.threshold()) {
            return joinPnt.proceed();
        }
        this.checkIsSplitToJobsAllowed(arg, ann);
        try {
            Ignite ignite = G.ignite((String)igniteInstanceName);
            return this.execute(mtd, ignite.compute(), joinPnt.getSignature().getDeclaringType(), arg, nodeFilter, ann.threshold(), ann.splitSize(), ann.timeout());
        }
        catch (Exception e) {
            for (Class<?> ex : ((MethodSignature)joinPnt.getSignature()).getMethod().getExceptionTypes()) {
                for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                    if (!ex.isAssignableFrom(cause.getClass())) continue;
                    throw cause;
                }
                if (!ex.isAssignableFrom(e.getClass())) continue;
                throw e;
            }
            throw new GridifyRuntimeException("Undeclared exception thrown: " + e.getMessage(), (Throwable)e);
        }
    }
}

