/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.upgrade;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.manager.ComponentContext;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.rbac.privileges.Action;
import org.gridgain.internal.upgrade.RollingUpgradeManager;
import org.gridgain.internal.upgrade.UpgradeState;

public class SecuredRollingUpgradeManager
implements RollingUpgradeManager {
    private final Authorizer authorizer;
    private final RollingUpgradeManager upgradeManager;

    public SecuredRollingUpgradeManager(Authorizer authorizer, RollingUpgradeManager upgradeManager) {
        this.authorizer = authorizer;
        this.upgradeManager = upgradeManager;
    }

    public CompletableFuture<Boolean> startUpgrade(String version) {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> this.upgradeManager.startUpgrade(version));
    }

    public CompletableFuture<Boolean> cancelUpgrade() {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> ((RollingUpgradeManager)this.upgradeManager).cancelUpgrade());
    }

    public CompletableFuture<Boolean> commitUpgrade() {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> ((RollingUpgradeManager)this.upgradeManager).commitUpgrade());
    }

    public CompletableFuture<Boolean> isUpgradeInProgress() {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> ((RollingUpgradeManager)this.upgradeManager).isUpgradeInProgress());
    }

    public CompletableFuture<Void> blockConfigurationUpdatesIfNeeded() {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> ((RollingUpgradeManager)this.upgradeManager).blockConfigurationUpdatesIfNeeded());
    }

    public CompletableFuture<Boolean> isNodeUpgraded(String nodeId) {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> this.upgradeManager.isNodeUpgraded(nodeId));
    }

    public CompletableFuture<Boolean> isTargetVersion(String version) {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> this.upgradeManager.isTargetVersion(version));
    }

    public CompletableFuture<UpgradeState> upgradeState() {
        return this.authorizer.authorizeThenCompose(Action.ROLLING_UPGRADE, () -> ((RollingUpgradeManager)this.upgradeManager).upgradeState());
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return this.upgradeManager.startAsync(componentContext);
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return this.upgradeManager.stopAsync(componentContext);
    }
}

