/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.upgrade.messaging;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.version.IgniteProductVersionSource;
import org.gridgain.internal.upgrade.messaging.RollingUpgradeMessageGroup;
import org.gridgain.internal.upgrade.messaging.RollingUpgradeMessageGroupFactory;
import org.gridgain.internal.upgrade.messaging.RollingUpgradeNodeStateRequest;
import org.gridgain.internal.upgrade.messaging.RollingUpgradeNodeStateResponse;

public class RollingUpgradeMessaging {
    private static final long NETWORK_TIMEOUT_MILLIS = 10000L;
    private final MessagingService messagingService;
    private final TopologyService topologyService;
    private final IgniteProductVersionSource versionProvider;
    private final RollingUpgradeMessageGroupFactory factory = new RollingUpgradeMessageGroupFactory();

    public RollingUpgradeMessaging(MessagingService messagingService, TopologyService topologyService, IgniteProductVersionSource versionProvider) {
        this.messagingService = messagingService;
        this.topologyService = topologyService;
        this.versionProvider = versionProvider;
    }

    public CompletableFuture<String> nodeVersion(String nodeId) {
        return this.messagingService.invoke(nodeId, (NetworkMessage)this.factory.rollingUpgradeNodeStateRequest().build(), 10000L).thenApply(response -> {
            if (response instanceof RollingUpgradeNodeStateResponse) {
                return ((RollingUpgradeNodeStateResponse)response).currentVersion();
            }
            return null;
        });
    }

    public void start() {
        this.messagingService.addMessageHandler(RollingUpgradeMessageGroup.class, (message, sender, correlationId) -> {
            assert (correlationId != null);
            this.processRequest(message, sender, correlationId);
        });
    }

    private CompletableFuture<Boolean> broadcast(NetworkMessage message) {
        CompletableFuture[] futures = (CompletableFuture[])this.topologyService.allMembers().stream().map(node -> this.messagingService.invoke(node, message, 10000L)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenCompose(unused -> CompletableFuture.completedFuture(true));
    }

    private void processRequest(NetworkMessage message, InternalClusterNode sender, long correlationId) {
        if (message instanceof RollingUpgradeNodeStateRequest) {
            this.processNodeStateRequest((RollingUpgradeNodeStateRequest)message, sender, correlationId);
        }
    }

    private void processNodeStateRequest(RollingUpgradeNodeStateRequest request, InternalClusterNode sender, long correlationId) {
        this.messagingService.respond(sender, (NetworkMessage)this.factory.rollingUpgradeNodeStateResponse().currentVersion(this.versionProvider.productVersion().toString()).build(), correlationId);
    }
}

