/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.upgrade;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.cluster.management.ClusterStateV2;
import org.apache.ignite.internal.configuration.ConfigurationRegistry;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.network.MessagingService;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.version.IgniteProductVersionSource;
import org.gridgain.internal.upgrade.RollingUpgradeManager;
import org.gridgain.internal.upgrade.UpgradeState;
import org.gridgain.internal.upgrade.messaging.RollingUpgradeMessaging;

public class RollingUpgradeManagerImpl
implements RollingUpgradeManager {
    private static final IgniteLogger LOG = Loggers.forClass(RollingUpgradeManagerImpl.class);
    private final RollingUpgradeMessaging messaging;
    private final ClusterManagementGroupManager cmgManager;
    private final ConfigurationRegistry clusterConfiguration;

    public RollingUpgradeManagerImpl(MessagingService messagingService, TopologyService topologyService, ClusterManagementGroupManager cmgManager, IgniteProductVersionSource versionProvider, ConfigurationRegistry clusterConfiguration) {
        this.messaging = new RollingUpgradeMessaging(messagingService, topologyService, versionProvider);
        this.cmgManager = cmgManager;
        this.clusterConfiguration = clusterConfiguration;
    }

    public CompletableFuture<Boolean> startUpgrade(String version) {
        LOG.info("Starting rolling upgrade to version: " + version, new Object[0]);
        return this.cmgManager.rollingUpgradeVersion(version).thenApply(unused -> true);
    }

    public CompletableFuture<Boolean> commitUpgrade() {
        LOG.info("Committing rolling upgrade", new Object[0]);
        return this.cmgManager.rollingUpgradeCommit().thenApply(unused -> true);
    }

    public CompletableFuture<Boolean> cancelUpgrade() {
        LOG.info("Canceling rolling upgrade", new Object[0]);
        return CompletableFuture.failedFuture(new UnsupportedOperationException("Cancel upgrade is not implemented yet"));
    }

    public CompletableFuture<Boolean> isUpgradeInProgress() {
        return this.cmgManager.clusterState().thenApply(state -> {
            if (state instanceof ClusterStateV2) {
                return ((ClusterStateV2)state).nextVersion() != null;
            }
            return false;
        });
    }

    public CompletableFuture<Void> blockConfigurationUpdatesIfNeeded() {
        return this.isUpgradeInProgress().thenApply(upgradeInProgress -> {
            if (upgradeInProgress.booleanValue()) {
                LOG.info("Rolling upgrade in progress, blocking cluster configuration updates", new Object[0]);
                this.clusterConfiguration.blockUpdates();
            }
            return null;
        });
    }

    public CompletableFuture<Boolean> isNodeUpgraded(String nodeId) {
        return this.cmgManager.clusterState().thenCompose(state -> {
            if (state instanceof ClusterStateV2) {
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                if (stateV2.nextVersion() == null) {
                    return CompletableFutures.falseCompletedFuture();
                }
                return this.messaging.nodeVersion(nodeId).thenApply(version -> version.equals(stateV2.nextVersion()));
            }
            return CompletableFutures.falseCompletedFuture();
        });
    }

    public CompletableFuture<Boolean> isTargetVersion(String version) {
        return this.cmgManager.clusterState().thenApply(state -> {
            if (state instanceof ClusterStateV2) {
                ClusterStateV2 stateV2 = (ClusterStateV2)state;
                if (stateV2.nextVersion() == null) {
                    return true;
                }
                return stateV2.nextVersion().equals(version);
            }
            return true;
        });
    }

    public CompletableFuture<UpgradeState> upgradeState() {
        return CompletableFuture.failedFuture(new UnsupportedOperationException("Upgrade state is not implemented yet"));
    }

    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        return ((CompletableFuture)this.isUpgradeInProgress().thenAccept(upgradeInProgress -> {
            if (!upgradeInProgress.booleanValue()) {
                this.clusterConfiguration.unblockUpdates();
            }
        })).thenRun(this.messaging::start);
    }

    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        return CompletableFutures.nullCompletedFuture();
    }
}

