/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote.wal;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;

class UnzipFileIO
extends AbstractFileIO {
    private final ZipInputStream zis;
    private final byte[] arr = new byte[131072];
    private final long size;
    private long totalBytesRead = 0L;

    public UnzipFileIO(InputStream inputStream) throws IOException {
        this.zis = new ZipInputStream(new BufferedInputStream(inputStream));
        ZipEntry entry = this.zis.getNextEntry();
        if (entry == null) {
            this.close();
            throw new IOException("Failed to read entry");
        }
        this.size = entry.getSize();
    }

    public int getFileSystemBlockSize() {
        return -1;
    }

    public long getSparseSize() {
        return -1L;
    }

    public int punchHole(long position, int len) {
        throw new UnsupportedOperationException();
    }

    public long position() throws IOException {
        return this.totalBytesRead;
    }

    public void position(long newPosition) throws IOException {
        int bytesToRead;
        if (newPosition == this.totalBytesRead) {
            return;
        }
        if (newPosition < this.totalBytesRead) {
            throw new UnsupportedOperationException("Seeking backwards is not supported.");
        }
        for (long bytesRemaining = newPosition - this.totalBytesRead; bytesRemaining > 0L; bytesRemaining -= (long)this.zis.read(this.arr, 0, bytesToRead)) {
            bytesToRead = bytesRemaining > (long)this.arr.length ? this.arr.length : (int)bytesRemaining;
        }
    }

    public int read(ByteBuffer dstBuf) throws IOException {
        int bytesRead = this.zis.read(this.arr, 0, Math.min(dstBuf.remaining(), this.arr.length));
        if (bytesRead == -1) {
            return -1;
        }
        dstBuf.put(this.arr, 0, bytesRead);
        this.totalBytesRead += (long)bytesRead;
        return bytesRead;
    }

    public int read(ByteBuffer dstBuf, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int write(ByteBuffer srcBuf) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int write(ByteBuffer srcBuf, long position) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int write(byte[] buf, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void force() throws IOException {
        this.force(false);
    }

    public void force(boolean withMetadata) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long size() throws IOException {
        return this.size;
    }

    public void clear() throws IOException {
        throw new UnsupportedOperationException();
    }

    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        this.zis.close();
    }
}

