/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file.remote.wal;

import java.io.File;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.IteratorParametersBuilder;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.RemoteIgniteCacheDatabaseSharedManager;
import org.gridgain.grid.persistentstore.snapshot.file.remote.wal.RemoteWalIterator;
import org.jetbrains.annotations.NotNull;

public class GridGainWalIteratorFactory {
    private final IgniteLogger log;
    private final IgniteWalIteratorFactory igniteWalIteratorFactory;

    public GridGainWalIteratorFactory(IgniteLogger log) {
        this.log = log;
        this.igniteWalIteratorFactory = new IgniteWalIteratorFactory(log);
    }

    public WALIterator iterator(@NotNull IteratorParametersBuilder iteratorParametersBuilder, @NotNull SnapshotPath snapshotPath) throws IgniteCheckedException, IllegalArgumentException {
        if (snapshotPath instanceof FsSnapshotPath) {
            return this.igniteWalIteratorFactory.iterator(iteratorParametersBuilder.toIgniteBuilder().filesOrDirs(new File[]{((FsSnapshotPath)snapshotPath).getFile()}));
        }
        return new RemoteWalIterator(this.log, iteratorParametersBuilder, this.createFakeSharedCtx(iteratorParametersBuilder), snapshotPath);
    }

    @NotNull
    private GridCacheSharedContext createFakeSharedCtx(IteratorParametersBuilder iteratorParametersBuilder) throws IgniteCheckedException {
        StandaloneGridKernalContext kernalCtx = new StandaloneGridKernalContext(this.log, iteratorParametersBuilder.binaryMetadataFileStoreDir, iteratorParametersBuilder.marshallerMappingFileStoreDir);
        RemoteIgniteCacheDatabaseSharedManager dbMgr = new RemoteIgniteCacheDatabaseSharedManager();
        dbMgr.setPageSize(iteratorParametersBuilder.pageSize);
        return new GridCacheSharedContext((GridKernalContext)kernalCtx, null, null, null, null, null, null, (IgniteCacheDatabaseSharedManager)dbMgr, null, null, null, null, null, null, null, null, null, null, null, null);
    }
}

