/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.lang.IgniteBiClosure;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotSecurityLevel;
import org.gridgain.grid.persistentstore.snapshot.file.FileDatabaseSnapshotSpi;
import org.jetbrains.annotations.Nullable;

public class PreviousSnapshotsIterable
implements Iterable<Snapshot> {
    private final long snapshotId;
    private final String consistentId;
    private final Set<Integer> groupIds;
    private final FileDatabaseSnapshotSpi snapshotSpi;
    private final Collection<SnapshotPath> paths;
    private final boolean ignoreMissedClasses;
    private final SnapshotSecurityLevel securityLevel;

    public PreviousSnapshotsIterable(long snapshotId, String consistentId, Set<Integer> groupIds, FileDatabaseSnapshotSpi snapshotSpi, Collection<SnapshotPath> paths, boolean ignoreMissedClasses, SnapshotSecurityLevel securityLevel) {
        this.snapshotId = snapshotId;
        this.consistentId = consistentId;
        this.groupIds = groupIds != null ? new HashSet<Integer>(groupIds) : new HashSet();
        this.snapshotSpi = snapshotSpi;
        this.paths = paths != null ? new ArrayList<SnapshotPath>(paths) : new ArrayList();
        this.ignoreMissedClasses = ignoreMissedClasses;
        this.securityLevel = securityLevel;
    }

    @Override
    public Iterator<Snapshot> iterator() {
        return new SnapshotIterator(this.consistentId, this.snapshotId, this.snapshotSpi, this.paths, this.ignoreMissedClasses, this.securityLevel, this.groupIds);
    }

    private static class SnapshotIterator
    implements Iterator<Snapshot> {
        private final Deque<Long> snapshotIdQueue;
        private final Set<Long> resultIds = new HashSet<Long>();
        private final String consistentId;
        private final FileDatabaseSnapshotSpi snapshotSpi;
        private final Collection<SnapshotPath> paths;
        private final boolean ignoreMissedClasses;
        private final SnapshotSecurityLevel securityLevel;
        private final Set<Integer> groupIds;
        Snapshot current;
        boolean reachedEnd;

        public SnapshotIterator(String consistentId, long snapshotId, FileDatabaseSnapshotSpi snapshotSpi, Collection<SnapshotPath> paths, boolean ignoreMissedClasses, SnapshotSecurityLevel securityLevel, Set<Integer> groupIds) {
            this.consistentId = consistentId;
            this.snapshotSpi = snapshotSpi;
            this.paths = paths;
            this.ignoreMissedClasses = ignoreMissedClasses;
            this.securityLevel = securityLevel;
            this.groupIds = groupIds;
            this.snapshotIdQueue = new LinkedList<Long>();
            this.snapshotIdQueue.add(snapshotId);
        }

        private Snapshot findNext() {
            Long snapId;
            if (this.snapshotIdQueue.isEmpty()) {
                return null;
            }
            while (this.resultIds.contains(snapId = this.snapshotIdQueue.poll()) && !this.snapshotIdQueue.isEmpty()) {
            }
            if (this.resultIds.contains(snapId)) {
                return null;
            }
            Snapshot next = this.snapshotSpi.snapshot((long)snapId, (Collection)this.paths, (IgniteBiClosure)null, this.ignoreMissedClasses, this.securityLevel, false);
            this.resultIds.add(snapId);
            if (next == null) {
                return new MissingSnapshot(snapId);
            }
            if (next.metadata().fullSnapshot()) {
                return next;
            }
            Map map = next.metadata().cacheGroupsMetadata();
            Set prevSnaps = map.values().stream().filter(metadata -> this.groupIds == null || this.groupIds.contains(metadata.groupId())).map(meta -> meta.previousSnapshotId(this.consistentId)).filter(value -> value != null && value != 0L).collect(Collectors.toSet());
            this.snapshotIdQueue.addAll(prevSnaps);
            return next;
        }

        @Override
        public boolean hasNext() {
            if (this.reachedEnd) {
                return false;
            }
            if (this.current == null) {
                this.current = this.findNext();
            }
            if (this.current == null) {
                this.reachedEnd = true;
                return false;
            }
            return true;
        }

        @Override
        public Snapshot next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Snapshot snap = this.current;
            this.current = null;
            return snap;
        }
    }

    private static final class MissingSnapshot
    implements Snapshot {
        private final String errorReason;
        private final long id;

        private MissingSnapshot(long id) {
            this.id = id;
            this.errorReason = "Failed to find previous snapshot: " + id;
        }

        public SnapshotInputStream indexStream(int cacheGrpId, BitSet parts) {
            throw new UnsupportedOperationException(this.errorReason);
        }

        public SnapshotInputStream indexStream(int cacheGrpId, String consistentId) {
            throw new UnsupportedOperationException(this.errorReason);
        }

        public SnapshotInputStream cacheInputStreams(int cacheGrpId, String cacheOrGrpName, int partId) {
            throw new UnsupportedOperationException(this.errorReason);
        }

        public SnapshotInputStream cacheInputStreams(int cacheGrpId, String cacheOrGrpName, String consistentId, int partId) {
            throw new UnsupportedOperationException(this.errorReason);
        }

        public long id() {
            return this.id;
        }

        public Collection<Integer> cacheGroupIds() {
            throw new UnsupportedOperationException(this.errorReason);
        }

        @Nullable
        public SnapshotMetadataV2 metadata() {
            throw new UnsupportedOperationException(this.errorReason);
        }

        @Nullable
        public SnapshotMetadataV2 metadata(String consistentId) {
            throw new UnsupportedOperationException(this.errorReason);
        }

        public SnapshotMetadataV2 verifiedMetadata() throws IgniteCheckedException {
            throw new IgniteCheckedException(this.errorReason);
        }

        public Iterable<Snapshot> getPreviousSnapshots(@Nullable Set<Integer> groupIds, @Nullable Collection<SnapshotPath> paths) {
            throw new UnsupportedOperationException(this.errorReason);
        }

        public boolean isPresent() {
            return false;
        }
    }
}

