/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.persistentstore.snapshot.file;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.MarkerPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.FastCrc;
import org.apache.ignite.internal.processors.cache.persistence.wal.crc.IgniteDataIntegrityViolationException;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleFileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializerFactory;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.io.SnapshotReadableByteChannel;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class FileSnapshotInputStream
implements SnapshotInputStream {
    private static final int WAL_RECORDS_ITERATOR_BUFFER_INITIAL_SIZE = 1024;
    private final int partId;
    private final SnapshotReadableByteChannel channel;
    private final AtomicInteger pos = new AtomicInteger(0);
    private final AtomicInteger walRecordsRead = new AtomicInteger(0);
    private final int pageSize;
    private final String consistentId;
    private final ByteBufferExpander expander;
    private final SimpleFileInput fileInput;
    private final RecordSerializerFactory recordSerializerFactory;
    private RecordSerializer recordSerializer;
    private volatile Integer recordSerializerVersion = null;
    private volatile int walRecordsCountToRead;

    FileSnapshotInputStream(SnapshotReadableByteChannel channel, int partId, int pageSize, String consistentId, boolean initWALFileInput, @Nullable RecordSerializerFactory recordSerializerFactory) {
        this.channel = channel;
        this.partId = partId;
        this.pageSize = pageSize;
        this.consistentId = consistentId;
        this.recordSerializerFactory = recordSerializerFactory;
        this.expander = initWALFileInput ? new ByteBufferExpander(1024, ByteOrder.nativeOrder()) : null;
        try {
            this.fileInput = this.expander == null ? null : new SimpleFileInput((FileIO)new InputStreamFileIO(channel.plain()), this.expander);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int partId() {
        return this.partId;
    }

    public String consistentId() {
        return this.consistentId;
    }

    public boolean readNextPage(ByteBuffer buf) throws IOException {
        int read;
        assert (buf.remaining() == this.pageSize);
        int startPos = this.pos.get();
        while ((read = this.channel.read(buf)) != -1) {
            this.pos.addAndGet(read);
            if (buf.hasRemaining()) continue;
        }
        if (!buf.hasRemaining() && PageIO.getPageId((ByteBuffer)buf) != 0L) {
            PageIO io = null;
            try {
                io = PageIO.getPageIO((ByteBuffer)buf);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (io instanceof MarkerPageIO) {
                MarkerPageIO markerPageIO = (MarkerPageIO)io;
                int savedCrc = PageIO.getCrc((ByteBuffer)buf);
                PageIO.setCrc((ByteBuffer)buf, (int)0);
                buf.position(0);
                int calcCrc = FastCrc.calcCrc((ByteBuffer)buf, (int)this.pageSize);
                PageIO.setCrc((ByteBuffer)buf, (int)savedCrc);
                if (calcCrc != savedCrc) {
                    throw new IgniteDataIntegrityViolationException("Snapshot corrupted, marker page crc is incorrect [partId=" + this.partId() + ", savedCrc=" + savedCrc + ", calculatedCrc=" + calcCrc + ", offset=" + startPos + ", pageSize=" + this.pageSize + "]");
                }
                if (markerPageIO.markerType(buf) == 1) {
                    this.recordSerializerVersion = markerPageIO.walRecordSerializerVersion(buf);
                    this.walRecordsCountToRead = markerPageIO.walRecordsCnt(buf);
                }
                return false;
            }
            return true;
        }
        if (buf.remaining() == this.pageSize) {
            return false;
        }
        throw new IgniteException("Corrupted page in partitionId " + this.partId + ", consistentId= " + this.consistentId + ", readByte=" + buf.position() + ", pageSize=" + this.pageSize + ", content=" + U.toHexString((ByteBuffer)buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WALRecord readNextRecord() {
        if (this.recordSerializerVersion == null || this.expander == null) {
            return null;
        }
        try {
            WALRecord rec;
            assert (this.fileInput != null);
            AtomicInteger atomicInteger = this.pos;
            synchronized (atomicInteger) {
                FileWALPointer startPtr = new FileWALPointer(0L, this.pos.get(), 0);
                rec = this.recordSerializer().readRecord((FileInput)this.fileInput, (WALPointer)startPtr);
                this.pos.addAndGet(rec.size());
            }
            this.walRecordsRead.incrementAndGet();
            return rec;
        }
        catch (EOFException e) {
            if (this.walRecordsCountToRead != this.walRecordsRead.get()) {
                throw new IgniteException("WAL records count from marker page and actual records count are different, partition is possibly corrupted [walRecordsCountFromMarker=" + this.walRecordsCountToRead + ", actualWalRecordsCount=" + this.walRecordsRead.get() + "]");
            }
            return null;
        }
        catch (Exception e) {
            throw new IgniteException("Error occured when reading WAL from snapshot file [partId=" + this.partId + ", offset=" + this.pos.get() + ", recordSerializerVersion=" + this.recordSerializerVersion + "]", (Throwable)e);
        }
    }

    public void close() throws IgniteCheckedException {
        try {
            if (this.expander != null) {
                this.expander.close();
            }
            this.channel.close();
        }
        catch (IOException e) {
            throw new IgniteCheckedException((Throwable)e);
        }
    }

    public String toString() {
        return S.toString(FileSnapshotInputStream.class, (Object)this);
    }

    @Nullable
    public static SnapshotInputStream of(@Nullable SnapshotPath file, int partId, int pageSize, String consistentId, boolean optimizedCompressedEncryption) {
        SnapshotReadableByteChannel channel = SnapshotUtils.channel((SnapshotPath)file, null, (boolean)optimizedCompressedEncryption).channel;
        if (channel == null) {
            return null;
        }
        return new FileSnapshotInputStream(channel, partId, pageSize, consistentId, false, null);
    }

    @Nullable
    public static SnapshotInputStream of(@Nullable File file, int partId, int pageSize, String consistentId, boolean optimizedCompressedEncryption) {
        return FileSnapshotInputStream.of((SnapshotPath)new FsSnapshotPath(file), partId, pageSize, consistentId, optimizedCompressedEncryption);
    }

    private RecordSerializer recordSerializer() {
        if (this.recordSerializer == null) {
            assert (this.recordSerializerFactory != null);
            try {
                this.recordSerializer = this.recordSerializerFactory.createSerializer(this.recordSerializerVersion.intValue());
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
        return this.recordSerializer;
    }

    protected boolean terminationPageReached() {
        return this.recordSerializerVersion != null;
    }

    private class InputStreamFileIO
    extends AbstractFileIO {
        private final ReadableByteChannel channel;

        public InputStreamFileIO(ReadableByteChannel channel) {
            this.channel = channel;
        }

        public long position() {
            return FileSnapshotInputStream.this.pos.get();
        }

        public void position(long newPosition) {
            throw new UnsupportedOperationException();
        }

        public int read(ByteBuffer destBuf) throws IOException {
            return this.channel.read(destBuf);
        }

        public int read(ByteBuffer destBuf, long position) {
            throw new UnsupportedOperationException();
        }

        public int read(byte[] buf, int off, int len) {
            throw new UnsupportedOperationException();
        }

        public int write(ByteBuffer srcBuf) {
            throw new UnsupportedOperationException();
        }

        public int write(ByteBuffer srcBuf, long position) {
            throw new UnsupportedOperationException();
        }

        public int write(byte[] buf, int off, int len) {
            throw new UnsupportedOperationException();
        }

        public MappedByteBuffer map(int sizeBytes) {
            throw new UnsupportedOperationException();
        }

        public void force() {
            throw new UnsupportedOperationException();
        }

        public void force(boolean withMetadata) {
            throw new UnsupportedOperationException();
        }

        public long size() throws IOException {
            throw new IOException("Can't calculate size in this implementation.", new UnsupportedOperationException());
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            throw new UnsupportedOperationException();
        }

        public int getFileSystemBlockSize() {
            throw new UnsupportedOperationException();
        }

        public int punchHole(long position, int len) {
            throw new UnsupportedOperationException();
        }

        public long getSparseSize() {
            throw new UnsupportedOperationException();
        }
    }
}

