/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;

@GridInternal
public class VisorReplicationResumeTask
extends VisorOneNodeTask<Void, VisorReplicationInfo> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<Void, VisorReplicationInfo> job(Void arg) {
        return new VisorReplicationResumeJob(arg, this.debug);
    }

    private static class VisorReplicationResumeJob
    extends VisorJob<Void, VisorReplicationInfo> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private IgniteFuture<Void> opFut;
        private long sesId;

        VisorReplicationResumeJob(Void arg, boolean debug) {
            super((Object)arg, debug);
        }

        protected VisorReplicationInfo run(Void arg) throws IgniteException {
            if (this.opFut == null) {
                ReplicationSessionDescriptor state;
                if (!(this.ignite.context().txDr() instanceof TransactionalDr)) {
                    throw new IgniteException("Transactional data center replication is not configured.");
                }
                TransactionalDr txDr = (TransactionalDr)this.ignite.context().txDr();
                if (txDr instanceof TransactionalDrProcessorImpl && (state = ((TransactionalDrProcessorImpl)txDr).localState()) != null) {
                    this.sesId = state.sessionId();
                }
                try {
                    this.opFut = txDr.resume();
                    if (!this.opFut.isDone()) {
                        this.jobCtx.holdcc();
                        this.opFut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                            public void apply(IgniteFuture f) {
                                jobCtx.callcc();
                            }
                        });
                        return null;
                    }
                    this.opFut.get();
                }
                catch (Exception cause) {
                    throw new IgniteException("Failed to resume the replication session.", (Throwable)cause);
                }
            }
            this.opFut.get();
            return new VisorReplicationInfo.Builder().withSessionId(this.sesId).build();
        }

        public String toString() {
            return S.toString(VisorReplicationResumeJob.class, (Object)((Object)this));
        }
    }
}

