/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr.recovery;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.DataEntry;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.IterationReason;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableConsumer;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRFuture;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRLocalFolderRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRLocalRecoveryFuture;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRRecoveryContext;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxConvergenceMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateRequest;
import org.gridgain.grid.internal.processors.cache.database.recovery.TxStateResponse;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;

public class PITRReplicationRecoveryContext
extends PITRLocalFolderRecoveryContext {
    private final ConsistentCut lastAppliedCut;
    private final Set<Object> aliveNodes;

    public PITRReplicationRecoveryContext(GridKernalContext ctx, Object locNodeConstId, Set<Object> aliveNodes, AffinityTopologyVersion topVer, long time, ConsistentCut lastAppliedCut) {
        super(ctx.log(PITRReplicationRecoveryContext.class), -1L, null, time, ctx, ctx.state().clusterState().baselineTopology(), null, locNodeConstId, topVer);
        this.aliveNodes = aliveNodes;
        this.lastAppliedCut = lastAppliedCut;
        this.recoveryPtr = lastAppliedCut.fuzzyBorderStartPtr();
    }

    @Override
    public GridMessageListener init() throws IgniteCheckedException {
        ClusterNode crd = SnapshotUtils.getSnapshotCrd(this.topVer, this.ig.cache().context());
        this.scanFut = new PITRLocalRecoveryFuture(this.time, -1L, this.snpBlt, crd.isLocal(), crd.consistentId(), this.locNodeConstId, this.aliveNodes, this.sender(), this.log, this.rd);
        if (this.rd != null) {
            this.appendDebugInfo(this.rd);
        }
        return new GridMessageListener(){

            public void onMessage(UUID nodeId, Object msg, byte plc) {
                if (msg instanceof TxStateRequest) {
                    PITRReplicationRecoveryContext.this.scanFut.processRequest(PITRReplicationRecoveryContext.this.mapToConstId(nodeId), (TxStateRequest)msg);
                } else if (msg instanceof TxStateResponse) {
                    PITRReplicationRecoveryContext.this.scanFut.processResponse(PITRReplicationRecoveryContext.this.mapToConstId(nodeId), (TxStateResponse)msg);
                } else if (msg instanceof TxConvergenceMessage) {
                    PITRReplicationRecoveryContext.this.scanFut.processConvergenceMessage(PITRReplicationRecoveryContext.this.mapToConstId(nodeId), (TxConvergenceMessage)msg);
                }
            }
        };
    }

    @Override
    public IgniteInternalFuture<Set<Object>> scanForLeftNodes() {
        final GridFutureAdapter finishFut = new GridFutureAdapter();
        final FileWALPointer ptr = this.resolveRecoveryPtr();
        if (ptr == null) {
            return new GridFinishedFuture();
        }
        this.exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PITRReplicationRecoveryContext.this.log.isInfoEnabled()) {
                        PITRReplicationRecoveryContext.this.log.info("Scan wal log procedure initiated localNodeConstId=" + PITRReplicationRecoveryContext.this.locNodeConstId + ", initWalPointer=" + ptr);
                    }
                    FileWALPointer appliedCutPtr = (FileWALPointer)PITRReplicationRecoveryContext.this.lastAppliedCut.cutPtr();
                    IgniteBiPredicate & Serializable filter = (IgniteBiPredicate & Serializable)(ptr, ver) -> ((FileWALPointer)ptr).compareTo(appliedCutPtr) >= 0 || PITRReplicationRecoveryContext.this.lastAppliedCut.skipTxs().contains(ver);
                    PITRReplicationRecoveryContext.this.withWalIterator((IgniteThrowableConsumer<WALIterator>)(IgniteThrowableConsumer & Serializable)it -> finishFut.onDone(PITRReplicationRecoveryContext.this.scanFut.scan((WALIterator)it, (IgniteBiPredicate<WALPointer, GridCacheVersion>)filter)), (WALPointer)ptr);
                }
                catch (Throwable e) {
                    PITRReplicationRecoveryContext.this.log.error("Fail scan wal log for recovery localNodeConstId=" + PITRReplicationRecoveryContext.this.locNodeConstId, e);
                    finishFut.onDone(e);
                }
            }
        });
        return finishFut;
    }

    private GridCacheSnapshotManager snapshotManager() {
        return (GridCacheSnapshotManager)this.ig.cache().context().snapshot();
    }

    @Override
    protected void withWalIterator(IgniteThrowableConsumer<WALIterator> c, WALPointer initWalPnt) throws IgniteCheckedException {
        try (WALIterator it = this.snapshotManager().walIterator((FileWALPointer)initWalPnt, null, this.lastAppliedCut.spawnId(), IterationReason.PITR);){
            c.accept((Object)it);
        }
    }

    @Override
    protected IgniteBiPredicate<WALRecord, DataEntry> getEntryPredicate(PITRFuture.Result res, PITRRecoveryContext.MultiWalApplyPredicate multiWalApplyPred, AtomicLong appliedEntries) {
        FileWALPointer appliedCutPtr = (FileWALPointer)this.lastAppliedCut.cutPtr();
        IgniteBiPredicate<WALRecord, DataEntry> superPred = super.getEntryPredicate(res, multiWalApplyPred, appliedEntries);
        return (IgniteBiPredicate & Serializable)(rec, e) -> {
            FileWALPointer ptr = (FileWALPointer)rec.position();
            boolean apply = ptr.compareTo(appliedCutPtr) >= 0 || ptr.compareTo(appliedCutPtr) < 0 && (e == null || e.nearXidVersion() == null || this.lastAppliedCut.skipTxs().contains(e.nearXidVersion()));
            return apply && superPred.apply(rec, e);
        };
    }

    protected FileWALPointer resolveRecoveryPtr() {
        return (FileWALPointer)this.recoveryPtr;
    }
}

