/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteInterruptedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.RolloverType;
import org.apache.ignite.internal.pagemem.wal.record.TimeStampedConsistentCutRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.CacheType;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.ExchangeDiscoveryEvents;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.ExchangeType;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.PartitionsExchangeAware;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageLifecycleListener;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadOnlyMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.ReadWriteMetastorage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteCacheSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotDiscoveryMessage;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistory;
import org.apache.ignite.internal.processors.cluster.BaselineTopologyHistoryItem;
import org.apache.ignite.internal.processors.cluster.ChangeGlobalStateMessage;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.processors.txdr.TransactionalDrProcessor;
import org.apache.ignite.internal.util.GridCircularBuffer;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.logger.EchoingLogger;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.thread.IgniteThread;
import org.gridgain.grid.configuration.GridGainConfiguration;
import org.gridgain.grid.internal.GridGainFeatures;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.messages.FinishSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateTransferParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCut;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutAppliedGloballyDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutGC;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutScheduler;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutWatcher;
import org.gridgain.grid.internal.processors.cache.database.txdr.DebugMode;
import org.gridgain.grid.internal.processors.cache.database.txdr.FileConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.GlobalReplicationStatusTask;
import org.gridgain.grid.internal.processors.cache.database.txdr.NodeLastEvents;
import org.gridgain.grid.internal.processors.cache.database.txdr.ResetTxDrNodeStateTask;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsTracker;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.txdr.WalSender;
import org.gridgain.grid.internal.txdr.BootstrapMasterParameters;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.GridGainTxDrConfiguration;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.txdr.TransactionalDrGlobalStatus;
import org.gridgain.grid.internal.txdr.TransactionalDrMXBean;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotPath;
import org.jetbrains.annotations.Nullable;

public class TransactionalDrProcessorImpl
extends GridProcessorAdapter
implements TransactionalDrProcessor,
TransactionalDr,
PartitionsExchangeAware,
MetastorageLifecycleListener {
    public static final IgnitePredicate<CacheGroupDescriptor> PUBLIC_PERSISTENT_CACHE_GROUP_FILTER = (IgnitePredicate & Serializable)desc -> !CU.isSystemCache((String)desc.cacheOrGroupName()) && desc.groupId() != CU.cacheId((String)"default-volatile-ds-group") && desc.persistenceEnabled() && desc.config().getCacheMode() != CacheMode.LOCAL;
    public static final IgnitePredicate<DynamicCacheDescriptor> PUBLIC_PERSISTENT_CACHE_FILTER = (IgnitePredicate & Serializable)desc -> PUBLIC_PERSISTENT_CACHE_GROUP_FILTER.apply((Object)desc.groupDescriptor());
    public static final int MAX_ESSENTIAL_MESSAGES = 16;
    private static final boolean TX_DR_DEBUG_OUTPUT_ENABLED = Boolean.getBoolean("TX_DR_DEBUG_OUTPUT_ENABLED");
    private static final String TX_DR_REPLICA_DEBUG_MODE = "TX_DR_REPLICA_DEBUG_MODE";
    static final String METASTORE_REPLICATION_STATE_KEY = "metastoreReplicationStateKey";
    private static final String METASTORE_SPAWN_ID_KEY = "metastoreSpawnIdKey";
    private static final String METASTORE_REPLICATION_BINARY_META_IDS_KEY = "metastoreReplicationBinaryMetaIdsKey";
    private static final String METASTORE_REPLICATION_BINARY_META_KEY_PREFIX = "metastoreReplicationBinaryMetaKey";
    private static final String CONSISTENT_CUT_TRANSFER_DIR = "cuts";
    private static final String WAL_TRANSFER_DIR = "wal";
    private static final DebugMode DFLT_DEBUG_MODE = DebugMode.NONE;
    private static final String MBEAN_NAME = "TxDr";
    private final GridGainConfiguration ggCfg;
    private final Object mux = new Object();
    private ReplicationSessionDescriptor state;
    private final GridCircularBuffer<String> essentialMessages = new GridCircularBuffer(16);
    private final IgniteLogger essentialLog = new EchoingLogger(this.log, s -> {
        try {
            this.essentialMessages.add(s);
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedException(e);
        }
    });
    @GridToStringExclude
    private ReadWriteMetastorage metastorage;
    private volatile WalSender walSnd;
    private volatile ConsistentCutWatcher cutsWatcher;
    private volatile ConsistentCutStore cutsStore;
    private volatile long latestBootstrapSesId;
    private volatile ConsistentCutGC gc;
    private volatile File walDir;
    private volatile long spawnId;
    private final AtomicReference<StateChangeFuture> stateChangeFut = new AtomicReference();
    private final AtomicReference<GridFutureAdapter<Long>> switchPrepareFut = new AtomicReference();
    private final DiscoveryEventListener evtLsnr;
    private final GridCacheSnapshotManager snapMgr;
    private volatile ConsistentCutScheduler ccScheduler;
    private volatile TopologyEventsTracker topTracker;
    private ConcurrentHashMap<Long, WALPointer> sesPtrs = new ConcurrentHashMap();
    private final HashMap<Integer, BinaryMetadata> binaryMetadata = new HashMap();
    private final AtomicReference<GridFutureAdapter<Long>> initMasterBootstrapFut = new AtomicReference();
    private volatile DebugMode debugMode = DebugMode.NONE;
    private final AtomicReference<AffinityTopologyVersion> lastSpecialRebalanceInitVer = new AtomicReference();
    private volatile ObjectName txDrMBeanName;
    private AtomicReference<FakeCutMark> fakeCutMark = new AtomicReference<FakeCutMark>(new FakeCutMark(-1L, AffinityTopologyVersion.NONE, -1L, null));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionalDrProcessorImpl(GridKernalContext ctx, GridGainConfiguration ggCfg) {
        super(ctx);
        this.ggCfg = ggCfg;
        Object object = this.mux;
        synchronized (object) {
            this.state = new ReplicationSessionDescriptor(ClusterRole.DISABLED, ReplicationState.STOPPED);
        }
        this.evtLsnr = (evt, discoCache) -> {
            assert (evt.type() == 11 || evt.type() == 12) : evt;
            if (this.localState().role() == ClusterRole.MASTER && this.ccScheduler == null && ctx.localNodeId().equals(this.getReplicationCoordinatorNodeId()) && ctx.state().publicApiActiveState(false)) {
                this.startConsistentCutScheduler();
            }
        };
        this.snapMgr = (GridCacheSnapshotManager)ctx.cache().context().snapshot();
        ctx.cache().context().tm().trackPendingTxs();
        String debugModeStr = System.getProperty(TX_DR_REPLICA_DEBUG_MODE);
        if (debugModeStr != null) {
            try {
                this.debugMode = DebugMode.valueOf(debugModeStr.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                U.warn((IgniteLogger)this.log, (Object)("Invalid value of TX_DR_REPLICA_DEBUG_MODE: " + debugModeStr + ", allowed: " + Arrays.toString((Object[])DebugMode.values())));
            }
        }
    }

    public void onMarkCheckPointBegin(long snapshotId, WALPointer ptr, SnapshotOperation snapshotOperation) {
        if (!(snapshotOperation instanceof GridSnapshotOperationEx)) {
            return;
        }
        GridSnapshotOperationEx snOpEx = (GridSnapshotOperationEx)snapshotOperation;
        boolean bootstrapMaster = GridSnapshotOperationAttrs.getReplicationBootstrapMasterFlag((GridSnapshotOperationEx)snOpEx);
        boolean saveFakeCut = bootstrapMaster || GridSnapshotOperationAttrs.getConsistentCutTestingSnapshotCreateFlag((GridSnapshotOperationEx)snOpEx);
        TopologyEventsSnapshot evtLogSnp = TopologyEventsSnapshot.EMPTY_SNAPSHOT;
        try {
            if (bootstrapMaster) {
                WALPointer oldPtr = this.sesPtrs.putIfAbsent(snapshotId, ptr);
                if (oldPtr != null) {
                    throw new IgniteCheckedException("Master already was bootstrapped with current snapshot ID [snapshotId=" + snapshotId + ", walPtr=" + oldPtr + ']');
                }
                AffinityTopologyVersion topVer = this.snapMgr.snapshotFuture().snapshotInfo().topologyVersion();
                evtLogSnp = this.initTopologyTracker(snapshotId, topVer);
                this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> state.sessionId(snapshotId));
            }
            if (saveFakeCut) {
                ConsistentCut fakeCut = new ConsistentCut(snapshotId, this.spawnId(), ptr, ptr, Collections.emptySet(), Collections.emptyList(), false, evtLogSnp.nodeLastEvents(), null);
                this.consistentCutStore().save(fakeCut);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Consistent cut created (bootstrapping): " + fakeCut);
                }
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to create fake cut on master bootstrap", (Throwable)e);
        }
    }

    public void onPartitionsFullMessagePrepared(@Nullable GridDhtPartitionExchangeId exchId, GridDhtPartitionsFullMessage fullMsg) {
        TopologyEventsTracker topTracker0 = this.topTracker;
        if (topTracker0 != null) {
            topTracker0.onPartitionsFullMessagePrepared(exchId, fullMsg);
        }
    }

    public void onChangeGlobalStateMessagePrepared(ChangeGlobalStateMessage msg) {
        ConsistentCutWatcher watcher0;
        ReplicationSessionDescriptor locState0 = this.localState();
        if (locState0.role() == ClusterRole.REPLICA && locState0.state() == ReplicationState.RUNNING && (watcher0 = this.consistentCutWatcher()) != null) {
            msg.timestamp(watcher0.processedBltCutId() - 1L);
        }
    }

    public boolean shouldIgnoreAssignPartitionStates(GridDhtPartitionsExchangeFuture fut) {
        ReplicationSessionDescriptor locState0 = this.localState();
        if (locState0.role() != ClusterRole.REPLICA || locState0.state() != ReplicationState.RUNNING) {
            return false;
        }
        return !this.isTriggeredBySpecialRebalanceEvent(fut);
    }

    public boolean shouldScheduleRebalance(GridDhtPartitionsExchangeFuture fut) {
        return fut.initialVersion().equals((Object)this.lastSpecialRebalanceInitVer.get());
    }

    public boolean disableSnasphotOnBaselineChange() {
        ReplicationSessionDescriptor locState0 = this.localState();
        return locState0.role() == ClusterRole.REPLICA;
    }

    public boolean shouldApplyUpdateCounterOnRebalance() {
        ReplicationSessionDescriptor state0 = this.localState();
        return state0.role() == ClusterRole.REPLICA && state0.state() == ReplicationState.RUNNING;
    }

    public boolean shouldSkipCounterConsistencyCheckOnPME() {
        ReplicationSessionDescriptor state0 = this.localState();
        return state0.role() == ClusterRole.REPLICA;
    }

    public void start() throws IgniteCheckedException {
        this.ctx.internalSubscriptionProcessor().registerMetastorageListener((MetastorageLifecycleListener)this);
        this.ctx.cache().context().exchange().registerExchangeAwareComponent((PartitionsExchangeAware)this);
        this.ctx.event().addDiscoveryEventListener(this.evtLsnr, 11, new int[]{12});
        IgniteCacheObjectProcessor cacheObjProc = this.ctx.cacheObjects();
        if (cacheObjProc instanceof CacheObjectBinaryProcessorImpl) {
            ((CacheObjectBinaryProcessorImpl)cacheObjProc).addBinaryMetadataUpdateListener(metadata -> {
                ReplicationSessionDescriptor locDesc0 = this.localState();
                if (locDesc0.role() != ClusterRole.MASTER || locDesc0.state() != ReplicationState.RUNNING || this.nodeShouldSkipActiveActions()) {
                    return;
                }
                this.ctx.cache().context().database().checkpointReadLock();
                try {
                    HashMap<Integer, BinaryMetadata> hashMap = this.binaryMetadata;
                    synchronized (hashMap) {
                        BinaryMetadata newMetadata = this.binaryMetadata.compute(metadata.typeId(), (k, v) -> BinaryUtils.mergeMetadata((BinaryMetadata)v, (BinaryMetadata)metadata));
                        if (this.metastorage != null) {
                            this.storeBinaryMetadata(Collections.singletonList(newMetadata));
                        }
                    }
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
                finally {
                    this.ctx.cache().context().database().checkpointReadUnlock();
                }
            });
        }
        this.addDiscoveryCustomEventListeners();
    }

    private void addDiscoveryCustomEventListeners() {
        AtomicReference latestOpIdAndTs = new AtomicReference();
        this.ctx.discovery().setCustomEventListener(StartSnapshotOperationAckDiscoveryMessage.class, (topVer, snd, msg) -> {
            if (msg.snapshotOperation().type() != SnapshotOperationType.REPLICATION_STATE_CHANGE) {
                return;
            }
            Integer role = GridSnapshotOperationAttrs.getReplicationClusterRole((GridSnapshotOperationEx)msg.snapshotOperation());
            Integer state = GridSnapshotOperationAttrs.getReplicationState((GridSnapshotOperationEx)msg.snapshotOperation());
            if (Objects.equals(role, ClusterRole.REPLICA.ordinal())) {
                if (Objects.equals(state, ReplicationState.STOPPED.ordinal()) || Objects.equals(state, ReplicationState.SWITCH.ordinal())) {
                    latestOpIdAndTs.set(new T2((Object)msg.operationId(), (Object)msg.snapshotOperation().snapshotId()));
                }
            } else if (Objects.equals(role, ClusterRole.MASTER.ordinal()) && Objects.equals(state, ReplicationState.SWITCH.ordinal())) {
                this.fakeCutMark.set(new FakeCutMark(this.localState().sessionId(), topVer, msg.snapshotOperation().snapshotId(), msg.snapshotOperation().type()));
            }
        });
        this.ctx.discovery().setCustomEventListener(FinishSnapshotOperationAckDiscoveryMessage.class, (topVer, snd, msg) -> {
            T2 opIdAndTs = (T2)latestOpIdAndTs.get();
            if (opIdAndTs != null && Objects.equals(opIdAndTs.get1(), msg.operationId())) {
                this.ctx.discovery().setGridStartTime(((Long)opIdAndTs.get2()).longValue());
                this.ctx.cache().context().versions().gridStartTime(((Long)opIdAndTs.get2()).longValue());
                latestOpIdAndTs.set(null);
            }
        });
        this.ctx.discovery().setCustomEventListener(ChangeGlobalStateMessage.class, (topVer, snd, msg) -> this.fakeCutMark.set(new FakeCutMark(this.localState().sessionId(), topVer, msg.timestamp(), null)));
        this.ctx.discovery().setCustomEventListener(ConsistentCutAppliedGloballyDiscoveryMessage.class, (topVer, snd, msg) -> this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> {
            if (state.lastGloballyAppliedCutId() < msg.cutId()) {
                state.lastGloballyAppliedCutId(msg.cutId());
            }
        }));
    }

    public boolean skipSavingCut(AffinityTopologyVersion topVer, long cutId) {
        FakeCutMark cancelCutMark0 = this.fakeCutMark.get();
        return cancelCutMark0.sessionId() == this.localState().sessionId() && (SnapshotOperationType.REPLICATION_STATE_CHANGE == cancelCutMark0.operation() ? cutId >= cancelCutMark0.consistentCutId() : topVer.compareTo(cancelCutMark0.topologyVersion()) <= 0 && cutId <= cancelCutMark0.consistentCutId());
    }

    private void prepareReplicationSessionAfterRestart() throws IgniteCheckedException {
        ReplicationSessionDescriptor state0 = this.localState();
        if (state0.role() == ClusterRole.DISABLED || this.nodeShouldSkipActiveActions()) {
            return;
        }
        assert (this.metastorage != null) : "Metastorage must be initialized first.";
        this.checkNoWalDisabledCacheGroups();
        this.ctx.cache().context().walState().prohibitWALDisabling(true);
        this.initAndGetConsistentCutStore();
        if (state0.role() == ClusterRole.MASTER) {
            if (this.topTracker == null) {
                this.topTracker = TopologyEventsTracker.fromMetastorage(this.ctx, this, (ReadOnlyMetastorage)this.metastorage, true);
            }
            this.initMasterBootstrapFut().onDone((Object)state0.sessionId());
            this.topTracker.start();
            this.startWalShippingFromWalSegment(state0.lastSuccessfullySentWalIndex() + 1L);
            this.storeBinaryMetadata(this.binaryMetadata.values());
            this.startConsistentCutScheduler();
        } else {
            this.nodeIsLaggingBehind(true);
            this.cutsWatcher = new ConsistentCutWatcher(this, this.ctx, GridGainTxDrConfiguration.extractTxDrConfiguration((GridGainConfiguration)this.ggCfg).getMaxCutDeliveryWaitTime());
            this.cutsWatcher.prepareStart(state0.state() != ReplicationState.RUNNING);
        }
    }

    private void completeReplicationSessionAfterRestart() throws IgniteCheckedException {
        ReplicationSessionDescriptor state0 = this.localState();
        if (state0.role() == ClusterRole.DISABLED || this.nodeShouldSkipActiveActions()) {
            return;
        }
        if (state0.role() == ClusterRole.REPLICA) {
            this.cutsWatcher.completeStart();
        }
    }

    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        this.onKernalStart(true);
    }

    public void onDeActivate(GridKernalContext kctx) {
        this.onKernalStop(true);
    }

    public void onKernalStart(boolean active) throws IgniteCheckedException {
        if (active) {
            this.completeReplicationSessionAfterRestart();
        }
        this.registerTxDrMXBean();
    }

    public void onKernalStop(boolean cancel) {
        super.onKernalStop(cancel);
        this.stopWalSender();
        this.stopConsistentCutScheduler();
        this.stopConsistentCutWatcher();
        this.stopTopologyTracker();
        this.unregisterTxDrMXBean();
    }

    private void registerTxDrMXBean() {
        if (U.IGNITE_MBEANS_DISABLED || this.txDrMBeanName != null) {
            return;
        }
        TransactionalDrMXBeanImpl txDrMXBean = new TransactionalDrMXBeanImpl(this);
        try {
            IgniteConfiguration cfg = this.ctx.config();
            this.txDrMBeanName = U.registerMBean((MBeanServer)cfg.getMBeanServer(), (String)cfg.getIgniteInstanceName(), (String)MBEAN_NAME, (String)txDrMXBean.getClass().getSimpleName(), (Object)txDrMXBean, TransactionalDrMXBean.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered TxDr MBean: " + this.txDrMBeanName);
            }
        }
        catch (JMException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to register TxDr MBean", (Throwable)e);
        }
    }

    private void unregisterTxDrMXBean() {
        ObjectName mBeanName = this.txDrMBeanName;
        if (mBeanName == null) {
            return;
        }
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            this.ctx.config().getMBeanServer().unregisterMBean(mBeanName);
            this.txDrMBeanName = null;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered TxDr MBean: " + mBeanName);
            }
        }
        catch (JMException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to unregister TxDr MBean: " + mBeanName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDoneBeforeTopologyUnlock(GridDhtPartitionsExchangeFuture fut) {
        if (fut.exchangeType() == ExchangeType.ALL && fut.firstEvent().type() == 18) {
            ReplicationSessionDescriptor state0;
            ChangeGlobalStateMessage changeBaselineMsg;
            GridSnapshotOperationEx op;
            StartSnapshotOperationAckDiscoveryMessage snpMsg;
            DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)fut.firstEvent()).customMessage();
            ClusterNode node = this.ctx.discovery().node(this.ctx.localNodeId());
            boolean clientOrDaemon = node.isClient() || node.isDaemon();
            boolean notInBaseline = SnapshotUtils.nodeIsNotInBaseline(node, this.ctx.cache().context(), fut.initialVersion());
            if (!clientOrDaemon) {
                if (this.isTriggeredBySpecialRebalanceEvent(fut)) {
                    this.lastSpecialRebalanceInitVer.set(fut.initialVersion());
                }
                if (msg instanceof StartSnapshotOperationAckDiscoveryMessage) {
                    snpMsg = (StartSnapshotOperationAckDiscoveryMessage)msg;
                    op = snpMsg.snapshotOperation();
                    if (op.type() == SnapshotOperationType.REPLICATION_STATE_CHANGE && GridSnapshotOperationAttrs.getReplicationState((GridSnapshotOperationEx)op) == ReplicationState.SWITCH.ordinal()) {
                        this.changeClusterReadOnlyMode(true);
                        this.printPartitionStates(false);
                        try {
                            if (this.ccScheduler != null) {
                                this.ccScheduler.shutdownNow();
                            }
                            ReplicationSessionDescriptor state02 = this.localState();
                            assert (state02.role() == ClusterRole.MASTER) : "Invalid replication cluster role: " + state02.role();
                            assert (state02.state() == ReplicationState.RUNNING) : "Invalid replication state: " + state02.state();
                            if (state02.lastCreatedCutId() >= op.snapshotId()) {
                                throw new IgniteCheckedException("Failed to perform switch operation, consistent cut with larger id (" + state02.lastCreatedCutId() + ") was created concurrently. Please retry switch operation.");
                            }
                            if (!notInBaseline) {
                                this.ctx.cache().context().database().checkpointReadLock();
                                try {
                                    TimeStampedConsistentCutRecord ccRec = new TimeStampedConsistentCutRecord();
                                    WALPointer ptr = this.ctx.cache().context().wal().log((WALRecord)ccRec, RolloverType.CURRENT_SEGMENT);
                                    this.sesPtrs.put(op.snapshotId(), ptr);
                                }
                                finally {
                                    this.ctx.cache().context().database().checkpointReadUnlock();
                                }
                            }
                            this.switchPrepareFut().onDone((Object)op.snapshotId());
                        }
                        catch (Throwable e) {
                            this.switchPrepareFut().onDone(e);
                        }
                    }
                } else if (msg instanceof ConsistentCutAppliedGloballyDiscoveryMessage) {
                    ConsistentCutAppliedGloballyDiscoveryMessage msg0 = (ConsistentCutAppliedGloballyDiscoveryMessage)msg;
                    this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> state.lastSuccessfullyAppliedCutId(Math.max(state.lastSuccessfullyAppliedCutId(), msg0.cutId())));
                }
            }
            if (msg instanceof StartSnapshotOperationAckDiscoveryMessage && (op = (snpMsg = (StartSnapshotOperationAckDiscoveryMessage)msg).snapshotOperation()).type() == SnapshotOperationType.CREATE) {
                if (!Boolean.TRUE.equals(GridSnapshotOperationAttrs.getReplicationBootstrapMasterFlag((GridSnapshotOperationEx)op))) {
                    return;
                }
                try {
                    assert (this.localState().role() == ClusterRole.DISABLED);
                    if (!clientOrDaemon) {
                        if (notInBaseline) {
                            this.setLocalReplicationState(new ReplicationSessionDescriptor().role(ClusterRole.MASTER).state(ReplicationState.RUNNING).sessionId(op.snapshotId()));
                        } else {
                            this.checkNoWalDisabledCacheGroups();
                            this.ctx.cache().context().walState().prohibitWALDisabling(true);
                            this.setLocalReplicationState(new ReplicationSessionDescriptor().role(ClusterRole.MASTER).state(ReplicationState.RUNNING).sessionId(op.snapshotId()).lastCreatedCutId(op.snapshotId()));
                            this.initAndGetConsistentCutStore();
                            this.printPartitionStates(op.cacheGroupIds(), false);
                            this.initMasterBootstrapFut().onDone((Object)op.snapshotId());
                            this.startWalShippingFromSessionId(op.snapshotId());
                            this.startConsistentCutScheduler();
                        }
                    }
                }
                catch (Exception e) {
                    U.error((IgniteLogger)this.log, (Object)"Bootstrapping master cluster failed.", (Throwable)e);
                    this.stopConsistentCutScheduler();
                    this.stopWalSender();
                    this.snapMgr.cancelSnapshotOperation(snpMsg.operationId(), false, "Bootstrapping master cluster failed [locNode=" + this.ctx.localNodeId() + ", err=" + e);
                }
            }
            if ((changeBaselineMsg = this.baselineChangeMessage(fut)) != null && changeBaselineMsg.forceChangeBaselineTopology()) {
                this.onBaselineTopologyChanged(fut);
            }
            if (fut.activateCluster() && (state0 = this.localState()) != null && state0.role() == ClusterRole.REPLICA) {
                this.changeClusterReadOnlyMode(true);
            }
        }
    }

    private void onBaselineTopologyChanged(GridDhtPartitionsExchangeFuture fut) {
        ReplicationSessionDescriptor state = this.localState();
        ChangeGlobalStateMessage changeStateMsg = this.baselineChangeMessage(fut);
        if (changeStateMsg != null) {
            BaselineTopology baselineTop;
            if (state.role() == ClusterRole.MASTER && state.state() == ReplicationState.RUNNING) {
                WALPointer ptr;
                baselineTop = changeStateMsg.baselineTopology();
                this.ctx.cache().context().database().checkpointReadLock();
                try {
                    ptr = this.ctx.cache().context().wal().log((WALRecord)new TimeStampedConsistentCutRecord(), RolloverType.NEXT_SEGMENT);
                    if (this.topTracker == null) {
                        this.initTopologyTracker(this.localState().sessionId(), this.ctx.cache().context().discovery().topologyVersionEx());
                    }
                    HashSet<BinaryMetadata> meta = new HashSet<BinaryMetadata>(this.getAndClearBinaryMetadata());
                    long bltCutId = changeStateMsg.timestamp();
                    BaselineTopologyHistory bltHist = this.ctx.state().baselineHistory();
                    BaselineTopologyHistoryItem bltHstItem = (BaselineTopologyHistoryItem)bltHist.history().get(baselineTop.id() - 1);
                    Set aliveIds = this.ctx.discovery().discoCache().aliveServerNodes().stream().map(ClusterNode::consistentId).collect(Collectors.toSet());
                    Map<Object, NodeLastEvents> evts = this.topTracker.snapshotForFakeCut(bltCutId, fut.topologyVersion()).nodeLastEvents();
                    ConsistentCut cut = new ConsistentCut(bltCutId, this.spawnId(), ptr, ptr, Collections.emptySet(), meta, false, evts, null);
                    this.consistentCutStore().save(cut);
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Consistent cut created (preparing to change baseline): " + cut);
                    }
                    for (BaselineNode bltNode : baselineTop.currentBaseline()) {
                        Object consistentId = bltNode.consistentId();
                        if (bltHstItem.containsNode(consistentId)) continue;
                        this.topTracker.baselineNodeJoin(consistentId, aliveIds.contains(consistentId), fut.topologyVersion());
                    }
                    for (Object constId : bltHstItem.consistentIds()) {
                        if (baselineTop.consistentIds().contains(constId)) continue;
                        this.topTracker.baselineNodeLeft(constId, fut.topologyVersion());
                    }
                    Map<Object, NodeLastEvents> evts2 = this.topTracker.snapshotForFakeCut(bltCutId + 1L, fut.topologyVersion()).nodeLastEvents();
                    ConsistentCut bltCut = new ConsistentCut(bltCutId + 1L, this.spawnId(), ptr, ptr, Collections.emptySet(), meta, false, evts2, baselineTop);
                    this.consistentCutStore().save(bltCut);
                    long sesId = this.localState().sessionId();
                    if (this.walSnd == null) {
                        this.initMasterBootstrapFut().onDone((Object)sesId);
                    }
                    this.lastCreatedConsistentCut(bltCut.id());
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Consistent cut created (baseline change): " + bltCut);
                    }
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
                finally {
                    this.ctx.cache().context().database().checkpointReadUnlock();
                }
                try {
                    if (this.walSnd == null) {
                        this.checkNoWalDisabledCacheGroups();
                        this.ctx.cache().context().walState().prohibitWALDisabling(true);
                        this.startWalShippingFromWalSegment(((FileWALPointer)ptr).index());
                        this.startConsistentCutScheduler();
                    }
                }
                catch (Exception e) {
                    U.error((IgniteLogger)this.log, (Object)"Failed to bootstrap new baseline topology node on master cluster.", (Throwable)e);
                    this.stopConsistentCutScheduler();
                    this.stopWalSender();
                    throw new IgniteException((Throwable)e);
                }
            }
            if (state.role() == ClusterRole.REPLICA) {
                baselineTop = changeStateMsg.baselineTopology();
                assert (baselineTop != null);
                BaselineTopologyHistory bltHist = this.ctx.state().baselineHistory();
                ClusterNode node = this.ctx.discovery().node(this.ctx.localNodeId());
                Object consistentId = node.consistentId();
                if (baselineTop.baselineNode(consistentId) != null && !bltHist.history().isEmpty() && !((BaselineTopologyHistoryItem)bltHist.history().get(baselineTop.id() - 1)).containsNode(consistentId) && state.state() == ReplicationState.RUNNING) {
                    try {
                        this.ctx.cache().restartProxies();
                        this.changeClusterReadOnlyMode(true);
                        long sesId = this.localState().sessionId();
                        this.localReplicaBootstrap(sesId);
                        if (SnapshotUtils.nodeIsNotInBaseline(node, this.ctx.cache().context(), null)) {
                            StateChangeFuture fut0 = new StateChangeFuture(sesId);
                            this.stateChangeFut.compareAndSet(null, fut0);
                        }
                        this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state0 -> state0.state(ReplicationState.RUNNING));
                        this.cutsWatcher.initLastAppliedCutId(changeStateMsg.timestamp());
                        this.cutsWatcher.completeStart();
                    }
                    catch (IgniteCheckedException e) {
                        throw new IgniteException((Throwable)e);
                    }
                }
            }
        }
    }

    private GridFutureAdapter<Long> switchPrepareFut() {
        GridFutureAdapter fut;
        while ((fut = this.switchPrepareFut.get()) == null) {
            fut = new GridFutureAdapter();
            if (!this.switchPrepareFut.compareAndSet(null, (GridFutureAdapter<Long>)fut)) continue;
            return fut;
        }
        return fut;
    }

    private GridFutureAdapter<Long> initMasterBootstrapFut() {
        GridFutureAdapter fut;
        while ((fut = this.initMasterBootstrapFut.get()) == null) {
            fut = new GridFutureAdapter();
            if (!this.initMasterBootstrapFut.compareAndSet(null, (GridFutureAdapter<Long>)fut)) continue;
            return fut;
        }
        return fut;
    }

    private void startWalShippingFromSessionId(long sesId) throws IgniteCheckedException {
        WALPointer sesPtr = this.sesPtrs.remove(sesId);
        assert (sesPtr != null) : "WALPointer is not found. [sessionId=" + sesId + ']';
        this.startWalShippingFromWalSegment(((FileWALPointer)sesPtr).index());
    }

    private void startWalShippingFromWalSegment(long walIdx) throws IgniteCheckedException {
        assert (this.walSnd == null) : "WalSender is already initialized. [walSnd=" + (Object)((Object)this.walSnd) + ']';
        this.walSnd = new WalSender(this.ctx.igniteInstanceName(), this.ctx.log(WalSender.class), this.ctx.cache().context().wal(), this.ctx.cluster().get().events(), this.resolveWalArchiveDirectory(), this.walDir(this.spawnId()), this.ctx.failure(), this, this.ctx.config().getDataStorageConfiguration().isWalCompactionEnabled());
        new IgniteThread((GridWorker)this.walSnd).start();
        this.walSnd.startSending(walIdx);
    }

    private File resolveWalArchiveDirectory() throws IgniteCheckedException {
        String consId = this.ctx.pdsFolderResolver().resolveFolders().folderName();
        if (this.ctx.config().getDataStorageConfiguration().getWalArchivePath() != null) {
            String cfg = this.ctx.config().getDataStorageConfiguration().getWalArchivePath();
            File workDir0 = new File(cfg);
            return workDir0.isAbsolute() ? new File(workDir0, consId) : new File(U.resolveWorkDirectory((String)this.ctx.config().getWorkDirectory(), (String)cfg, (boolean)false), consId);
        }
        File walArchDir = U.resolveWorkDirectory((String)this.ctx.config().getWorkDirectory(), (String)"db/wal/archive", (boolean)false);
        return new File(walArchDir, consId);
    }

    UUID getReplicationCoordinatorNodeId() {
        ClusterNode crdNode = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, this.ctx.cache().context());
        return crdNode == null ? null : crdNode.id();
    }

    private void startConsistentCutScheduler() {
        if (this.ctx.localNodeId().equals(this.getReplicationCoordinatorNodeId())) {
            IgniteCacheSnapshotManager snapshotMgr = this.ctx.cache().context().snapshot();
            assert (snapshotMgr instanceof GridSnapshotManager);
            assert (this.ccScheduler == null);
            this.ccScheduler = new ConsistentCutScheduler(this.ctx.igniteInstanceName(), this.log, (GridSnapshotManager)snapshotMgr, GridGainTxDrConfiguration.extractTxDrConfiguration((GridGainConfiguration)this.ggCfg).getConsistentCutInterval());
            new IgniteThread((GridWorker)this.ccScheduler).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadyForRead(ReadOnlyMetastorage metastorage) throws IgniteCheckedException {
        ReplicationSessionDescriptor storedState = (ReplicationSessionDescriptor)metastorage.read(METASTORE_REPLICATION_STATE_KEY);
        if (storedState != null) {
            Object object = this.mux;
            synchronized (object) {
                this.state = storedState;
            }
        }
        this.topTracker = TopologyEventsTracker.fromMetastorage(this.ctx, this, metastorage, false);
        Set typeIds = (Set)((Object)metastorage.read(METASTORE_REPLICATION_BINARY_META_IDS_KEY));
        if (typeIds != null) {
            HashMap<Integer, BinaryMetadata> hashMap = this.binaryMetadata;
            synchronized (hashMap) {
                for (Integer id : typeIds) {
                    BinaryMetadata meta = (BinaryMetadata)metastorage.read(METASTORE_REPLICATION_BINARY_META_KEY_PREFIX + id);
                    this.binaryMetadata.put(id, meta);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReadyForReadWrite(ReadWriteMetastorage metastorage) throws IgniteCheckedException {
        this.metastorage = metastorage;
        Object object = this.mux;
        synchronized (object) {
            this.setLocalReplicationState(this.state);
        }
        this.prepareReplicationSessionAfterRestart();
    }

    public void collectGridNodeData(DiscoveryDataBag dataBag) {
        TopologyEventsTracker topTracker0 = this.topTracker;
        if (!dataBag.commonDataCollectedFor(Integer.valueOf(GridComponent.DiscoveryDataExchangeType.TX_DR_PROC.ordinal()))) {
            dataBag.addGridCommonData(Integer.valueOf(GridComponent.DiscoveryDataExchangeType.TX_DR_PROC.ordinal()), (Serializable)new TxDrDiscoveryDataBag(this.localState(), topTracker0 != null ? topTracker0.rawSnapshot() : null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
        TxDrDiscoveryDataBag commonData = (TxDrDiscoveryDataBag)data.commonData();
        if (commonData != null) {
            Object object;
            ReplicationSessionDescriptor clusterState = commonData.state();
            TopologyEventsSnapshot topEvtsSnapshot = commonData.snapshot();
            ReplicationSessionDescriptor state0 = this.localState();
            if (clusterState.role() != state0.role() || clusterState.sessionId() != state0.sessionId() || clusterState.state() != state0.state()) {
                U.warn((IgniteLogger)this.log, (Object)("The local replication state differs from remote node's state. The latter will be applied. [loc=" + state0 + ", remote=" + clusterState + "]"));
                object = this.mux;
                synchronized (object) {
                    this.state = new ReplicationSessionDescriptor().role(clusterState.role()).state(clusterState.state()).sessionId(clusterState.sessionId());
                }
                this.changeClusterReadOnlyMode(clusterState.role() == ClusterRole.REPLICA);
            }
            object = this.mux;
            synchronized (object) {
                long locAppliedCutId = this.state.lastSuccessfullyAppliedCutId();
                this.state.lastSuccessfullyAppliedCutId(Math.max(locAppliedCutId, clusterState.lastGloballyAppliedCutId()));
                this.state.lastGloballyAppliedCutId(clusterState.lastGloballyAppliedCutId());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Grid data received [clusterState=" + clusterState + ", clusterState=" + clusterState + ']');
            }
            if (topEvtsSnapshot != null) {
                this.topTracker = TopologyEventsTracker.fromRawSnapshot(this.ctx, this, topEvtsSnapshot);
            }
        }
    }

    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return GridComponent.DiscoveryDataExchangeType.TX_DR_PROC;
    }

    public IgniteFuture<Void> stop() {
        TransactionalDrGlobalStatus status = this.getTxDrStatus();
        if (status.role() == ClusterRole.DISABLED || status.state() == ReplicationState.STOPPED) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication session is not started."));
        }
        if (status.role() == ClusterRole.REPLICA) {
            return this.snapMgr.startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.STOPPED, status.sessionId(), 0L);
        }
        if (status.role() == ClusterRole.MASTER) {
            return this.snapMgr.startGlobalReplicationStateChange(ClusterRole.MASTER, ReplicationState.STOPPED, status.sessionId(), 0L);
        }
        return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Invalid cluster replication state [state=" + this.state + ']'));
    }

    public IgniteFuture<Void> bootstrap(File copiedSnapshotPath, long snapshotId) {
        TransactionalDrGlobalStatus status;
        boolean isTxDrNode = !this.nodeShouldSkipActiveActions();
        TransactionalDrGlobalStatus transactionalDrGlobalStatus = status = isTxDrNode ? this.getLocalStateBasedTxDrStatus() : (TransactionalDrGlobalStatus)this.status().get();
        if (status.role() != ClusterRole.DISABLED) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Stop current replication process before bootstrapping new one."));
        }
        IgniteCacheSnapshotManager snapMgr = this.ctx.cache().context().snapshot();
        if (isTxDrNode && GridGainTxDrConfiguration.extractTxDrConfiguration((GridGainConfiguration)this.ggCfg) == null) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Transactional replication is not configured."));
        }
        if (!(snapMgr instanceof GridCacheSnapshotManager)) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Snapshots are not configured properly."));
        }
        if (!GridGainFeatures.allNodesSupports((GridKernalContext)this.ctx, (Iterable)this.ctx.discovery().aliveServerNodes(), (GridGainFeatures)GridGainFeatures.TRANSACTIONAL_REPLICATION)) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Not all nodes support transactional replication."));
        }
        StateChangeFuture fut = new StateChangeFuture(snapshotId);
        if (!this.stateChangeFut.compareAndSet(null, fut)) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication state change already in process."));
        }
        SnapshotCommonParameters parameters = new SnapshotCommonParameters(this.ggCfg.getSnapshotConfiguration().getRestoreOperationParallelism());
        SnapshotFuture<Void> snapshotFut = ((GridCacheSnapshotManager)snapMgr).startGlobalSnapshotRestore(snapshotId, null, true, Collections.singleton(SnapshotPath.file().path(copiedSnapshotPath).build()), null, "Replication bootstrap", parameters, Collections.singletonMap("REPLICATION_BOOTSTRAP_REPLICA_FLAG", true));
        snapshotFut.listen((IgniteInClosure & Serializable)snapshotFut1 -> {
            try {
                snapshotFut1.get();
            }
            catch (Throwable t) {
                fut.onDone(t);
                this.stateChangeFut.compareAndSet(fut, null);
            }
        });
        return new IgniteFutureImpl(fut);
    }

    private void localReplicaBootstrap(long sesId) throws IgniteCheckedException {
        this.checkNoWalDisabledCacheGroups();
        this.ctx.cache().context().walState().prohibitWALDisabling(true);
        this.setLocalReplicationState(new ReplicationSessionDescriptor().role(ClusterRole.REPLICA).sessionId(sesId).lastSuccessfullyAppliedCutId(sesId).lastGloballyAppliedCutId(sesId));
        this.initAndGetConsistentCutStore();
        this.printPartitionStates(false);
        this.ctx.cluster().get().baselineAutoAdjustEnabled(false);
        this.cutsWatcher = new ConsistentCutWatcher(this, this.ctx, GridGainTxDrConfiguration.extractTxDrConfiguration((GridGainConfiguration)this.ggCfg).getMaxCutDeliveryWaitTime());
        this.cutsWatcher.prepareStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object localPrepareStateChange(ClusterRole role, ReplicationState state, long sesId, long newSesId, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        ClusterNode node = this.ctx.discovery().localNode();
        assert (!node.isClient() & !node.isDaemon());
        ReplicationSessionDescriptor locState0 = this.localState();
        if (state == ReplicationState.RUNNING && locState0.state() == ReplicationState.STOPPED) {
            assert (locState0.role() == ClusterRole.DISABLED);
        } else {
            if (locState0.sessionId() != sesId) {
                throw new IgniteCheckedException("Wrong bootstrap session id, state cannot be changed [locSesId=" + locState0.sessionId() + ", reqSesId=" + sesId + ']');
            }
            if (locState0.role() != role) {
                throw new IgniteCheckedException("Wrong cluster role, state cannot be changed [locRole=" + locState0.role() + ", reqRole=" + role + ']');
            }
        }
        ReplicationState locProcState = locState0.state();
        if (role == ClusterRole.REPLICA) {
            switch (state) {
                case RUNNING: {
                    if (locProcState == ReplicationState.RUNNING) {
                        this.log.warning("Request to start already started replication session.");
                        return null;
                    } else {
                        if (locProcState == ReplicationState.STOPPED) {
                            this.changeClusterReadOnlyMode(true);
                            this.localReplicaBootstrap(sesId);
                            if (!SnapshotUtils.nodeIsNotInBaseline(node, this.ctx.cache().context(), null)) return null;
                            StateChangeFuture fut = new StateChangeFuture(sesId);
                            if (this.stateChangeFut.compareAndSet(null, fut)) return null;
                            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication state change already in process."));
                        }
                        if (locProcState != ReplicationState.PAUSED) return null;
                        this.cutsWatcher.resume();
                    }
                    return null;
                }
                case PAUSED: {
                    if (locProcState != ReplicationState.RUNNING) {
                        throw new IgniteCheckedException("Failed to pause replication, invalid replication session state: " + locState0.state());
                    }
                    this.cutsWatcher.waitForCutApplyAndSuspend(0L);
                    return this.localState().lastSuccessfullyAppliedCutId();
                }
                case STOP_NOW: {
                    if (locProcState != ReplicationState.STOPPED) return null;
                    this.log.warning("Request to stop already stopped replication session.");
                    return null;
                }
                case STOPPED: {
                    if (locProcState == ReplicationState.STOPPED) {
                        this.log.warning("Request to stop already stopped replication session.");
                        return null;
                    }
                    if (locProcState == ReplicationState.PAUSED) return this.localState().lastSuccessfullyAppliedCutId();
                    this.cutsWatcher.waitForCutApplyAndSuspend(0L);
                    return this.localState().lastSuccessfullyAppliedCutId();
                }
                case STOP_AND_RECOVERY: {
                    if (locProcState == ReplicationState.STOPPED) {
                        this.log.warning("Request to stop already stopped replication session.");
                        return null;
                    }
                    if (locProcState == ReplicationState.PAUSED) return this.localState();
                    this.cutsWatcher.waitForCutApplyAndSuspend(0L);
                    return this.localState();
                }
                case SWITCH: {
                    if (locProcState == ReplicationState.STOPPED) {
                        throw new IgniteCheckedException("Failed to switch replication role, invalid replication session state: " + locProcState);
                    }
                    if (newSesId == 0L) {
                        throw new IgniteCheckedException("Failed to switch replication role, unable to determine role switching consistent cut ID.");
                    }
                    if (!this.nodeShouldSkipActiveActions()) {
                        if (locState0.laggingBehind()) {
                            this.cutsWatcher.limitCutApplying(newSesId);
                        } else {
                            this.cutsWatcher.waitForCutApplyAndSuspend(newSesId);
                        }
                    }
                    this.setLocalReplicationState(new ReplicationSessionDescriptor().role(ClusterRole.MASTER).sessionId(newSesId));
                    if (this.nodeShouldSkipActiveActions()) return locState0;
                    this.initAndGetConsistentCutStore();
                    TopologyEventsSnapshot evtLogSnp = this.initTopologyTracker(newSesId, topVer);
                    this.initMasterBootstrapFut().onDone((Object)this.localState().sessionId());
                    WALPointer ptr = this.ctx.cache().context().wal().log((WALRecord)new TimeStampedConsistentCutRecord());
                    this.startWalShippingFromWalSegment(((FileWALPointer)ptr).index());
                    ConsistentCut cut = new ConsistentCut(newSesId, this.spawnId(), ptr, ptr, Collections.emptySet(), Collections.emptyList(), false, evtLogSnp.nodeLastEvents(), null);
                    this.consistentCutStore().save(cut);
                    if (!this.log.isInfoEnabled()) return locState0;
                    this.log.info("Consistent cut created (preparing to switch): " + cut);
                    return locState0;
                }
                default: {
                    throw new IgniteCheckedException("Wrong state change request [state=" + state + ']');
                }
            }
        }
        if (role != ClusterRole.MASTER) return null;
        switch (state) {
            case RUNNING: {
                if (locProcState == ReplicationState.RUNNING) {
                    this.log.warning("Request to start already started replication session.");
                    return null;
                }
                if (locProcState != ReplicationState.STOPPED) return null;
                return null;
            }
            case STOP_NOW: {
                if (locProcState == ReplicationState.STOPPED) {
                    this.log.warning("Request to stop already stopped replication session.");
                    return null;
                }
                if (this.ccScheduler == null) return null;
                this.ccScheduler.shutdownNow();
                return null;
            }
            case STOPPED: {
                if (locProcState == ReplicationState.STOPPED) {
                    this.log.warning("Request to stop already stopped replication session.");
                    return null;
                }
                Long finalCutId = null;
                if (this.ccScheduler == null) return finalCutId;
                this.ccScheduler.shutdown();
                try {
                    SnapshotFuture<Void> fut = this.snapMgr.startGlobalConsistentCut();
                    fut.get();
                    return fut.snapshotOperation().snapshotId();
                }
                catch (IgniteException e) {
                    throw new IgniteCheckedException((Throwable)e);
                }
            }
            case SWITCH: {
                Long newSesId0;
                if (locProcState != ReplicationState.RUNNING) {
                    throw new IgniteCheckedException("Failed to switch replication role, invalid replication session state: " + locProcState);
                }
                try {
                    newSesId0 = (Long)this.switchPrepareFut().get();
                }
                finally {
                    this.switchPrepareFut.set(null);
                }
                assert (newSesId0 != null) : "Wrong (null) session ID returned from exchange";
                this.localReplicaBootstrap(newSesId0);
                return locState0;
            }
            default: {
                throw new IgniteCheckedException("Wrong state change request [state=" + state + ']');
            }
        }
    }

    public void localCompleteStateChange(ClusterRole role, ReplicationState state, long bootstrapSesId, Map<UUID, Object> prepareStagePayload, AffinityTopologyVersion topVer, boolean success, String errMsg) throws IgniteCheckedException {
        ClusterNode node = this.ctx.discovery().localNode();
        assert (!node.isClient() && !node.isDaemon());
        if (success) {
            if (role == ClusterRole.REPLICA) {
                if (state == ReplicationState.STOPPED || state == ReplicationState.PAUSED || state == ReplicationState.STOP_AND_RECOVERY) {
                    long maxCutId = 0L;
                    if (!F.isEmpty(prepareStagePayload)) {
                        maxCutId = prepareStagePayload.values().stream().filter(Objects::nonNull).mapToLong(v -> v instanceof Long ? ((Long)v).longValue() : ((ReplicationSessionDescriptor)v).lastSuccessfullyAppliedCutId()).max().orElse(0L);
                    }
                    if (this.localState().laggingBehind()) {
                        this.cutsWatcher.limitCutApplying(maxCutId);
                    } else {
                        this.cutsWatcher.waitForCutApplyAndSuspend(maxCutId);
                    }
                    if (state == ReplicationState.STOPPED) {
                        this.stopReplicaActivities();
                    } else if (state == ReplicationState.STOP_AND_RECOVERY) {
                        this.stopConsistentCutWatcher();
                    }
                } else if (state == ReplicationState.STOP_NOW) {
                    state = ReplicationState.STOPPED;
                    this.stopReplicaActivities();
                } else if (state == ReplicationState.SWITCH) {
                    state = ReplicationState.RUNNING;
                    this.changeClusterReadOnlyMode(false);
                    this.stopConsistentCutWatcher();
                    this.startConsistentCutScheduler();
                } else if (state == ReplicationState.RUNNING && !this.nodeShouldSkipActiveActions(this.ctx.discovery().localNode())) {
                    this.cutsWatcher.completeStart();
                }
            } else if (role == ClusterRole.MASTER) {
                if (state == ReplicationState.STOPPED) {
                    Long finalCutId = (Long)prepareStagePayload.values().stream().filter(Objects::nonNull).findFirst().orElseThrow(() -> new IgniteCheckedException("Missing final consistent cut ID on stopping replication on master cluster."));
                    ConsistentCut finalCut = this.cutsStore.restore(finalCutId);
                    long segIdx = ((FileWALPointer)finalCut.cutPtr()).index();
                    this.stopMasterActivities(segIdx);
                } else if (state == ReplicationState.STOP_NOW) {
                    state = ReplicationState.STOPPED;
                    this.stopMasterActivities(null);
                } else if (state == ReplicationState.SWITCH) {
                    state = ReplicationState.RUNNING;
                    if (this.ccScheduler != null) {
                        this.ccScheduler.shutdownNow();
                    }
                    long newSesId = this.localState().sessionId();
                    boolean notInBaseline = SnapshotUtils.nodeIsNotInBaseline(node, this.ctx.cache().context(), null);
                    FileWALPointer ptr = (FileWALPointer)this.sesPtrs.remove(newSesId);
                    if (!notInBaseline) {
                        assert (ptr != null) : "WALPointer is not found. [sessionId=" + newSesId + ']';
                        this.walSnd.stopSending(ptr.index()).get();
                        this.stopWalSender();
                        this.stopConsistentCutScheduler();
                        FileConsistentCutStore oldStore = new FileConsistentCutStore(this.transferDir(bootstrapSesId, CONSISTENT_CUT_TRANSFER_DIR), (Marshaller)this.ctx.marshallerContext().jdkMarshaller());
                        Map<Object, NodeLastEvents> evts = this.topTracker.snapshotForFakeCut(newSesId, topVer).nodeLastEvents();
                        ConsistentCut roleSwitchCut = new ConsistentCut(newSesId, this.spawnId(), this.getAndClearBinaryMetadata(), (WALPointer)ptr, true, evts);
                        oldStore.save(roleSwitchCut);
                        if (this.log.isInfoEnabled()) {
                            this.log.info("Consistent cut created (role switching): " + roleSwitchCut);
                        }
                        this.cutsWatcher.completeStart();
                        this.stopTopologyTracker();
                    }
                }
            }
            if (state == ReplicationState.STOPPED) {
                this.setLocalReplicationState(new ReplicationSessionDescriptor());
                this.ctx.cache().context().walState().prohibitWALDisabling(false);
                this.initMasterBootstrapFut.set(null);
            } else if (state != ReplicationState.STOP_AND_RECOVERY) {
                ReplicationState state0 = state;
                this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)locRepState -> locRepState.state(state0));
            }
        } else {
            if (state == ReplicationState.RUNNING && this.localState().state() == ReplicationState.STOPPED) {
                this.setLocalReplicationState(new ReplicationSessionDescriptor());
                this.ctx.cache().context().walState().prohibitWALDisabling(false);
            } else if (state == ReplicationState.SWITCH) {
                this.sesPtrs.remove(this.localState().sessionId());
                ReplicationSessionDescriptor locState = null;
                if (!F.isEmpty(prepareStagePayload)) {
                    locState = (ReplicationSessionDescriptor)prepareStagePayload.get(this.ctx.localNodeId());
                }
                if (locState != null) {
                    this.setLocalReplicationState(locState);
                }
                this.initAndGetConsistentCutStore();
                if (role == ClusterRole.MASTER) {
                    this.stopConsistentCutWatcher();
                    this.startConsistentCutScheduler();
                    this.changeClusterReadOnlyMode(false);
                } else if (role == ClusterRole.REPLICA) {
                    if (this.ccScheduler != null) {
                        this.ccScheduler.shutdownNow();
                        this.stopConsistentCutScheduler();
                    }
                    if (this.walSnd != null) {
                        this.walSnd.stopSending();
                        this.stopWalSender();
                    }
                    this.stopTopologyTracker();
                    this.cutsWatcher.resume();
                }
            }
            this.essentialLog.error("Failed to change global replication state: " + errMsg);
        }
    }

    public void localFinishStateChange(ClusterRole role, ReplicationState state, long sesId, Throwable err, Long res) {
        StateChangeFuture fut = this.stateChangeFut.get();
        if (fut != null) {
            ClusterNode node = this.ctx.discovery().localNode();
            if (fut.sessionId() == sesId || node.isClient() || node.isDaemon()) {
                fut.onDone(res, err);
                this.stateChangeFut.compareAndSet(fut, null);
            } else {
                this.log.warning("Wrong session id [fut.sessionId=" + fut.sessionId() + ", msg.sessionId=" + sesId + "] for state change to " + state);
            }
        }
    }

    public void localCompleteStateChageOnRecovery() {
        if (!this.nodeShouldSkipActiveActions()) {
            this.changeClusterReadOnlyMode(false);
            this.setLocalReplicationState(new ReplicationSessionDescriptor().state(ReplicationState.STOPPED));
        }
    }

    public boolean updateStateChangeOperationInfo(SnapshotOperationInfo opInfo) {
        SnapshotOperationInfo prevOpInfo;
        StateChangeFuture fut = this.stateChangeFut.get();
        if (fut != null && (prevOpInfo = fut.opInfo()) != null && prevOpInfo.snapshotId() == opInfo.snapshotId()) {
            fut.opInfo(opInfo);
            return true;
        }
        return false;
    }

    public IgniteFuture<TransactionalDrGlobalStatus> status() {
        ComputeTaskInternalFuture fut = this.ctx.task().execute((ComputeTask)new GlobalReplicationStatusTask(), null);
        return new IgniteFutureImpl((IgniteInternalFuture)fut);
    }

    TransactionalDrGlobalStatus getTxDrStatus() {
        return this.nodeShouldSkipActiveActions() ? (TransactionalDrGlobalStatus)this.status().get() : this.getLocalStateBasedTxDrStatus();
    }

    private TransactionalDrGlobalStatus getLocalStateBasedTxDrStatus() {
        ReplicationSessionDescriptor state = this.localState();
        return new TransactionalDrGlobalStatus(state.role(), state.state(), state.sessionId(), state.lastSuccessfullyAppliedCutId(), 0L, Collections.singletonMap(this.ctx.grid().localNode().consistentId(), state), state.readOnly());
    }

    public IgniteFuture<Long> bootstrap(BootstrapMasterParameters params) {
        IgniteCheckedException err;
        StateChangeFuture<Long> fut;
        TransactionalDrGlobalStatus status;
        boolean isTxDrNode = !this.nodeShouldSkipActiveActions();
        TransactionalDrGlobalStatus transactionalDrGlobalStatus = status = isTxDrNode ? this.getLocalStateBasedTxDrStatus() : (TransactionalDrGlobalStatus)this.status().get();
        if (!this.ctx.state().publicApiActiveState(false)) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteException("The cluster is inactive."));
        }
        if (!(this.ctx.cache().context().snapshot() instanceof GridCacheSnapshotManager)) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteException("Snapshots are not configured properly."));
        }
        if (isTxDrNode && GridGainTxDrConfiguration.extractTxDrConfiguration((GridGainConfiguration)this.ggCfg) == null) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteException("Transactional replication is not configured."));
        }
        ClusterRole role0 = status.role();
        if (role0 != ClusterRole.DISABLED) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteException("Transactional replication is already initiated [role=" + role0 + "]."));
        }
        if (this.stateChangeFut.get() != null) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication state change already in process."));
        }
        HashMap<String, Serializable> replicationParams = new HashMap<String, Serializable>();
        replicationParams.put("REPLICATION_BOOTSTRAP_MASTER_FLAG", Boolean.TRUE);
        Collection publicPersistentCaches = F.viewReadOnly(this.ctx.cache().cacheDescriptors().values(), (IgniteClosure & Serializable)desc -> desc.cacheConfiguration().getName(), (IgnitePredicate[])new IgnitePredicate[]{PUBLIC_PERSISTENT_CACHE_FILTER});
        SnapshotFuture<Void> createSnapshotFut = this.snapMgr.startGlobalSnapshotCreation(new HashSet<String>(publicPersistentCaches), null, true, replicationParams, null, null, params.snapshotCommonParameters(), (SnapshotCreateParameters)new SnapshotCreateTransferParameters(params.snapshotCreateParameters().getCompressionOption(), params.snapshotCreateParameters().getCompressionLevel(), params.snapshotCreateParameters().getWriteThrottlingThreshold(), params.snapshotFolder(), params.snapshotUpdateOperationParameters()));
        SnapshotOperationInfo opInfo = createSnapshotFut.snapshotOperation();
        if (opInfo == null) {
            fut = new StateChangeFuture<Long>(-1L);
            err = null;
        } else {
            fut = new StateChangeFuture(opInfo.snapshotId());
            fut.opInfo(opInfo);
            if (!this.stateChangeFut.compareAndSet(null, fut)) {
                err = new IgniteCheckedException("Replication state change already in process.");
                this.snapMgr.cancelSnapshotOperation(createSnapshotFut.operationId(), true, "Bootstrapping master cluster failed [locNode=" + this.ctx.localNodeId() + "]");
            } else {
                err = null;
            }
        }
        createSnapshotFut.listen((IgniteInClosure & Serializable)snapshotFut -> {
            try {
                snapshotFut.get();
            }
            catch (Throwable t) {
                if (err != null) {
                    err.addSuppressed(t);
                    fut.onDone(err);
                } else {
                    fut.onDone(t);
                }
                this.stateChangeFut.compareAndSet(fut, null);
            }
        });
        return new MasterBootstrapFuture(fut);
    }

    public IgniteFuture<Void> pause() {
        TransactionalDrGlobalStatus status = this.getTxDrStatus();
        if (status.state() != ReplicationState.RUNNING) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Wrong replication process state: " + status.state()));
        }
        if (status.role() != ClusterRole.REPLICA) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Pause only allowed on replica cluster."));
        }
        return this.snapMgr.startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.PAUSED, status.sessionId(), 0L);
    }

    public IgniteFuture<Void> resume() {
        TransactionalDrGlobalStatus status = this.getTxDrStatus();
        if (status.state() != ReplicationState.PAUSED) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Wrong replication process state: " + status.state()));
        }
        if (status.role() != ClusterRole.REPLICA) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Resume only allowed on replica cluster."));
        }
        return this.snapMgr.startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.RUNNING, status.sessionId(), 0L);
    }

    public IgniteFuture<Long> switchWithReplica() {
        TransactionalDrGlobalStatus status = this.getTxDrStatus();
        if (status.role() == ClusterRole.DISABLED || status.state() != ReplicationState.RUNNING) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication session is not started."));
        }
        if (status.role() == ClusterRole.REPLICA) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("switchWithReplica operation must be initiated at master cluster."));
        }
        GridFutureAdapter switchFut = new GridFutureAdapter();
        SnapshotFuture<Void> fut = this.snapMgr.startGlobalReplicationStateChange(ClusterRole.MASTER, ReplicationState.SWITCH, status.sessionId(), 0L);
        fut.listen((IgniteInClosure & Serializable)fut1 -> {
            try {
                fut1.get();
                switchFut.onDone((Object)this.getTxDrStatus().sessionId());
            }
            catch (Throwable e) {
                switchFut.onDone(e);
            }
        });
        return new IgniteFutureImpl((IgniteInternalFuture)switchFut);
    }

    public IgniteFuture<Long> stopAndRecover() {
        TransactionalDrGlobalStatus status = this.getTxDrStatus();
        if (status.role() == ClusterRole.DISABLED || status.state() == ReplicationState.STOPPED) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication session is not started."));
        }
        if (status.role() == ClusterRole.REPLICA) {
            StateChangeFuture fut = new StateChangeFuture(status.sessionId());
            if (!this.stateChangeFut.compareAndSet(null, fut)) {
                return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication state change already in process."));
            }
            SnapshotFuture<Void> snapshotFut = this.snapMgr.startGlobalReplicationStateChange(ClusterRole.REPLICA, ReplicationState.STOP_AND_RECOVERY, status.sessionId(), 0L);
            snapshotFut.listen((IgniteInClosure & Serializable)snapshotFut1 -> {
                try {
                    snapshotFut1.get();
                }
                catch (Throwable t) {
                    fut.onDone(t);
                    this.stateChangeFut.compareAndSet(fut, null);
                }
            });
            return new IgniteFutureImpl(fut);
        }
        if (status.role() == ClusterRole.MASTER) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("stopAndRecover is invalid operation on master cluster."));
        }
        return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Invalid cluster replication state [state=" + this.state + ']'));
    }

    public IgniteFuture<Void> stopNow() {
        TransactionalDrGlobalStatus status = this.getTxDrStatus();
        if (status.role() == ClusterRole.DISABLED || status.state() == ReplicationState.STOPPED) {
            return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Replication session is not started."));
        }
        if (status.role() == ClusterRole.REPLICA || status.role() == ClusterRole.MASTER) {
            SnapshotFuture<Void> fut;
            try {
                fut = this.snapMgr.startGlobalReplicationStateChange(status.role(), ReplicationState.STOP_NOW, status.sessionId(), 0L);
            }
            catch (Exception e) {
                this.log.warning("Failed to initiate graceful cluster state change, falling back to forceful stop.", (Throwable)e);
                return new IgniteFutureImpl((IgniteInternalFuture)this.ctx.task().execute((ComputeTask)new ResetTxDrNodeStateTask(), null));
            }
            GridFutureAdapter res = new GridFutureAdapter();
            AtomicBoolean guard = new AtomicBoolean();
            final IgniteInClosure & Serializable lsnr = (IgniteInClosure & Serializable)f -> {
                if (guard.compareAndSet(false, true)) {
                    boolean isDone = f.isDone();
                    if (isDone) {
                        try {
                            f.get();
                            res.onDone((Object)null);
                            return;
                        }
                        catch (IgniteInterruptedException e) {
                            throw e;
                        }
                        catch (IgniteException e) {
                            this.log.error("Graceful cluster state change has failed, falling back to forceful stop.", (Throwable)e);
                        }
                    }
                    this.log.warning("Graceful cluster state change is hanging, falling back to forceful stop.");
                    Runnable fallback = () -> this.ctx.task().execute((ComputeTask)new ResetTxDrNodeStateTask(), null).listen((IgniteInClosure & Serializable)f0 -> res.onDone((Object)null));
                    fallback.run();
                    if (!isDone) {
                        f.listen((IgniteInClosure & Serializable)f0 -> fallback.run());
                    }
                }
            };
            this.ctx.timeout().addTimeoutObject((GridTimeoutObject)new GridTimeoutObjectAdapter(this.ctx.config().getFailureDetectionTimeout(), (IgniteFuture)fut){
                final /* synthetic */ IgniteFuture val$fut;
                {
                    this.val$fut = igniteFuture;
                    super(x0);
                }

                public void onTimeout() {
                    lsnr.apply((Object)this.val$fut);
                }
            });
            fut.listen((IgniteInClosure)lsnr);
            return new IgniteFutureImpl((IgniteInternalFuture)res);
        }
        return new IgniteFinishedFutureImpl((Throwable)new IgniteCheckedException("Invalid cluster replication state [state=" + this.state + ']'));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationSessionDescriptor localState() {
        Object object = this.mux;
        synchronized (object) {
            return new ReplicationSessionDescriptor(this.state).readOnly(this.ctx.cache().context().readOnlyMode()).essentialMessages(this.essentialMessages);
        }
    }

    public void lastSentWalSegment(long walIdx) throws IgniteCheckedException {
        this.initMasterBootstrapFut().get();
        this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> state.lastSuccessfullySentWalIndex(walIdx));
    }

    public void lastCreatedConsistentCut(long cutId) throws IgniteCheckedException {
        this.initMasterBootstrapFut().get();
        this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> state.lastCreatedCutId(cutId));
    }

    public void lastAppliedConsistentCut(long cutId) throws IgniteException {
        this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> state.lastSuccessfullyAppliedCutId(cutId));
    }

    public void nodeIsLaggingBehind(boolean laggingBehind) {
        this.updateLocalReplicationState((IgniteInClosure<ReplicationSessionDescriptor>)(IgniteInClosure & Serializable)state -> state.laggingBehind(laggingBehind));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalReplicationState(IgniteInClosure<ReplicationSessionDescriptor> updater) throws IgniteException {
        Object object = this.mux;
        synchronized (object) {
            updater.apply((Object)this.state);
            if (this.metastorage != null) {
                this.setLocalReplicationState(this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocalReplicationState(ReplicationSessionDescriptor newState) {
        assert (this.metastorage != null);
        Object object = this.mux;
        synchronized (object) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Local replication state changed, newState=" + newState);
            }
            this.state = newState;
            assert (!this.state.state().isTransient()) : "Invalid replication state [state=" + this.state.state() + ']';
            this.ctx.cache().context().database().checkpointReadLock();
            try {
                this.metastorage.write(METASTORE_REPLICATION_STATE_KEY, (Serializable)this.state);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
            finally {
                this.ctx.cache().context().database().checkpointReadUnlock();
            }
        }
    }

    public ConsistentCutStore consistentCutStore() {
        try {
            return this.initAndGetConsistentCutStore();
        }
        catch (IgniteCheckedException e) {
            this.essentialLog.error("Failed to init replication transfer folder", (Throwable)e);
            return null;
        }
    }

    public ConsistentCutGC gc() {
        try {
            this.initAndGetConsistentCutStore();
            return this.gc;
        }
        catch (IgniteCheckedException e) {
            this.essentialLog.error("Failed to init replication transfer folder", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    public File walDir(long spawnId) {
        try {
            this.initAndGetConsistentCutStore();
            return this.ensureDir(this.walDir, spawnId);
        }
        catch (IgniteCheckedException e) {
            this.essentialLog.error("Failed to init replication transfer folder", (Throwable)e);
            throw new IgniteException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<BinaryMetadata> getAndClearBinaryMetadata() throws IgniteCheckedException {
        this.ctx.cache().context().database().checkpointReadLock();
        try {
            HashMap<Integer, BinaryMetadata> hashMap = this.binaryMetadata;
            synchronized (hashMap) {
                ArrayList<BinaryMetadata> res = new ArrayList<BinaryMetadata>(this.binaryMetadata.size());
                for (Map.Entry<Integer, BinaryMetadata> e : this.binaryMetadata.entrySet()) {
                    res.add(e.getValue());
                    this.metastorage.remove(METASTORE_REPLICATION_BINARY_META_KEY_PREFIX + e.getKey());
                }
                this.metastorage.remove(METASTORE_REPLICATION_BINARY_META_IDS_KEY);
                this.binaryMetadata.clear();
                ArrayList<BinaryMetadata> arrayList = res;
                return arrayList;
            }
        }
        finally {
            this.ctx.cache().context().database().checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBinaryMetadata(Collection<BinaryMetadata> col) throws IgniteCheckedException {
        HashMap<Integer, BinaryMetadata> hashMap = this.binaryMetadata;
        synchronized (hashMap) {
            this.metastorage.write(METASTORE_REPLICATION_BINARY_META_IDS_KEY, new HashSet<Integer>(this.binaryMetadata.keySet()));
            for (BinaryMetadata meta : col) {
                this.metastorage.write(METASTORE_REPLICATION_BINARY_META_KEY_PREFIX + meta.typeId(), (Serializable)meta);
            }
        }
    }

    private TopologyEventsSnapshot initTopologyTracker(long bootstrapSesId, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        if (this.nodeShouldSkipActiveActions()) {
            throw new IgniteCheckedException("Topology events tracker can't be created on the node " + this.ctx.igniteInstanceName() + " because it does not participate in TxDr operations.");
        }
        this.topTracker = new TopologyEventsTracker(this.ctx, topVer);
        this.topTracker.start();
        return this.topTracker.snapshotForFakeCut(bootstrapSesId, topVer);
    }

    public TopologyEventsTracker topologyTracker() throws IgniteCheckedException {
        this.initMasterBootstrapFut().get();
        return this.topTracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsistentCutStore initAndGetConsistentCutStore() throws IgniteCheckedException {
        ClusterNode node = this.ctx.discovery().localNode();
        if (node.isClient() || node.isDaemon()) {
            throw new IgniteCheckedException("ConsistentCutStore can't be created on the node " + this.ctx.igniteInstanceName() + " because it does not participate in TxDr operations.");
        }
        if (this.cutsStore == null || this.localState().sessionId() != this.latestBootstrapSesId) {
            TransactionalDrProcessorImpl transactionalDrProcessorImpl = this;
            synchronized (transactionalDrProcessorImpl) {
                long bootstrapSesId = this.localState().sessionId();
                if (this.cutsStore == null || bootstrapSesId != this.latestBootstrapSesId) {
                    this.walDir = this.transferDir(bootstrapSesId, WAL_TRANSFER_DIR);
                    File cutsDir = this.transferDir(bootstrapSesId, CONSISTENT_CUT_TRANSFER_DIR);
                    this.cutsStore = new FileConsistentCutStore(cutsDir, (Marshaller)this.ctx.marshallerContext().jdkMarshaller());
                    this.latestBootstrapSesId = bootstrapSesId;
                    this.gc = new ConsistentCutGC(this.log, this.cutsStore, this.walDir);
                }
            }
        }
        return this.cutsStore;
    }

    synchronized void resetConsistentCutStore() {
        this.cutsStore = null;
        this.gc = null;
        this.walDir = null;
    }

    public synchronized long spawnId() {
        assert (this.metastorage != null);
        if (this.spawnId == 0L) {
            this.ctx.cache().context().database().checkpointReadLock();
            try {
                Serializable storedSpawnId = this.metastorage.read(METASTORE_SPAWN_ID_KEY);
                if (storedSpawnId != null) {
                    this.spawnId = (Long)storedSpawnId;
                } else {
                    long newSpawnId = U.currentTimeMillis();
                    this.metastorage.write(METASTORE_SPAWN_ID_KEY, (Serializable)Long.valueOf(newSpawnId));
                    this.spawnId = newSpawnId;
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
            finally {
                this.ctx.cache().context().database().checkpointReadUnlock();
            }
        }
        return this.spawnId;
    }

    private File transferDir(long bootstrapSesId, String dirName) throws IgniteCheckedException {
        File transferFolder = new File(GridGainTxDrConfiguration.extractTxDrConfiguration((GridGainConfiguration)this.ggCfg).getTransferFolderPath(), Long.toString(bootstrapSesId));
        File nodeTransferFolder = new File(transferFolder, this.ctx.discovery().localNode().consistentId().toString());
        return this.ensureDir(nodeTransferFolder, dirName);
    }

    private File ensureDir(File parent, Object dirName) throws IgniteCheckedException {
        String name = String.valueOf(dirName);
        File dir = new File(parent, name);
        U.ensureDirectory((File)dir, (String)name, null);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTxDrActivities() {
        ClusterRole role;
        Object object = this.mux;
        synchronized (object) {
            role = this.state.role();
        }
        switch (role) {
            case MASTER: {
                this.stopMasterActivities(null);
                break;
            }
            case REPLICA: {
                this.stopReplicaActivities();
                break;
            }
            default: {
                this.log.warning("Failed to stop TxDr activities; unexpected cluster role: " + role);
            }
        }
    }

    private void stopMasterActivities(@Nullable Long sndWalSegsUpToIdx) {
        try {
            (sndWalSegsUpToIdx != null ? this.walSnd.stopSending(sndWalSegsUpToIdx) : this.walSnd.stopSending()).get();
        }
        catch (IgniteCheckedException e) {
            throw (IllegalStateException)e.getCause(IllegalStateException.class);
        }
        this.stopWalSender();
        this.stopConsistentCutScheduler();
        this.stopTopologyTracker();
    }

    private void stopReplicaActivities() {
        this.stopConsistentCutWatcher();
        this.changeClusterReadOnlyMode(false);
        this.resetConsistentCutStore();
    }

    private void stopWalSender() {
        if (this.walSnd != null) {
            U.cancel((GridWorker)this.walSnd);
            U.join((GridWorker)this.walSnd, (IgniteLogger)this.log);
            this.walSnd = null;
        }
    }

    private void stopConsistentCutScheduler() {
        if (this.ccScheduler != null) {
            U.cancel((GridWorker)this.ccScheduler);
            U.join((GridWorker)this.ccScheduler, (IgniteLogger)this.log);
            this.ccScheduler = null;
        }
    }

    void stopConsistentCutWatcher() {
        if (this.cutsWatcher != null) {
            this.cutsWatcher.stop();
            this.cutsWatcher = null;
        }
    }

    private void stopTopologyTracker() {
        if (this.topTracker != null) {
            this.topTracker.stop();
            this.topTracker = null;
        }
    }

    private boolean nodeShouldSkipActiveActions() {
        return this.nodeShouldSkipActiveActions(this.ctx.discovery().localNode());
    }

    private boolean nodeShouldSkipActiveActions(ClusterNode node) {
        return node.isClient() || node.isDaemon() || SnapshotUtils.nodeIsNotInBaseline(node, this.ctx.cache().context(), null);
    }

    private void changeClusterReadOnlyMode(boolean readOnly) {
        this.ctx.cache().context().readOnlyMode(readOnly);
    }

    ConsistentCutWatcher consistentCutWatcher() {
        return this.cutsWatcher;
    }

    void printPartitionStates(boolean force) {
        Collection cacheDescs = this.ctx.cache().cacheDescriptors().values();
        HashSet<Integer> publicPersistentCaches = new HashSet<Integer>(F.viewReadOnly(cacheDescs, DynamicCacheDescriptor::groupId, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)desc -> (desc.cacheType().userCache() || desc.cacheType() == CacheType.DATA_STRUCTURES && CU.cacheId((String)"default-volatile-ds-group") != desc.groupId()) && desc.groupDescriptor().persistenceEnabled() && desc.cacheConfiguration().getCacheMode() != CacheMode.LOCAL}));
        this.printPartitionStates(publicPersistentCaches, force);
    }

    void printPartitionStates(Collection<Integer> grpIds, boolean force) {
        PrintWriter idealPw;
        PrintWriter dumpPw;
        ArrayList<Integer> sortedGrpIds = new ArrayList<Integer>(grpIds);
        Collections.sort(sortedGrpIds);
        if (!TX_DR_DEBUG_OUTPUT_ENABLED && !force) {
            return;
        }
        try {
            File root = this.transferDir(this.localState().sessionId(), "partition-states-debug-" + this.localState().role().name());
            dumpPw = new PrintWriter(new File(root, "actual.dump"));
            idealPw = new PrintWriter(new File(root, "ideal.dump"));
        }
        catch (FileNotFoundException | IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to create file to dump partition states", (Throwable)e);
            return;
        }
        if (this.log.isInfoEnabled()) {
            CacheGroupContext cacheCtx;
            StringBuilder sb = new StringBuilder();
            sb.append("Dump partition states for all replicating caches:").append('\n');
            this.log.info(sb.toString());
            sb.setLength(0);
            for (Integer grpId : sortedGrpIds) {
                cacheCtx = this.ctx.cache().cacheGroup(grpId.intValue());
                sb.append("^-- [grpId=").append(cacheCtx.groupId()).append(", cacheOrGroupName=").append(cacheCtx.cacheOrGroupName()).append(", partitions=[");
                for (int partIdx = 0; partIdx < cacheCtx.affinityFunction().partitions(); ++partIdx) {
                    GridDhtLocalPartition part = cacheCtx.topology().localPartition(partIdx, AffinityTopologyVersion.NONE, false);
                    if (part == null) continue;
                    sb.append(part.id()).append('=').append(part.state().toString().charAt(0)).append('<').append(part.updateCounter()).append('>').append(", ");
                }
                sb.append("]\n");
                this.log.info(sb.toString());
                dumpPw.print(sb.toString());
                sb.setLength(0);
            }
            dumpPw.close();
            sb.append("Ideal affinity assignment for all replicating caches:").append('\n');
            this.log.info(sb.toString());
            sb.setLength(0);
            for (Integer grpId : sortedGrpIds) {
                cacheCtx = this.ctx.cache().cacheGroup(grpId.intValue());
                sb.append("^-- [grpId=").append(cacheCtx.groupId()).append(", cacheOrGroupName=").append(cacheCtx.cacheOrGroupName()).append(", partitions=[");
                List idealAssignment = cacheCtx.affinity().idealAssignment().assignment();
                for (int i = 0; i < idealAssignment.size(); ++i) {
                    List nodesForPart = (List)idealAssignment.get(i);
                    for (ClusterNode n : nodesForPart) {
                        if (!n.isLocal()) continue;
                        sb.append(i).append("=").append("O").append(", ");
                    }
                }
                sb.append("]\n");
                this.log.info(sb.toString());
                idealPw.print(sb.toString());
                sb.setLength(0);
            }
            idealPw.close();
        }
    }

    WalSender walSender() {
        return this.walSnd;
    }

    ConsistentCutScheduler consistentCutScheduler() {
        return this.ccScheduler;
    }

    boolean cutApplyingInProgress() {
        return this.snapMgr.cutApplyingInProgress();
    }

    public DebugMode debugMode() {
        return this.debugMode;
    }

    public void debugMode(DebugMode debugMode) {
        if (debugMode == null) {
            debugMode = DFLT_DEBUG_MODE;
        }
        this.debugMode = debugMode;
    }

    public IgniteLogger essentialLogger() {
        return this.essentialLog;
    }

    private void checkNoWalDisabledCacheGroups() throws IgniteCheckedException {
        Collection grpDescs = F.view(this.ctx.cache().cacheGroupDescriptors().values(), (IgnitePredicate[])new IgnitePredicate[]{PUBLIC_PERSISTENT_CACHE_GROUP_FILTER, this.walDisabledFilter()});
        if (!grpDescs.isEmpty()) {
            CacheGroupContext grpCtx = this.ctx.cache().cacheGroup(((CacheGroupDescriptor)grpDescs.iterator().next()).groupId());
            assert (grpCtx != null);
            throw new IgniteCheckedException("WAL is disabled for cache group [groupId=" + grpCtx.groupId() + ", name=" + grpCtx.name() + ']');
        }
    }

    private IgnitePredicate<CacheGroupDescriptor> walDisabledFilter() {
        return (IgnitePredicate & Serializable)grpDesc -> Optional.ofNullable(this.ctx.cache().cacheGroup(grpDesc.groupId())).map(gCtx -> !gCtx.globalWalEnabled()).orElse(false);
    }

    private ChangeGlobalStateMessage baselineChangeMessage(GridDhtPartitionsExchangeFuture fut) {
        ExchangeDiscoveryEvents evts = fut.events();
        for (DiscoveryEvent evt : evts.events()) {
            ChangeGlobalStateMessage changeStateMsg;
            DiscoveryCustomEvent customEvt;
            DiscoveryCustomMessage msg;
            if (!(evt instanceof DiscoveryCustomEvent) || !((msg = (customEvt = (DiscoveryCustomEvent)evt).customMessage()) instanceof ChangeGlobalStateMessage) || !(changeStateMsg = (ChangeGlobalStateMessage)msg).forceChangeBaselineTopology()) continue;
            return changeStateMsg;
        }
        return null;
    }

    private boolean isTriggeredBySpecialRebalanceEvent(GridDhtPartitionsExchangeFuture fut) {
        ExchangeDiscoveryEvents evts = fut.events();
        for (DiscoveryEvent evt : evts.events()) {
            if (!(evt instanceof DiscoveryCustomEvent)) continue;
            DiscoveryCustomEvent customEvt = (DiscoveryCustomEvent)evt;
            DiscoveryCustomMessage msg = customEvt.customMessage();
            if ((msg instanceof ConsistentCutAppliedGloballyDiscoveryMessage || msg instanceof FinishSnapshotOperationAckDiscoveryMessage) && ((SnapshotDiscoveryMessage)msg).needExchange()) {
                return true;
            }
            if (!(msg instanceof ChangeGlobalStateMessage)) continue;
            return true;
        }
        return false;
    }

    private static class FakeCutMark {
        private long sesId;
        private AffinityTopologyVersion topVer;
        private long cutId;
        SnapshotOperationType op;

        public FakeCutMark(long sesId, AffinityTopologyVersion topVer, long cutId, SnapshotOperationType op) {
            this.sesId = sesId;
            this.topVer = topVer;
            this.cutId = cutId;
            this.op = op;
        }

        public long sessionId() {
            return this.sesId;
        }

        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }

        public long consistentCutId() {
            return this.cutId;
        }

        public SnapshotOperationType operation() {
            return this.op;
        }
    }

    public static class TxDrDiscoveryDataBag
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private final ReplicationSessionDescriptor state;
        private final TopologyEventsSnapshot snapshot;

        public TxDrDiscoveryDataBag(ReplicationSessionDescriptor state, TopologyEventsSnapshot snapshot) {
            this.state = state;
            this.snapshot = snapshot;
        }

        public ReplicationSessionDescriptor state() {
            return this.state;
        }

        public TopologyEventsSnapshot snapshot() {
            return this.snapshot;
        }
    }

    static class StateChangeFuture<T>
    extends GridFutureAdapter<T> {
        private final long sesId;
        private volatile SnapshotOperationInfo opInfo;

        StateChangeFuture(long sesId) {
            this.sesId = sesId;
        }

        public long sessionId() {
            return this.sesId;
        }

        SnapshotOperationInfo opInfo() {
            return this.opInfo;
        }

        void opInfo(SnapshotOperationInfo opInfo) {
            this.opInfo = opInfo;
        }
    }

    static class MasterBootstrapFuture
    extends IgniteFutureImpl<Long> {
        public MasterBootstrapFuture(StateChangeFuture<Long> fut) {
            super(fut);
        }

        public StateChangeFuture<Long> internalFuture() {
            return (StateChangeFuture)super.internalFuture();
        }

        public Long get() {
            super.get();
            return this.internalFuture().sessionId();
        }

        public Long get(long timeout) {
            super.get(timeout);
            return this.internalFuture().sessionId();
        }

        public Long get(long timeout, TimeUnit unit) {
            super.get(timeout, unit);
            return this.internalFuture().sessionId();
        }

        public IgniteUuid operationId() {
            SnapshotOperationInfo opInfo = this.internalFuture().opInfo();
            return opInfo != null ? opInfo.operationId() : null;
        }
    }
}

