/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheGroupDescriptor;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;

public class PartitionMapValidator {
    private final GridKernalContext ctx;
    private volatile IgniteBiTuple<Integer, Map<Integer, Map<Object, BitSet>>> currBltPartMap;
    private final IgniteLogger log;

    public PartitionMapValidator(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(PartitionMapValidator.class);
    }

    private List<List<ClusterNode>> calcGrpBaselineAssignment(CacheGroupContext grp, BaselineTopology blt) throws IgniteCheckedException {
        CacheConfiguration cfg = grp.config();
        List cacheNodes = blt.createBaselineView(Collections.emptyList(), cfg.getNodeFilter());
        return SnapshotUtils.calcAffinityAssignment(this.ctx.resource(), cacheNodes, cfg, null);
    }

    private Map<Integer, Map<Object, BitSet>> calcNodesPartMap(BaselineTopology blt) throws IgniteCheckedException {
        IgniteBiTuple<Integer, Map<Integer, Map<Object, BitSet>>> currBltPartMap = this.currBltPartMap;
        if (currBltPartMap != null && ((Integer)currBltPartMap.get1()).intValue() == blt.id()) {
            return (Map)currBltPartMap.get2();
        }
        HashMap<Integer, Map<Object, BitSet>> nodesPartMap = new HashMap<Integer, Map<Object, BitSet>>();
        for (CacheGroupContext grp : this.ctx.cache().cacheGroups()) {
            if (grp.config().getCacheMode() != CacheMode.PARTITIONED) continue;
            List<List<ClusterNode>> grpBaselineAssignment = this.calcGrpBaselineAssignment(grp, blt);
            HashMap<Object, BitSet> grpNodesPartMap = new HashMap<Object, BitSet>();
            for (int p = 0; p < grpBaselineAssignment.size(); ++p) {
                for (ClusterNode node : grpBaselineAssignment.get(p)) {
                    BitSet nodeParts = grpNodesPartMap.computeIfAbsent(node.consistentId(), key -> new BitSet(grpBaselineAssignment.size()));
                    nodeParts.set(p);
                }
            }
            nodesPartMap.put(grp.groupId(), grpNodesPartMap);
        }
        this.currBltPartMap = new IgniteBiTuple((Object)blt.id(), nodesPartMap);
        return nodesPartMap;
    }

    public boolean checkPartitionsConsistency(BaselineTopology blt, Collection<ClusterNode> aliveNodes, Set<Object> cutApplyTop) throws IgniteCheckedException {
        assert (blt != null) : "Baseline topology is null";
        Map<Integer, Map<Object, BitSet>> nodesPartMap = this.calcNodesPartMap(blt);
        Map<Object, UUID> nodeIdMap = null;
        if (aliveNodes != null) {
            nodeIdMap = aliveNodes.stream().collect(Collectors.toMap(ClusterNode::consistentId, ClusterNode::id));
        }
        for (CacheGroupContext gctx : this.ctx.cache().cacheGroups()) {
            if (gctx.config().getCacheMode() != CacheMode.PARTITIONED) continue;
            CacheGroupDescriptor desc = (CacheGroupDescriptor)this.ctx.cache().cacheGroupDescriptors().get(gctx.groupId());
            assert (desc != null) : "Cache group descriptor is null for group: " + gctx.groupId();
            if (!TransactionalDrProcessorImpl.PUBLIC_PERSISTENT_CACHE_GROUP_FILTER.apply((Object)desc)) continue;
            Map<Object, BitSet> grpNodesPartMap = nodesPartMap.get(gctx.groupId());
            if (grpNodesPartMap == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Missing estimated partition state map for cache group " + gctx.groupId());
                }
                return false;
            }
            GridDhtPartitionTopology partTop = gctx.topology();
            BitSet grpPartMap = new BitSet();
            for (Object consistentId : cutApplyTop) {
                BitSet grpNodePartMap = grpNodesPartMap.get(consistentId);
                if (grpNodePartMap == null) continue;
                if (nodeIdMap != null) {
                    GridDhtPartitionMap parts;
                    UUID nodeId = nodeIdMap.get(consistentId);
                    if (nodeId == null || (parts = partTop.partitions(nodeId)) == null) continue;
                    int p = grpNodePartMap.nextSetBit(0);
                    while (p >= 0) {
                        if (parts.get(Integer.valueOf(p)) != GridDhtPartitionState.OWNING) {
                            grpNodePartMap.clear(p);
                        }
                        p = grpNodePartMap.nextSetBit(p + 1);
                    }
                }
                grpPartMap.or(grpNodePartMap);
            }
            if (grpPartMap.nextClearBit(0) >= gctx.affinity().partitions()) continue;
            if (this.log.isInfoEnabled()) {
                this.log.info("Estimated data loss in the partition [groupId=" + gctx.groupId() + ", part=" + grpPartMap.nextClearBit(0) + ']');
            }
            return false;
        }
        return true;
    }
}

