/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.scheduler.SchedulerFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCommonParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduleJobWrapper;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotCheck;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotCreation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperationChain;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotsDeletion;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotsMoving;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleKey;
import org.gridgain.grid.internal.visor.database.snapshot.VisorSnapshots;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class SnapshotScheduleV2
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String id;
    private String name;
    private SnapshotOperationType opType;
    private String fullSnapshotFreq;
    private transient SchedulerFuture fullSnapshotTask;
    private String incSnapshotFreq;
    private long ttl;
    private String dest;
    private Set<String> cacheNames;
    private boolean enabled = true;
    private UUID nid;
    private List<String> locSchedules = new ArrayList<String>();
    private SnapshotCommonParameters snapshotCommonParameters;
    private SnapshotCreateParameters snapshotCreateParameters;
    private String keyAlias;
    private int forOldest;
    private int forLatest;
    @Nullable
    private String execAfter;
    @Nullable
    private SnapshotScheduleKey taskChain;
    @GridToStringInclude
    @Nullable
    private List<SnapshotScheduleV2> followingSchedules;
    private int keepCount = 1;
    private long lastFullSnapshotId;

    public SnapshotScheduleV2() {
    }

    public SnapshotScheduleV2(String id, String name, SnapshotOperationType opType, String fullSnapshotFreq, String incSnapshotFreq, Set<String> cacheNames, long ttl, String dest, boolean enabled, SnapshotCommonParameters snapshotCommonParameters, SnapshotCreateParameters snapshotCreateParameters, String keyAlias, int forOldest, int forLatest, @Nullable String execAfter, int keepCount) {
        assert (name != null);
        assert (opType == SnapshotOperationType.CREATE || opType == SnapshotOperationType.DELETE || opType == SnapshotOperationType.MOVE || opType == SnapshotOperationType.CHECK || opType == SnapshotOperationType.CONFIGURABLE);
        this.id = id != null ? id : UUID.randomUUID().toString();
        this.name = name;
        this.opType = opType;
        this.fullSnapshotFreq = fullSnapshotFreq;
        this.incSnapshotFreq = incSnapshotFreq;
        this.cacheNames = cacheNames;
        this.ttl = ttl;
        this.dest = dest;
        this.enabled = enabled;
        this.snapshotCommonParameters = snapshotCommonParameters;
        this.snapshotCreateParameters = snapshotCreateParameters;
        this.keyAlias = keyAlias;
        this.forOldest = forOldest;
        this.forLatest = forLatest;
        this.execAfter = execAfter;
        this.keepCount = keepCount;
    }

    public SnapshotScheduleV2(SnapshotSchedule schedule) {
        assert (schedule != null);
        this.id = schedule.getId();
        this.name = schedule.getName();
        this.opType = schedule.getOperationType();
        this.fullSnapshotFreq = schedule.getFullSnapshotFrequency();
        this.incSnapshotFreq = schedule.getIncrementalSnapshotFrequency();
        this.cacheNames = schedule.getCacheNames();
        this.ttl = schedule.getTtl();
        this.dest = schedule.getDestination();
        this.enabled = schedule.isEnabled();
        this.snapshotCommonParameters = schedule.getSnapshotCommonParameters();
        this.snapshotCreateParameters = schedule.getSnapshotCreateParameters();
        this.locSchedules.addAll(schedule.getLocSchedules());
        this.nid = schedule.getNid();
        this.forOldest = -1;
        this.forLatest = -1;
        this.keepCount = 1;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public SnapshotOperationType getOperationType() {
        return this.opType;
    }

    public String getFullSnapshotFrequency() {
        return this.fullSnapshotFreq;
    }

    public String getIncrementalSnapshotFrequency() {
        return this.incSnapshotFreq;
    }

    public long getTtl() {
        return this.ttl;
    }

    public String getDestination() {
        return this.dest;
    }

    public Set<String> getCacheNames() {
        return this.cacheNames;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int forOldest() {
        return this.forOldest;
    }

    public int forLatest() {
        return this.forLatest;
    }

    @Nullable
    public String execAfter() {
        return this.execAfter;
    }

    @Nullable
    public SnapshotScheduleKey taskChain() {
        return this.taskChain;
    }

    public void taskChain(@Nullable SnapshotScheduleKey key) {
        this.taskChain = key;
    }

    public SnapshotCommonParameters getSnapshotCommonParameters() {
        return this.snapshotCommonParameters;
    }

    public void setSnapshotCommonParameters(SnapshotCommonParameters snapshotCommonParameters) {
        this.snapshotCommonParameters = snapshotCommonParameters;
    }

    public void setSnapshotCreateParameters(SnapshotCreateParameters snapshotCreateParameters) {
        this.snapshotCreateParameters = snapshotCreateParameters;
    }

    public SnapshotCreateParameters getSnapshotCreateParameters() {
        return this.snapshotCreateParameters;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    @Nullable
    public List<SnapshotScheduleV2> followingSchedules() {
        return this.followingSchedules;
    }

    public void followingSchedules(@Nullable List<SnapshotScheduleV2> schedules) {
        this.followingSchedules = schedules;
    }

    public int keepCount() {
        return this.keepCount;
    }

    public long lastFullSnapshotId() {
        return this.lastFullSnapshotId;
    }

    public void lastFullSnapshotId(long id) {
        this.lastFullSnapshotId = id;
    }

    public SnapshotScheduleV2 copy() {
        SnapshotScheduleV2 copy = new SnapshotScheduleV2(this.id, this.name, this.opType, this.fullSnapshotFreq, this.incSnapshotFreq, this.cacheNames == null ? null : new HashSet<String>(this.cacheNames), this.ttl, this.dest, this.enabled, this.snapshotCommonParameters, this.snapshotCreateParameters, this.keyAlias, this.forOldest, this.forLatest, this.execAfter, this.keepCount);
        copy.nid = this.nid;
        copy.locSchedules = new ArrayList<String>(this.locSchedules);
        copy.fullSnapshotTask = this.fullSnapshotTask;
        copy.taskChain = this.taskChain;
        copy.followingSchedules = this.followingSchedules == null ? null : this.followingSchedules.stream().map(SnapshotScheduleV2::copy).collect(Collectors.toList());
        copy.lastFullSnapshotId = this.lastFullSnapshotId;
        return copy;
    }

    private SchedulerFuture scheduleLocal(Ignite ignite, ScheduledSnapshotOperation job, String cron) {
        IgniteScheduler scheduler = ignite.scheduler();
        SchedulerFuture fut = scheduler.scheduleLocal((Callable)new ScheduleJobWrapper(ignite, job), VisorSnapshots.toCron(cron));
        fut.last();
        ConcurrentMap nl = ignite.cluster().nodeLocalMap();
        nl.put(fut.id(), fut);
        this.locSchedules.add(fut.id());
        return fut;
    }

    private void startLocal0(Ignite ignite) {
        if (!GridFunc.isEmpty(this.followingSchedules)) {
            ScheduledSnapshotOperationChain parent = new ScheduledSnapshotOperationChain(ignite, this, true);
            this.fullSnapshotTask = this.scheduleLocal(ignite, parent, this.fullSnapshotFreq);
            if (!GridFunc.isEmpty((String)this.incSnapshotFreq)) {
                this.scheduleLocal(ignite, new ScheduledSnapshotOperationChain(ignite, this, false), this.incSnapshotFreq);
            }
        } else if (this.opType == SnapshotOperationType.CREATE) {
            ScheduledSnapshotCreation parent = new ScheduledSnapshotCreation(ignite, this, true);
            this.fullSnapshotTask = this.scheduleLocal(ignite, parent, this.fullSnapshotFreq);
            if (!GridFunc.isEmpty((String)this.incSnapshotFreq)) {
                this.scheduleLocal(ignite, new ScheduledSnapshotCreation(ignite, this, false), this.incSnapshotFreq);
            }
        } else if (this.opType == SnapshotOperationType.DELETE) {
            this.scheduleLocal(ignite, new ScheduledSnapshotsDeletion(ignite, this), this.fullSnapshotFreq);
        } else if (this.opType == SnapshotOperationType.MOVE) {
            this.scheduleLocal(ignite, new ScheduledSnapshotsMoving(ignite, this), this.fullSnapshotFreq);
        } else if (this.opType == SnapshotOperationType.CHECK) {
            this.scheduleLocal(ignite, new ScheduledSnapshotCheck(ignite, this), this.fullSnapshotFreq);
        }
        this.enabled = true;
    }

    public boolean startLocal(Ignite ignite) {
        UUID locNodeId = ignite.cluster().localNode().id();
        if (!locNodeId.equals(this.nid)) {
            this.nid = locNodeId;
            this.locSchedules.clear();
        }
        if (this.locSchedules.isEmpty() && this.enabled) {
            this.startLocal0(ignite);
            return true;
        }
        return false;
    }

    public boolean enable(Ignite ignite) {
        if (this.locSchedules.isEmpty() && !this.enabled) {
            this.startLocal0(ignite);
            return true;
        }
        return false;
    }

    public void cancel(Ignite ignite) {
        ConcurrentMap nl = ignite.cluster().nodeLocalMap();
        for (String locId : this.locSchedules) {
            SchedulerFuture fut = (SchedulerFuture)nl.remove(locId);
            if (fut == null) continue;
            fut.cancel();
        }
        this.locSchedules.clear();
    }

    public void disable(Ignite ignite) {
        this.cancel(ignite);
        this.enabled = false;
    }

    public String toString() {
        return S.toString(SnapshotScheduleV2.class, (Object)((Object)this));
    }

    public byte getProtocolVersion() {
        return 5;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.id);
        U.writeString((DataOutput)out, (String)this.name);
        U.writeEnum((DataOutput)out, (Enum)this.opType);
        U.writeString((DataOutput)out, (String)this.fullSnapshotFreq);
        U.writeString((DataOutput)out, (String)this.incSnapshotFreq);
        out.writeObject(this.cacheNames);
        out.writeLong(this.ttl);
        U.writeString((DataOutput)out, (String)this.dest);
        out.writeBoolean(this.enabled);
        out.writeObject(this.snapshotCommonParameters);
        out.writeObject(this.snapshotCreateParameters);
        U.writeString((DataOutput)out, (String)this.keyAlias);
        out.writeObject(this.locSchedules);
        U.writeUuid((DataOutput)out, (UUID)this.nid);
        out.writeInt(this.forOldest);
        out.writeInt(this.forLatest);
        U.writeString((DataOutput)out, (String)this.execAfter);
        out.writeObject(this.taskChain);
        U.writeCollection((ObjectOutput)out, this.followingSchedules);
        out.writeInt(this.keepCount);
        out.writeLong(this.lastFullSnapshotId);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readString((DataInput)in);
        this.name = U.readString((DataInput)in);
        this.opType = SnapshotOperationType.fromOrdinal((int)in.readByte());
        this.fullSnapshotFreq = U.readString((DataInput)in);
        this.incSnapshotFreq = U.readString((DataInput)in);
        this.cacheNames = (Set)in.readObject();
        this.ttl = in.readLong();
        this.dest = U.readString((DataInput)in);
        this.enabled = in.readBoolean();
        this.snapshotCommonParameters = (SnapshotCommonParameters)in.readObject();
        this.snapshotCreateParameters = (SnapshotCreateParameters)in.readObject();
        this.keyAlias = U.readString((DataInput)in);
        this.locSchedules = (List)in.readObject();
        this.nid = U.readUuid((DataInput)in);
        if (protoVer > 1) {
            this.forOldest = in.readInt();
            this.forLatest = in.readInt();
        }
        if (protoVer > 2) {
            this.execAfter = U.readString((DataInput)in);
            this.taskChain = (SnapshotScheduleKey)in.readObject();
            this.followingSchedules = U.readList((ObjectInput)in);
        }
        if (protoVer > 3) {
            this.keepCount = in.readInt();
        }
        if (protoVer > 4) {
            this.lastFullSnapshotId = in.readLong();
        }
    }

    public SnapshotSchedule toV1Format() {
        SnapshotSchedule result = new SnapshotSchedule(this.id, this.name, this.opType, this.fullSnapshotFreq, this.incSnapshotFreq, this.cacheNames, this.ttl, this.dest, this.enabled, this.snapshotCommonParameters, this.snapshotCreateParameters);
        result.getLocSchedules().addAll(this.locSchedules);
        result.setNid(this.nid);
        return result;
    }

    boolean incrementalSnapshotNeeded() {
        long lastRun = this.fullSnapshotTask.lastFinishTime();
        if (lastRun != 0L) {
            long now = System.currentTimeMillis();
            long nextRun = this.fullSnapshotTask.nextExecutionTime();
            long fullSnapshotLastExecutionDuration = lastRun - this.fullSnapshotTask.lastStartTime();
            long duration = Math.max(fullSnapshotLastExecutionDuration, 30000L);
            return !this.fullSnapshotTask.isRunning() && Math.abs(now - lastRun) > duration && (nextRun == 0L || Math.abs(now - nextRun) > duration);
        }
        return !this.fullSnapshotTask.isRunning() && this.lastFullSnapshotId != 0L;
    }
}

