/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.concurrent.locks.LockSupport;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.metric.impl.HitRateMetric;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;

public class SnapshotWriteThrottle {
    private static final int CHECK_INTERVAL_SEC = 4;
    private static final long STARTTING_THROTTLE_NANOS = 4000L;
    private static final long DEFAULT_MAX_THROTTLING_MILLIS = 800L;
    private static final long MAX_THROTTLING_NANOS = U.millisToNanos((long)IgniteSystemProperties.getLong((String)"GG_MAX_SNAPSHOT_WRITE_THROTTLING_MILLIS", (long)800L));
    private static final double BACKOFF_RATIO = 1.05;
    private final int pageSize;
    private volatile int maxBytesPerSecond;
    private HitRateMetric writtenPages = new HitRateMetric("snapshotPagesWrittenCounter", null, 4000L, 16);
    private final SnapshotMetricsMXBeanImpl metricsImpl;

    public SnapshotWriteThrottle(int maxBytesPerSecond, int pageSize, SnapshotMetricsMXBeanImpl metricsImpl) {
        this.maxBytesPerSecond = maxBytesPerSecond;
        this.pageSize = pageSize;
        this.metricsImpl = metricsImpl;
    }

    public void applyThrottlingIfNeeded() {
        int exponent = 0;
        while (this.writtenPages.value() * (long)this.pageSize / 4L > (long)this.maxBytesPerSecond) {
            long throttleParkNanos;
            long nextThrottleStep = (long)(4000.0 * Math.pow(1.05, exponent));
            if (nextThrottleStep < MAX_THROTTLING_NANOS) {
                ++exponent;
                throttleParkNanos = nextThrottleStep;
            } else {
                throttleParkNanos = MAX_THROTTLING_NANOS;
            }
            if (this.metricsImpl != null) {
                this.metricsImpl.incrementWriteThrottlingTime(U.nanosToMillis((long)throttleParkNanos));
            }
            long endTime = System.nanoTime() + throttleParkNanos;
            do {
                LockSupport.parkNanos(throttleParkNanos);
            } while ((throttleParkNanos = endTime - System.nanoTime()) > 0L);
        }
    }

    public void incrementWrittenPages() {
        this.writtenPages.increment();
    }
}

